program test_mod_physunits

   use fml

   use test_aux

   implicit none

   type(mfArray) :: x, y, z, u, dt
   type(mfArray) :: P, area
   type(mfUnit) :: u_Ly

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

   call msUsePhysUnits( "on" )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! msUsePhysUnits ----------------------------------------------------
   call print_separation("using Phys. Units (msUsePhysUnits)")

   print "(/,A)", "*** test number 1 ***"
   call msUsePhysUnits( "off" )

   x = 2.0d0
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 2 ***"
   call msUsePhysUnits( "on" )

   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 3 ***"
   call msUsePhysUnits( "off" )

   call msDisplay( x, "x" )

   ! msSetPhysDim ------------------------------------------------------
   call print_separation("setting Phys. Dim. (msSetPhysDim)")

   call msUsePhysUnits( "on" )

   print "(/,A)", "*** test number 4 ***"
   call msSetPhysDim( x, Mass=1.0d0 )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 5 ***"
   call msSetPhysDim( x, Mass=1.0d0/2, Length=-7.0d0/2, Time=1.0d0/3 )
   call msDisplay( x, "x" )

   y = mfEye(2)
   print "(/,A)", "*** test number 6 ***"
   call msSetPhysDim( y, x )
   call msDisplay( y, "y" )

   ! mfHasNoPhysDim ----------------------------------------------------
   call print_separation("checking Dimensionless (mfHasNoPhysDim)")

   print "()"
   print "(/,A)", "*** test number 7 ***"
   if( mfHasNoPhysDim(x) ) then
      print *, "x is dimensionless <--- failed" ! wrong result
   else
      print *, "x is not dimensionless: ok" ! correct result
   end if

   print "()"
   print "(/,A)", "*** test number 8 ***"
   z = 0.0d0
   if( mfHasNoPhysDim(z) ) then
      print *, "z is dimensionless: ok" ! correct result
   else
      print *, "z is not dimensionless <--- failed" ! wrong result
   end if

   print "()"

   ! msSetPhysDim ------------------------------------------------------
   call print_separation("combining Phys. Dim. (msSetPhysDim)")

   call msDisplay( x, "x" )

   y = 3.0d0
   print "(/,A)", "*** test number 9 ***"
   call msSetPhysDim( y, Mass=1.0d0, Time=-3.0d0 )
   call msDisplay( y, "y" )

   z = 0.1d0*y
   call msDisplay( z, "z" )

   z = y*0.1d0
   call msDisplay( z, "z" )

   z = x*y
   call msDisplay( z, "z" )

   z = 0.1d0/y
   call msDisplay( z, "z" )

   z = y/0.1d0
   call msDisplay( z, "z" )

   z = x/y
   call msDisplay( z, "z" )

   y = x*4.0d0
   z = x + y
   call msDisplay( z, "z" )

   print "(/,A)", "*** test number 10 ***"
   call msSetPhysDim( x, no_dim=.true. )
   z = x + 1.0d0
   call msDisplay( z, "z" )

   z = 1.0d0 + x
   call msDisplay( z, "z" )

   ! setting Phys. Unit ------------------------------------------------
   call print_separation("setting Phys. Unit (msSetPhysDim)")

   ! in two steps

   print "(/,A)", "*** test number 11 ***"
   x = 1.5d0 ! dimensionless initialization
   x = x*u_kg
   call msDisplay( x, "x = x*u_kg (S.I. for Mass)" )

   print "(/,A)", "*** test number 12 ***"
   x = 2.5d0 ! dimensionless initialization
   x = x*u_m
   call msDisplay( x, "x = x*u_m (S.I. for Length)" )

   print "(/,A)", "*** test number 13 ***"
   x = 3.5d0 ! dimensionless initialization
   x = x*u_s
   call msDisplay( x, "x = x*u_s (S.I. for Time)" )

   ! directly

   print "(/,A)", "*** test number 14 ***"
   y = 0.25d0*u_kg
   call msDisplay( y, "y" )

   print "(/,A)", "*** test number 15 ***"
   z = u_s
   call msDisplay( z, "z" )

   ! unary op: -
   y = - u_Newton
   call msDisplay( y, "y" )

   ! displaying in any unit --------------------------------------------
   call print_separation("displaying in any unit (msDisplay)")

   x = u_m

   print "(/,A)", "*** test number 16 ***"
   call msDisplay( x, "x", unit=u_m )

   print "(/,A)", "*** test number 17 ***"
   call msDisplay( x, "x", unit=u_mm )

   print "(/,A)", "*** test number 18 ***"
   call msDisplay( x, "x", unit=u_cm )

   print "(/,A)", "*** test number 19 ***"
   call msDisplay( x, "x", unit=u_km )

!!   call msDisplay( x, "x", unit=u_s ) ! test error

   print "(/,A)", "*** test number 20 ***"
   y = 0.25d0*u_s
   call msDisplay( y, "y", unit=u_s )

!!   call msDisplay( y, "y", unit=u_m ) ! test error

   ! displaying in S.I. unit -------------------------------------------
   call print_separation("displaying in S.I. unit ()")

   print "(/,A)", "*** test number 21 ***"
   x = u_newton ! force
   call msDisplay( x, "force", unit=SI_unit )

   print "(/,A)", "*** test number 22 ***"
   y = u_m
   y = y*y ! area
   call msDisplay( y, "area", unit=SI_unit )

   print "(/,A)", "*** test number 23 ***"
   z = x/y ! pressure
   call msDisplay( z, "pressure", unit=SI_unit )

   ! mfHaveSamePhysDim -------------------------------------------------
   call print_separation("mfHaveSamePhysDim")

   print "()"
   print "(/,A)", "*** test number 24 ***"
   if( mfHaveSamePhysDim(u_m,u_cm) ) then
      print *, "u_m and u_cm have same dimensions: ok"  ! correct result
   else
      print *, "u_m and u_cm have not the same dimensions <--- failed" ! wrong result
   end if

   print "()"
   x = u_m
   call msDisplay( x, "x", unit=u_m )
   print "(/,A)", "*** test number 25 ***"
   if( mfHaveSamePhysDim(x,u_cm) ) then
      print *, "x and u_cm have same dimensions: ok"  ! correct result
   else
      print *, "x and u_cm have not the same dimensions <--- failed" ! wrong result
   end if

   print "()"
   y = u_cm
   call msDisplay( y, "y", unit=u_cm )
   print "(/,A)", "*** test number 26 ***"
   if( mfHaveSamePhysDim(u_m,y) ) then
      print *, "u_m and y have same dimensions: ok"  ! correct result
   else
      print *, "u_m and y have not the same dimensions <--- failed" ! wrong result
   end if

   print "()"
   x = u_m
   call msDisplay( x, "x", unit=u_m )
   y = u_cm
   call msDisplay( y, "y", unit=u_cm )
   print "(/,A)", "*** test number 27 ***"
   if( mfHaveSamePhysDim(x,y) ) then
      print *, "x and y have same dimensions: ok"  ! correct result
   else
      print *, "x and y have not the same dimensions <--- failed" ! wrong result
   end if

   print "()"
   z = u_kg
   call msDisplay( z, "z", unit=u_kg )
   print "(/,A)", "*** test number 28 ***"
   if( mfHaveSamePhysDim(x,z) ) then
      print *, "x and z have same dimension <--- failed"  ! wrong result
   else
      print *, "x and z have not the same dimension: ok" ! correct result
   end if
   print "()"

   ! Physical Constants ------------------------------------------------
   call print_separation("Physical Constants")

   print "()"
   print "(/,A)", "*** test number 29 ***"
   x = c_speed_of_light
   call msDisplay( x, "c_speed_of_light", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 30 ***"
   x = c_Planck
   call msDisplay( x, "c_Planck", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 31 ***"
   x = c_Avogadro
   call msDisplay( x, "c_Avogadro", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 32 ***"
   x = c_universal_gas
   call msDisplay( x, "c_universal_gas", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 33 ***"
   x = c_Boltzmann
   call msDisplay( x, "c_Boltzmann", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 34 ***"
   x = c_electron_charge
   call msDisplay( x, "c_electron_charge", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 35 ***"
   x = c_gravity
   call msDisplay( x, "c_gravity", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 36 ***"
   x = c_gravity_accel
   call msDisplay( x, "c_gravity_accel", unit=SI_unit )

   print "()"
   print "(/,A)", "*** test number 37 ***"
   x = f_kelvin_conversion
   call msDisplay( x, "c_kelvin_conversion", unit=SI_unit )

   ! operator(*) -------------------------------------------------------
   call print_separation("combining mfUnit (operator(*))")

   ! using some user-defined units

   print "(/,A)", "*** test number 38 ***"
   u_Ly = u_calory / u_cm**2 / u_min
   call msSetPhysUnitAbbrev( u_ly, "langley" )
   call msDisplay( 1.95d0 * u_Ly, "1.95d0 * u_Ly", unit=u_Ly )

   print "(/,A)", "*** test number 39 ***"
   P = u_Watt / u_m**2
   call msDisplay( P, "P" )

   print *, "mfHaveSamePhysDim(u_Ly,P): ", mfHaveSamePhysDim(u_Ly,P)

   !------------
   print "(/,A)", "*** test number 40 ***"
   area = 9.0d0 * u_m**2
   call msDisplay( area, "area" )

   print "(/,A)", "*** test number 41 ***"
   x = mfSqrt( area )
   call msDisplay( x, "x" )

   !------------
   print "(/,A)", "*** test number 42 ***"
   x = 2.0d0 * u_m**(0.5d0)
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 43 ***"
   x = u_m**(0.3333d0)
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 44 ***"
   x = u_m**(0.33333d0)
   call msDisplay( x, "x" )

   ! operator(+) -------------------------------------------------------
   call print_separation("combining mfArray/mfUnit (operator(+))")

   print "(/,A)", "*** test number 45 ***"
   ! unary op
   y = + u_Newton
   call msDisplay( y, "y" )

   print "(/,A)", "*** test number 46 ***"
   y = 1.0d0 * u_m
   call msDisplay( y, "y", unit=u_m )
   y = y + 2.5d0*u_cm
   call msDisplay( y, "y + 2.5d0*u_cm", unit=u_m )

   print "(/,A)", "*** test number 47 ***"
   y = 2.5d0*u_cm + y
   call msDisplay( y, "2.5d0*u_cm + y", unit=u_m )

   print "(/,A)", "*** test number 48 ***"
   y = f_kelvin_conversion + 10.0d0*u_K
   call msDisplay( y, "f_kelvin_conversion + 10.0d0*u_K", unit=u_K )

   ! operator(-) -------------------------------------------------------
   call print_separation("combining mfArray/mfUnit (operator(-))")

   print "(/,A)", "*** test number 49 ***"
   ! unary op
   y = - u_Newton
   call msDisplay( y, "y" )

   print "(/,A)", "*** test number 50 ***"
   y = 1.0d0 * u_m
   call msDisplay( y, "y", unit=u_m )
   y = y - 2.5d0*u_cm
   call msDisplay( y, "y - 2.5d0*u_cm", unit=u_m )

   print "(/,A)", "*** test number 51 ***"
   y = 2.5d0*u_cm - y
   call msDisplay( y, "2.5d0*u_cm - y", unit=u_m )

   print "(/,A)", "*** test number 52 ***"
   y = f_kelvin_conversion - 10.0d0*u_K
   call msDisplay( y, "f_kelvin_conversion - 10.0d0*u_K", unit=u_K )

   ! mfGradient --------------------------------------------------------
   call print_separation("mfGradient")

   print "(/,A)", "*** test number 53 ***"
   x = mfLinSpace(0.0d0,1.0d0,4) * u_m
   dt = 1.0d0 * u_s
   u = mfGradient( x, dt )
   call msDisplay( u, "grad_t(x)")

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_physunits ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, z, u, dt )
   call msRelease( P, area )

end program
