program test_mod_fileio

   use fml

   use test_aux

   implicit none

   type(mfArray) :: x, y, magic_501, tri
   type(mfArray) :: A, B, C, D, v, p, RHS

   type(mfTriConnect) :: tri_connect
   type(mfPLdomain) :: PL_domain

   logical :: bool

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(1)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

   ! CPU economy
   magic_501 = mfMagic(501)

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! msSaveAscii -------------------------------------------------------
   call print_separation("msSaveAscii")

   ! empty case
   print "(/,A)", "*** test number 1 ***"
   x = MF_EMPTY
   call msSaveAscii( "MF_EMPTY_tmp.txt", x )
   print *, "(MF_EMPTY_tmp.txt is an Ascii file)"

   ! small array
   print "(/,A)", "*** test number 2 ***"
   x = mfMagic(3)
   call msSaveAscii( "magic_3_tmp.txt", x )
   print *, "(magic_3_tmp.txt is an Ascii file)"

   ! big exponents (exponent greater than +/-100, which usually
   ! lead to the suppression of the "E" letter)
   print "(/,A)", "*** test number 3 ***"
   x = [ 5.0d-95, 5.0d-105, 5.0d95, 5.0d105 ]
   call msSaveAscii( "big_exponent_tmp.txt", x )
   print *, "(big_exponent_tmp.txt is an Ascii file)"

   ! big array
   print "(/,A)", "*** test number 4 ***"
   x = mfMagic(51)
   call msSaveAscii( "magic_51_tmp.txt", x )
   print *, "(magic_51_tmp.txt is an Ascii file)"

!!   ! very big array
!!   call msSaveAscii("magic_501_tmp.txt",magic_501)
!!   print *, "(magic_501_tmp.txt is an Ascii file)"

   ! must get warnings...

   ! ...for a boolean mfArray
   print "(/,A)", "*** test number 5 ***"
   x = mfMagic(3) > 5.0d0
   call msSaveAscii( "bool_tmp.txt", x )
   print *, "(x is a boolean mfArray)"

   ! ...for a complex mfArray
   print "(/,A)", "*** test number 6 ***"
   x = mfOnes(3) + mfEye(3)*MF_I
   call msSaveAscii( "cmplx_tmp.txt", x )
   print *, "(x is a complex mfArray)"

   ! ...or for an mfArray containing not-finite values (Inf, NaN)
   print "(/,A)", "*** test number 7 ***"
   x = mfEye(3) * MF_INF
   call msSet( -MF_INF, x, 2, 2 )
   call msSaveAscii( "inf_nan_tmp.txt", x )
   print *, "(x is an mfArray containing Inf and/or NaN values)"

   !-------------------
   ! using optional arguments

   ! write two matrices in the same file
   print "(/,A)", "*** test number 8 ***"
   x = mfMagic(3)
   call msSaveAscii( "appended_file_tmp.txt", x )
   x = mfMagic(5)
   call msSaveAscii( "appended_file_tmp.txt", x, append=.true. )
   print *, "(two different mfArrays have been written in the same file)"

   ! using user prescribed format
   print "(/,A)", "*** test number 9 ***"
   x = mfMagic(3) / 3.0d0
   call msSaveAscii( "user_formatted_real_tmp.txt", x, format="ES13.6" )
   print *, "(x is a real mfArray, written using a prescribed real format)"

   print "(/,A)", "*** test number 10 ***"
   x = mfMagic(3) * 2.0d0
   call msSaveAscii( "user_formatted_int_tmp.txt", x, format="I3" )
   print *, "(x is a real mfArray, written using a prescribed integer format)"

   !-------------------
   ! permutation vector
   print "(/,A)", "*** test number 11 ***"
   p = mfPerm( mf([ 1, 2, 3, 4, 5 ]) )
   call msSaveAscii( "perm_tmp.txt", p )
!!   print *      ! not required due to the 'info' message displayed.

   ! mfLoadAscii -------------------------------------------------------
   call print_separation("mfLoadAscii")

   ! empty case (1 byte-file)
   print "(/,A)", "*** test number 12 ***"
   x = mfLoadAscii("MF_EMPTY_tmp.txt")
   if( mfIsEqual(x,MF_EMPTY) ) then
      print *, "mfLoadAscii('MF_EMPTY_tmp.txt') : success"
   else
      print *, "mfLoadAscii('MF_EMPTY_tmp.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! empty case (0 byte-file)
   print "(/,A)", "*** test number 13 ***"
   x = mfLoadAscii("data/empty.txt")
   if( mfIsEqual(x,MF_EMPTY) ) then
      print *, "mfLoadAscii('data/empty.txt') : success"
   else
      print *, "mfLoadAscii('data/empty.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! empty case (2 bytes-file DOS)
   print "(/,A)", "*** test number 14 ***"
   x = mfLoadAscii("data/empty_dos.txt")
   if( mfIsEqual(x,MF_EMPTY) ) then
      print *, "mfLoadAscii('data/empty_dos.txt') : success"
   else
      print *, "mfLoadAscii('data/empty_dos.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! small array
   print "(/,A)", "*** test number 15 ***"
   x = mfLoadAscii("magic_3_tmp.txt")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoadAscii('magic_3_tmp.txt') : success"
   else
      print *, "mfLoadAscii('magic_3_tmp.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! big exponents
   print "(/,A)", "*** test number 16 ***"
   y = [ 5.0d-95, 5.0d-105, 5.0d95, 5.0d105 ]
   x = mfLoadAscii("big_exponent_tmp.txt")
   if( mfIsEqual(x,y) ) then
      print *, "mfLoadAscii('big_exponent_tmp.txt') : success"
   else
      print *, "mfLoadAscii('big_exponent_tmp.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! big array
   print "(/,A)", "*** test number 17 ***"
   x = mfLoadAscii("magic_51_tmp.txt")
   if( mfIsEqual(x,mfMagic(51)) ) then
      print *, "mfLoadAscii('magic_51_tmp.txt') : success"
   else
      print *, "mfLoadAscii('magic_51_tmp.txt') : failed ! <----- ?????"
      call msPause()
   end if

!!   ! very big array
!!   x = mfLoadAscii("magic_501_tmp.txt")
!!   if( mfIsEqual(x,magic_501) ) then
!!      print *, "mfLoadAscii('magic_501_tmp.txt') : success"
!!   else
!!      print *, "mfLoadAscii('magic_501_tmp.txt') : failed ! <----- ?????"
!!   end if

   ! mfArray containing not-finite values (Inf, NaN)
   print "(/,A)", "*** test number 18 ***"
   x = mfEye(3) * MF_INF
   call msDisplay( x, "inf_nan_tmp = mfEye(3) * MF_INF" )
   y = mfLoadAscii("inf_nan_tmp.txt",ieee=.true.)
   call msDisplay( y, "mfLoadAscii('inf_nan_tmp.txt',ieee=.true.)" )

   ! read an ASCII file with commented lines
   print "(/,A)", "*** test number 19 ***"
   x = mfLoadAscii("data/magic_3_comment.txt",comment="#")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoadAscii('data/magic_3_comment.txt') : success"
   else
      print *, "mfLoadAscii('data/magic_3_comment.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file with tabulations and commented lines
   print "(/,A)", "*** test number 20 ***"
   x = mfLoadAscii("data/magic_3_comment_tab.txt",comment="#")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoadAscii('data/magic_3_comment_tab.txt') : success"
   else
      print *, "mfLoadAscii('data/magic_3_comment_tab.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file with commented lines and DOS line termination
   print "(/,A)", "*** test number 21 ***"
   x = mfLoadAscii("data/magic_3_comment_dos.txt",comment="#")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoadAscii('data/magic_3_comment_dos.txt') : success"
   else
      print *, "mfLoadAscii('data/magic_3_comment_dos.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file under a non rectangular layout
   print "(/,A)", "*** test number 22 ***"
   x = mfLoadAscii("data/data_non_rect.txt",rect=.false.)
   y = .t. mf( [ 1, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 4, 6, 4, 1 ] )
   if( mfIsEqual(x,y) ) then
      print *, "mfLoadAscii('data/data_non_rect.txt') : success"
   else
      print *, "mfLoadAscii('data/data_non_rect.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file under a non rectangular layout and DOS line
   ! termination
   print "(/,A)", "*** test number 23 ***"
   x = mfLoadAscii("data/data_non_rect_dos.txt",rect=.false.)
   y = .t. mf( [ 1, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 4, 6, 4, 1 ] )
   if( mfIsEqual(x,y) ) then
      print *, "mfLoadAscii('data/data_non_rect_dos.txt') : success"
   else
      print *, "mfLoadAscii('data/data_non_rect_dos.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file under a non rectangular layout, and with commented lines
   print "(/,A)", "*** test number 24 ***"
   x = mfLoadAscii("data/data_non_rect_comment.txt",rect=.false.,comment="#")
   y = .t. mf( [ 1, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 4, 6, 4, 1 ] )
   if( mfIsEqual(x,y) ) then
      print *, "mfLoadAscii('data/data_non_rect_comment.txt') : success"
   else
      print *, "mfLoadAscii('data/data_non_rect_comment.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! read an ASCII file under a non rectangular layout, DOS line, and with commented lines
   ! termination
   print "(/,A)", "*** test number 25 ***"
   x = mfLoadAscii("data/data_non_rect_dos_comment.txt",rect=.false.,comment="#")
   y = .t. mf( [ 1, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 4, 6, 4, 1 ] )
   if( mfIsEqual(x,y) ) then
      print *, "mfLoadAscii('data/data_non_rect_dos_comment.txt') : success"
   else
      print *, "mfLoadAscii('data/data_non_rect_dos_comment.txt') : failed ! <----- ?????"
      call msPause()
   end if

   ! permutation vector
   print "(/,A)", "*** test number 26 ***"
   print "()"
   p = mfLoadAscii( "perm_tmp.txt" )
   print *, "p is perm ? = ", mfIsPerm(p)
   print "()"
   print *, " -> previous answer should be FALSE, because the PERM_VEC property"
   print *, "    of the mfArray is lost when using an ASCII file."
   call msDisplay( p, "p" )

   ! msSave ------------------------------------------------------------
   call print_separation("msSave")

   ! empty case
   print "(/,A)", "*** test number 27 ***"
   x = MF_EMPTY
   call msSave("MF_EMPTY_tmp.mbf",x)
   print *, "(MF_EMPTY_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 28 ***"
   call msSave("MF_EMPTY_tmp.mbf.gz",x)
   print *, "(MF_EMPTY_tmp.mbf.gz is a Compressed Binary file)"

   ! small array
   print "(/,A)", "*** test number 29 ***"
   x = mfMagic(3)
   call msSave("magic_3_tmp.mbf",x)
   print *, "(magic_3_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 30 ***"
   call msSave("magic_3_tmp.mbf.gz",x)
   print *, "(magic_3_tmp.mbf.gz is a Compressed Binary file)"

   ! big array
   print "(/,A)", "*** test number 31 ***"
   x = mfMagic(51)
   call msSave("magic_51_tmp.mbf",x)
   print *, "(magic_51_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 32 ***"
   call msSave("magic_51_tmp.mbf.gz",x)
   print *, "(magic_51_tmp.mbf.gz is a Compressed Binary file)"

!!   ! very big array
!!   call msSave("magic_501_tmp.mbf",magic_501)
!!   print *, "(magic_501_tmp.mbf is a Binary file)"

!!   ! compressed output via zlib (gzip algo)
!!   call msSave("magic_501_tmp.mbf.gz",magic_501)
!!   print *, "(magic_501_tmp.mbf.gz is a Compressed Binary file)"

   ! mfArray containing not-finite values (Inf, NaN)
   print "(/,A)", "*** test number 33 ***"
   x = mfEye(3) * MF_INF
   call msSave("inf_nan_3_tmp.mbf",x)
   print *, "(inf_nan_3_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 34 ***"
   call msSave("inf_nan_3_tmp.mbf.gz",x)
   print *, "(inf_nan_3_tmp.mbf.gz is a Compressed Binary file)"

   ! boolean mfArray
   print "(/,A)", "*** test number 35 ***"
   x = mfMagic(3) > 5.0d0
   call msSave("bool_3_tmp.mbf",x)
   print *, "(bool_3_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 36 ***"
   call msSave("bool_3_tmp.mbf.gz",x)
   print *, "(bool_3_tmp.mbf.gz is a Compressed Binary file)"

   ! complex mfArray
   print "(/,A)", "*** test number 37 ***"
   x = mfOnes(3) + mfEye(3)*MF_I
   call msSave("cmplx_3_tmp.mbf",x)
   print *, "(cmplx_3_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 38 ***"
   call msSave("cmplx_3_tmp.mbf.gz",x)
   print *, "(cmplx_3_tmp.mbf.gz is a Compressed Binary file)"

   ! real sparse mfArray
   print "(/,A)", "*** test number 39 ***"
   A = mfLoadSparse("data/A.csc")
   call msSave("A_sparse_tmp.mbf",A)
   print *, "(A_sparse_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 40 ***"
   call msSave("A_sparse_tmp.mbf.gz",A)
   print *, "(A_sparse_tmp.mbf.gz is a Compressed Binary file)"

   ! real sparse big mfArray
   print "(/,A)", "*** test number 41 ***"
   A = mfLoadSparse("data/aglo.mtx")
   call msSave("aglo_sparse_tmp.mbf",A)
   print *, "(aglo_sparse_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 42 ***"
   call msSave("aglo_sparse_tmp.mbf.gz",A)
   print *, "(aglo_sparse_tmp.mbf.gz is a Compressed Binary file)"
   ! for comparing file size with HBO format
   call msSaveSparse("aglo_sparse_tmp.hbo",A,format="hbo")

   ! complex sparse
   print "(/,A)", "*** test number 43 ***"
   B = mfLoadSparse("data/mm_cmplx_gene.mtx")
   call msSave("cmplx_sparse_tmp.mbf",B)
   print *, "(cmplx_sparse_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 44 ***"
   call msSave("cmplx_sparse_tmp.mbf.gz",B)
   print *, "(cmplx_sparse_tmp.mbf.gz is a Compressed Binary file)"

   ! with Physical Units
   call msUsePhysUnits( "on" )

   ! real physical mfArray
   print "(/,A)", "*** test number 45 ***"
   x = c_universal_gas
   call msSave("phys_units_tmp.mbf",x)
   print *, "(phys_units_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 46 ***"
   call msSave("phys_units_tmp.mbf.gz",x)
   print *, "(phys_units_tmp.mbf.gz is a Compressed Binary file)"

   ! complex physical mfArray
   print "(/,A)", "*** test number 47 ***"
   x = mf(c_universal_gas)*MF_I
   call msSave("cmplx_pu_tmp.mbf",x)
   print *, "(cmplx_pu_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 48 ***"
   call msSave("cmplx_pu_tmp.mbf.gz",x)
   print *, "(cmplx_pu_tmp.mbf.gz is a Compressed Binary file)"

   ! real sparse physical mfArray
   print "(/,A)", "*** test number 49 ***"
   x = mfSpEye(3)*c_universal_gas
   call msSave("sparse_pu_tmp.mbf",x)
   print *, "(sparse_pu_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 50 ***"
   call msSave("sparse_pu_tmp.mbf.gz",x)
   print *, "(sparse_pu_tmp.mbf.gz is a Compressed Binary file)"

   ! complex sparse physical mfArray
   print "(/,A)", "*** test number 51 ***"
   x = (mfSpEye(3)*MF_I)*c_universal_gas
   call msSave("sparse_cmplx_pu_tmp.mbf",x)
   print *, "(sparse_cmplx_pu_tmp.mbf is a Binary file)"

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 52 ***"
   call msSave("sparse_cmplx_pu_tmp.mbf.gz",x)
   print *, "(sparse_cmplx_pu_tmp.mbf.gz is a Compressed Binary file)"

   call msUsePhysUnits( "off" )

   ! permutation vector
   print "(/,A)", "*** test number 53 ***"
   p = mfPerm( mf([ 1, 2, 3, 4, 5 ]) )
   call msSave( "perm_tmp.mbf", p )


   print "(/,A)", "*** test number 54 ***"
   p = mfPerm( mf([ 1, 2, 3, 4, 5 ]) )
   call msSave( "perm_tmp.mbf.gz", p )
   print "()"

   ! mfLoad ------------------------------------------------------------
   call print_separation("mfLoad")

   ! empty case
   print "(/,A)", "*** test number 55 ***"
   x = mfLoad("MF_EMPTY_tmp.mbf")
   if( mfIsEqual(x,MF_EMPTY) ) then
      print *, "mfLoad('MF_EMPTY_tmp.mbf') : success"
   else
      print *, "mfLoad('MF_EMPTY_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 56 ***"
   x = mfLoad("MF_EMPTY_tmp.mbf.gz")
   if( mfIsEqual(x,MF_EMPTY) ) then
      print *, "mfLoad('MF_EMPTY_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('MF_EMPTY_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! small array
   print "(/,A)", "*** test number 57 ***"
   x = mfLoad("magic_3_tmp.mbf")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('magic_3_tmp.mbf') : success"
   else
      print *, "mfLoad('magic_3_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 58 ***"
   x = mfLoad("magic_3_tmp.mbf.gz")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('magic_3_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('magic_3_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! big array
   print "(/,A)", "*** test number 59 ***"
   x = mfLoad("magic_51_tmp.mbf")
   if( mfIsEqual(x,mfMagic(51)) ) then
      print *, "mfLoad('magic_51_tmp.mbf') : success"
   else
      print *, "mfLoad('magic_51_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 60 ***"
   x = mfLoad("magic_51_tmp.mbf.gz")
   if( mfIsEqual(x,mfMagic(51)) ) then
      print *, "mfLoad('magic_51_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('magic_51_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

!!   ! very big array
!!   x = mfLoad("magic_501_tmp.mbf")
!!   if( mfIsEqual(x,magic_501) ) then
!!      print *, "mfLoad('magic_501_tmp.mbf') : success"
!!   else
!!      print *, "mfLoad('magic_501_tmp.mbf') : failed ! <----- ?????"
!!      call msPause()
!!   end if

!!   ! compressed read via zlib (gzip algo)
!!   x = mfLoad("magic_501_tmp.mbf.gz")
!!   if( mfIsEqual(x,magic_501) ) then
!!      print *, "mfLoad('magic_501_tmp.mbf.gz') : success"
!!   else
!!      print *, "mfLoad('magic_501_tmp.mbf.gz') : failed ! <----- ?????"
!!      call msPause()
!!   end if

   ! mfArray containing not-finite values (Inf, NaN)
   print "(/,A)", "*** test number 61 ***"
   x = mfEye(3) * MF_INF
   call msDisplay( x, "inf_nan_3_tmp = mfEye(3) * MF_INF" )
   y = mfLoad("inf_nan_3_tmp.mbf")
   call msDisplay( y, "mfLoad('inf_nan_3_tmp.mbf')" )

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 62 ***"
   y = mfLoad("inf_nan_3_tmp.mbf.gz")
   call msDisplay( y, "mfLoad('inf_nan_3_tmp.mbf.gz')" )

   ! boolean mfArray
   print "(/,A)", "*** test number 63 ***"
   x = mfLoad("bool_3_tmp.mbf")
   y = mfMagic(3) > 5.0d0
   if( All(x.eqv.y) ) then
      print *, "mfLoad('bool_3_tmp.mbf') : success"
   else
      print *, "mfLoad('bool_3_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 64 ***"
   x = mfLoad("bool_3_tmp.mbf.gz")
   if( All(x.eqv.y) ) then
      print *, "mfLoad('bool_3_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('bool_3_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex mfArray
   print "(/,A)", "*** test number 65 ***"
   x = mfLoad("cmplx_3_tmp.mbf")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('cmplx_3_tmp.mbf') : success"
   else
      print *, "mfLoad('cmplx_3_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 66 ***"
   x = mfLoad("cmplx_3_tmp.mbf.gz")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('cmplx_3_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('cmplx_3_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! real sparse mfArray
   print "(/,A)", "*** test number 67 ***"
   A = mfLoad("A_sparse_tmp.mbf")
   x = mfLoadSparse("data/A.csc")
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('A_sparse_tmp.mbf') : success"
   else
      print *, "mfLoad('A_sparse_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 68 ***"
   A = mfLoad("A_sparse_tmp.mbf.gz")
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('A_sparse_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('A_sparse_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! real sparse big mfArray
   print "(/,A)", "*** test number 69 ***"
   A = mfLoad("aglo_sparse_tmp.mbf")
   x = mfLoadSparse("data/aglo.mtx")
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('aglo_sparse_tmp.mbf') : success"
   else
      print *, "mfLoad('aglo_sparse_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 70 ***"
   A = mfLoad("aglo_sparse_tmp.mbf.gz")
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('aglo_sparse_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('aglo_sparse_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex sparse
   print "(/,A)", "*** test number 71 ***"
   B = mfLoad("cmplx_sparse_tmp.mbf")
   x = mfLoadSparse("data/mm_cmplx_gene.mtx")
   if( mfIsEqual(B,x) ) then
      print *, "mfLoad('cmplx_sparse_tmp.mbf') : success"
   else
      print *, "mfLoad('cmplx_sparse_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 72 ***"
   B = mfLoad("cmplx_sparse_tmp.mbf.gz")
   if( mfIsEqual(B,x) ) then
      print *, "mfLoad('cmplx_sparse_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('cmplx_sparse_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! with Physical Units
   call msUsePhysUnits( "on" )

   ! real physical mfArray
   print "(/,A)", "*** test number 73 ***"
   x = mfLoad("phys_units_tmp.mbf")
   y = c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('phys_units_tmp.mbf') : success"
   else
      print *, "mfLoad('phys_units_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 74 ***"
   x = mfLoad("phys_units_tmp.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('phys_units_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('phys_units_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex physical mfArray
   print "(/,A)", "*** test number 75 ***"
   x = mfLoad("cmplx_pu_tmp.mbf")
   y = mf(c_universal_gas)*MF_I
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('cmplx_pu_tmp.mbf') : success"
   else
      print *, "mfLoad('cmplx_pu_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 76 ***"
   x = mfLoad("cmplx_pu_tmp.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('cmplx_pu_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('cmplx_pu_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! real sparse physical mfArray
   print "(/,A)", "*** test number 77 ***"
   x = mfLoad("sparse_pu_tmp.mbf")
   y = mfSpEye(3)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('sparse_pu_tmp.mbf') : success"
   else
      print *, "mfLoad('sparse_pu_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 78 ***"
   x = mfLoad("sparse_pu_tmp.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('sparse_pu_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('sparse_pu_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex sparse physical mfArray
   print "(/,A)", "*** test number 79 ***"
   x = mfLoad("sparse_cmplx_pu_tmp.mbf")
   y = (mfSpEye(3)*MF_I)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('sparse_cmplx_pu_tmp.mbf') : success"
   else
      print *, "mfLoad('sparse_cmplx_pu_tmp.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 80 ***"
   x = mfLoad("sparse_cmplx_pu_tmp.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('sparse_cmplx_pu_tmp.mbf.gz') : success"
   else
      print *, "mfLoad('sparse_cmplx_pu_tmp.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   call msUsePhysUnits( "off" )

   ! -----> old MBF format 2.3 <-----

   ! little-endian arch
   print "(/,A)", "*** test number 81 ***"
   x = mfLoad("data/magic_3_little-endian.mbf")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('data/magic_3_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/magic_3_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 82 ***"
   x = mfLoad("data/magic_3_little-endian.mbf.gz")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('data/magic_3_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/magic_3_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! little-endian arch
   print "(/,A)", "*** test number 83 ***"
   x = mfLoad("data/cmplx_3_little-endian.mbf")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('data/cmplx_3_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/cmplx_3_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 84 ***"
   x = mfLoad("data/cmplx_3_little-endian.mbf.gz")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('data/cmplx_3_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/cmplx_3_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! little-endian arch with Physical Units
   call msUsePhysUnits( "on" )
   ! real physical mfArray
   print "(/,A)", "*** test number 85 ***"
   x = mfLoad("data/phys_units_little-endian.mbf")
   y = c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/phys_units_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/phys_units_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 86 ***"
   x = mfLoad("data/phys_units_little-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/phys_units_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/phys_units_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex physical mfArray
   print "(/,A)", "*** test number 87 ***"
   x = mfLoad("data/cmplx_pu_little-endian.mbf")
   y = mf(c_universal_gas)*MF_I
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/cmplx_pu_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/cmplx_pu_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 88 ***"
   x = mfLoad("data/cmplx_pu_little-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/cmplx_pu_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/cmplx_pu_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! real sparse physical mfArray
   print "(/,A)", "*** test number 89 ***"
   x = mfLoad("data/sparse_pu_little-endian.mbf")
   y = mfSpEye(3)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_pu_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/sparse_pu_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 90 ***"
   x = mfLoad("data/sparse_pu_little-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_pu_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/sparse_pu_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex sparse physical mfArray
   print "(/,A)", "*** test number 91 ***"
   x = mfLoad("data/sparse_cmplx_pu_little-endian.mbf")
   y = (mfSpEye(3)*MF_I)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_cmplx_pu_little-endian.mbf') : success"
   else
      print *, "mfLoad('data/sparse_cmplx_pu_little-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 92 ***"
   x = mfLoad("data/sparse_cmplx_pu_little-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_cmplx_pu_little-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/sparse_cmplx_pu_little-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if
   call msUsePhysUnits( "off" )

   ! big-endian arch
   print "(/,A)", "*** test number 93 ***"
   x = mfLoad("data/magic_3_big-endian.mbf")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('data/magic_3_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/magic_3_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 94 ***"
   x = mfLoad("data/magic_3_big-endian.mbf.gz")
   if( mfIsEqual(x,mfMagic(3)) ) then
      print *, "mfLoad('data/magic_3_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/magic_3_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! big-endian arch
   print "(/,A)", "*** test number 95 ***"
   x = mfLoad("data/cmplx_3_big-endian.mbf")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('data/cmplx_3_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/cmplx_3_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed read via zlib (gzip algo)
   print "(/,A)", "*** test number 96 ***"
   x = mfLoad("data/cmplx_3_big-endian.mbf.gz")
   if( mfIsEqual(x,mfOnes(3) + mfEye(3)*MF_I) ) then
      print *, "mfLoad('data/cmplx_3_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/cmplx_3_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! big-endian arch with Physical Units
   call msUsePhysUnits( "on" )
   ! real physical mfArray
   print "(/,A)", "*** test number 97 ***"
   x = mfLoad("data/phys_units_big-endian.mbf")
   y = c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/phys_units_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/phys_units_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 98 ***"
   x = mfLoad("data/phys_units_big-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/phys_units_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/phys_units_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex physical mfArray
   print "(/,A)", "*** test number 99 ***"
   x = mfLoad("data/cmplx_pu_big-endian.mbf")
   y = mf(c_universal_gas)*MF_I
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/cmplx_pu_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/cmplx_pu_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 100 ***"
   x = mfLoad("data/cmplx_pu_big-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/cmplx_pu_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/cmplx_pu_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! real sparse physical mfArray
   print "(/,A)", "*** test number 101 ***"
   x = mfLoad("data/sparse_pu_big-endian.mbf")
   y = mfSpEye(3)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_pu_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/sparse_pu_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 102 ***"
   x = mfLoad("data/sparse_pu_big-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_pu_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/sparse_pu_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   ! complex sparse physical mfArray
   print "(/,A)", "*** test number 103 ***"
   x = mfLoad("data/sparse_cmplx_pu_big-endian.mbf")
   y = (mfSpEye(3)*MF_I)*c_universal_gas
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_cmplx_pu_big-endian.mbf') : success"
   else
      print *, "mfLoad('data/sparse_cmplx_pu_big-endian.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   ! compressed output via zlib (gzip algo)
   print "(/,A)", "*** test number 104 ***"
   x = mfLoad("data/sparse_cmplx_pu_big-endian.mbf.gz")
   if( mfIsEqual(x,y) .and. mfHaveSamePhysDim(x,y) ) then
      print *, "mfLoad('data/sparse_cmplx_pu_big-endian.mbf.gz') : success"
   else
      print *, "mfLoad('data/sparse_cmplx_pu_big-endian.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if
   call msUsePhysUnits( "off" )

   ! last test: 8 bytes aligned data in MBF
   call msUsePhysUnits( "on" )
   print "(/,A)", "*** test number 105 ***"
   y = mfLoad("data/align_8_bytes_big-endian.mbf")
   call msDisplay(y,"data/align_8_bytes_big-endian.mbf")
   print "(/,A)", "*** test number 106 ***"

   y = mfLoad("data/align_8_bytes_big-endian.mbf.gz")
   call msDisplay(y,"data/align_8_bytes_big-endian.mbf.gz")
   print "(/,A)", "*** test number 107 ***"
   y = mfLoad("data/align_8_bytes_little-endian.mbf")
   call msDisplay(y,"data/align_8_bytes_little-endian.mbf")
   print "(/,A)", "*** test number 108 ***"

   y = mfLoad("data/align_8_bytes_little-endian.mbf.gz")
   call msDisplay(y,"data/align_8_bytes_little-endian.mbf.gz")
   call msUsePhysUnits( "off" )

   ! permutation vector
   print "(/,A)", "*** test number 109 ***"
   p = mfLoad( "perm_tmp.mbf" )
   print *, "p is perm ? = ", mfIsPerm(p)
   call msDisplay( p, "p" )


   print "(/,A)", "*** test number 110 ***"
   p = mfLoad( "perm_tmp.mbf.gz" )
   print *, "p is perm ? = ", mfIsPerm(p)
   call msDisplay( p, "p" )

   ! -----> new MBF format 2.4 <-----
   ! (stores all the four matrix properties: TRIL, TRIU, SYMM, POSD
   !  whereas MBF format 2.3 stores only SYMM and POSD)

   call msAssign( A, mfTril(mfMagic(3))+mfTril(mfMagic(3)) )
   ! keep the following inquiring to force a property change!
   print *, "mfIsTriu(A) = ", mfIsTriu(A) ! should give F (false)

   print "(/,A)", "*** test number 111 ***"
   x = mfLoad( "data/A_little-endian_format-2.4.mbf" )
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('data/A_little-endian_format-2.4.mbf') : success"
   else
      print *, "mfLoad('data/A_little-endian_format-2.4.mbf') : failed ! <----- ?????"
      call msPause()
   end if

   print "(/,A)", "*** test number 112 ***"
   x = mfLoad( "data/A_big-endian_format-2.4.mbf" )
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('data/A_big-endian_format-2.4.mbf') : success"
   else
      print *, "mfLoad('data/A_big-endian_format-2.4.mbf') : failed ! <----- ?????"
      call msPause()
   end if


   print "(/,A)", "*** test number 113 ***"
   x = mfLoad( "data/A_little-endian_format-2.4.mbf.gz" )
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('data/A_little-endian_format-2.4.mbf.gz') : success"
   else
      print *, "mfLoad('data/A_little-endian_format-2.4.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if

   print "(/,A)", "*** test number 114 ***"
   x = mfLoad( "data/A_big-endian_format-2.4.mbf.gz" )
   if( mfIsEqual(A,x) ) then
      print *, "mfLoad('data/A_big-endian_format-2.4.mbf.gz') : success"
   else
      print *, "mfLoad('data/A_big-endian_format-2.4.mbf.gz') : failed ! <----- ?????"
      call msPause()
   end if
   print "()"

#ifdef _HDF5
   ! msSaveHDF5 --------------------------------------------------------
   call print_separation("msSaveHDF5")

   ! should never raise an error, even if the file previously exists
   print "(/,A)", "*** test number 115 ***"
   call msSaveHDF5( "magic_5_tmp.h5", mfRand(40) ) ! TRUNC
   print *, "(magic_5_tmp.h5 written [TRUNC mode])"

!!   call msSaveHDF5( "magic_5_tmp.h5", mfMagic(5),                       &
!!                    file_access="append" ) ! should raise an error

   print "(/,A)", "*** test number 116 ***"
   call msSaveHDF5( "magic_5_tmp.h5", mfMagic(5),                       &
                    file_access="append", mfarray_overwrite=.true. )
   print *, "(magic_5_tmp.h5 appended, [mfarray overwritten])"

   ! we store the same mfArray under a new name
   print "(/,A)", "*** test number 117 ***"
   call msSaveHDF5( "magic_5_tmp.h5", mfMagic(5), name="mfMagic(5)",    &
                    file_access="append", mfarray_overwrite=.true. )
   print *, "(magic_5_tmp.h5 appended, [new mfarray added])"

   print "(/,A)", "*** test number 118 ***"
   call msSaveHDF5( "tril_tmp.h5", mfTril(mfMagic(5)) )
   print *, "(tril_tmp.h5 written)"

   print "(/,A)", "*** test number 119 ***"
   call msSaveHDF5( "triu_tmp.h5", mfTriu(mfMagic(5)) )
   print *, "(triu_tmp.h5 written)"

   print "(/,A)", "*** test number 120 ***"
   call msSaveHDF5( "diag_tmp.h5", mfDiag(mfDiag(mfMagic(5))) )
   print *, "(diag_tmp.h5 written)"

   print "(/,A)", "*** test number 121 ***"
   call msSaveHDF5( "row_vector_tmp.h5", mfOnes(1,5) )
   print *, "(row_vector_tmp.h5 written)"

   print "(/,A)", "*** test number 122 ***"
   call msSaveHDF5( "col_vector_tmp.h5", mfOnes(5,1) )
   print *, "(col_vector_tmp.h5 written)"

   print "(/,A)", "*** test number 123 ***"
   call msSaveHDF5( "cmplx_5_tmp.h5", mfMagic(5)+mfEye(5)*MF_I )
   print *, "(cmplx_5_tmp.h5 written)"

   print "(/,A)", "*** test number 124 ***"
   call msSaveHDF5( "sparse_5_tmp.h5", mfSpEye(5) )
   print *, "(sparse_5_tmp.h5 written)"

   print "(/,A)", "*** test number 125 ***"
   call msSaveHDF5( "sparse_cmplx_5_tmp.h5", mfSpEye(5)*MF_I )
   print *, "(sparse_cmplx_5_tmp.h5 written)"

   ! using physical units
   call msUsePhysUnits( "on" )

   print "(/,A)", "*** test number 126 ***"
   x = mfColon( 1, 5 ) * u_Pascal
   call msSaveHDF5( "pressure_tmp.h5", x )
   print *, "(pressure_tmp.h5 written)"

   call msUsePhysUnits( "off" )

   ! permutation vector
   print "(/,A)", "*** test number 127 ***"
   p = mfLoad( "data/perm_vec.mbf" )
   call msSaveHDF5( "perm_tmp.h5", p )
   print *, "(perm_tmp.h5 written)"

   print "()"

   ! mfLoadHDF5 --------------------------------------------------------
   call print_separation("mfLoadHDF5")

   print "(/,A)", "*** test number 128 ***"
   x = mfLoadHDF5( "data/eye_7.h5", name="mfEye(7)" )
   if( mfIsEqual(x,mfEye(7)) ) then
      print *, "mfLoadHDF5('data/eye_7.h5') : success"
   else
      print *, "mfLoadHDF5('data/eye_7.h5') : failed ! <----- ?????"
      call msPause()
   end if

   ! don't know how the group is called
   print "(/,A)", "*** test number 129 ***"
   x = mfLoadHDF5( "magic_5_tmp.h5" )
   if( mfIsEqual(x,mfMagic(5)) ) then
      print *, "mfLoadHDF5('magic_5_tmp.h5') : success"
   else
      print *, "mfLoadHDF5('magic_5_tmp.h5') : failed ! <----- ?????"
      call msPause()
   end if

   print "(/,A)", "*** test number 130 ***"
   x = mfLoadHDF5( "cmplx_5_tmp.h5" )
   if( mfIsEqual(x,mfMagic(5)+mfEye(5)*MF_I) ) then
      print *, "mfLoadHDF5('cmplx_5_tmp.h5') : success"
   else
      print *, "mfLoadHDF5('cmplx_5_tmp.h5') : failed ! <----- ?????"
      call msPause()
   end if

   print "(/,A)", "*** test number 131 ***"
   x = mfLoadHDF5( "sparse_5_tmp.h5" )
   if( mfIsEqual(x,mfSpEye(5)) ) then
      print *, "mfLoadHDF5('sparse_5_tmp.h5') : success"
   else
      print *, "mfLoadHDF5('sparse_5_tmp.h5') : failed ! <----- ?????"
      call msPause()
   end if

   print "(/,A)", "*** test number 132 ***"
   x = mfLoadHDF5( "sparse_cmplx_5_tmp.h5" )
   if( mfIsEqual(x,mfSpEye(5)*MF_I) ) then
      print *, "mfLoadHDF5('sparse_cmplx_5_tmp.h5') : success"
   else
      print *, "mfLoadHDF5('sparse_cmplx_5_tmp.h5') : failed ! <----- ?????"
      call msPause()
   end if

   ! using physical units
   call msUsePhysUnits( "on" )

   print "(/,A)", "*** test number 133 ***"
   x = mfLoadHDF5( "pressure_tmp.h5" )
   if( mfIsEqual(x,mfColon(1,5)*u_Pascal) .and.                         &
       mfHaveSamePhysDim(x,u_Pascal) ) then
      print *, "mfLoadHDF5('pressure_tmp.h5') : success"
   else
      print *, "mfLoadHDF5('pressure_tmp.h5') : failed ! <----- ?????"
      call msPause()
   end if

   call msUsePhysUnits( "off" )

   print "()"
#endif

   ! mfLoadSparse, msSaveSparse ----------------------------------------
   call print_separation("mfLoadSparse, msSaveSparse")

   !-- CSC format

   print *, "loading 'data/A.csc' ..."
   print "(/,A)", "*** test number 134 ***"
   A = mfLoadSparse("data/A.csc",format="CSC")
   call msDisplay(mfFull(A),"Sparse matrix from smlib-poisson ex.")

   print *, "loading 'data/B.csc' ..."
   print "(/,A)", "*** test number 135 ***"
   B = mfLoadSparse("data/B.csc",format="CSC")
   call msDisplay(mfNnz(B), "mfNnz(B.csc)")
   call msDisplay(mfNzmax(B), "mfNzmax(B.csc)")
   print "()"

   print *, "saving 'B' in 'B_tmp.csc' ..."
   print "(/,A)", "*** test number 136 ***"
   call msSaveSparse("B_tmp.csc",B,format="CSC")
   C = mfLoadSparse("B_tmp.csc",format="CSC")
   D = B - C
   if( mfNnz(D) == 0 ) then
      print *, "read/write CSC format : ok"
   else
      print *, "read/write CSC format : failed ! <----- ?????"
   end if
   print "()"

   !-- CSR format

   print *, "loading 'data/D.csr' ..."
   print "(/,A)", "*** test number 137 ***"
   A = mfLoadSparse("data/D.csr",format="CSR")
   call msDisplay(mfFull(A),"Sparse matrix in CSR format: D")
   print "()"

   print *, "loading 'data/E.csr' ..."
   print "(/,A)", "*** test number 138 ***"
   B = mfLoadSparse("data/E.csr",format="CSR")
   call msDisplay(mfFull(B),"Sparse matrix in CSR format: E")
   print "()"

   print *, "saving 'E' in 'E_tmp.csr' ..."
   print "(/,A)", "*** test number 139 ***"
   call msSaveSparse("E_tmp.csr",B,format="CSR")
   C = mfLoadSparse("E_tmp.csr",format="CSR")
   D = B - C
   if( mfNnz(D) == 0 ) then
      print *, "read/write CSR format : ok"
   else
      print *, "read/write CSR format : failed ! <----- ?????"
      call msPause()
   end if
   print "()"

   !-- MTX format

   print *, "reading: data/mm_real_gene.mtx ..."
   print "(/,A)", "*** test number 140 ***"
   A = mfLoadSparse( "data/mm_real_gene.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_real_symm.mtx ..."
   print "(/,A)", "*** test number 141 ***"
   A = mfLoadSparse( "data/mm_real_symm.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_real_skew.mtx ..."
   print "(/,A)", "*** test number 142 ***"
   A = mfLoadSparse( "data/mm_real_skew.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_cmplx_gene.mtx ..."
   print "(/,A)", "*** test number 143 ***"
   A = mfLoadSparse( "data/mm_cmplx_gene.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_cmplx_symm.mtx ..."
   print "(/,A)", "*** test number 144 ***"
   A = mfLoadSparse( "data/mm_cmplx_symm.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_cmplx_skew.mtx ..."
   print "(/,A)", "*** test number 145 ***"
   A = mfLoadSparse( "data/mm_cmplx_skew.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   print *, "reading: data/mm_cmplx_herm.mtx ..."
   print "(/,A)", "*** test number 146 ***"
   A = mfLoadSparse( "data/mm_cmplx_herm.mtx", format="MTX" )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "mfFull(A)")

   ! real general
   print "(/,A)", "*** test number 147 ***"
   A = mfSpEye(5)
   v = mf( reshape( [ -1, 0, 0, 0, 1 ], [5,1] ) )
   call msSet( v, A, MF_COLON, [5] )
   call msDisplay( mfFull(A), "mfFull(A)" )
   call msSaveSparse( "A_tmp.mtx", A, format="MTX" )

   ! real symmetric
   print "(/,A)", "*** test number 148 ***"
   B = A + .t. A
   if( mfIsSymm(B) ) then
      print *, "  --> info: 'B' symmetric : true"
   else
      print *, "  --> info: 'B' symmetric : false => ERROR!"
      call msPause()
   end if
   call msDisplay( B, "B" )
   call msDisplay( mfFull(B), "mfFull(B)" )
   call msSaveSparse( "B_tmp.mtx", B, format="MTX" )

   ! complex general
   print "(/,A)", "*** test number 149 ***"
   C = mfSpEye(4,kind="complex")
   v = mf( reshape( [ (0.0d0,1.0d0), (0.0d0,0.0d0),                     &
                       (0.0d0,0.0d0), (1.0d0,0.0d0) ], [4,1] ) )
   call msSet( v, C, MF_COLON, [4] )
   call msDisplay( mfFull(C), "mfFull(C)" )
   call msSaveSparse( "C_tmp.mtx", C, format="MTX" )

   ! complex hermitian
   print "(/,A)", "*** test number 150 ***"
   D = C + .h. C
   if( mfIsSymm(D) ) then
      print *, "  --> info: 'D' hermitian : true"
   else
      print *, "  --> info: 'D' hermitian : false => ERROR!"
      call msPause()
   end if
   call msDisplay( D, "D" )
   call msDisplay( mfFull(D), "mfFull(D)" )
   call msSaveSparse( "D_tmp.mtx", D, format="MTX" )

   !-- HBO format

   print "(/,A)", "*** test number 151 ***"
   A = mfLoadSparse( "data/lap_64.hbo", format="HBO" )
   print "()"
   print *, "mfLoadSparse( 'data/lap_64.hbo', format='HBO' ) : ok"
   print *, "shape(A) = ", shape(A)
   print *, "nnz(A) = ", mfNnz(A)
   print "()"

   print "(/,A)", "*** test number 152 ***"
   A = mfSpEye(20,20)
   call msSaveSparse( "A_tmp.hbo", A, format="HBO" )
   print "()"
   print *, "call msSaveSparse( 'A_tmp.hbo', A, format='HBO' ) : ok"
   print "()"

   ! add32.hbo contains a RHS
   print "(/,A)", "*** test number 153 ***"
   A = mfLoadSparse( "data/add32.hbo", format="HBO" )
   print "()"
   print *, "mfLoadSparse( 'data/add32.hbo', format='HBO' ) : ok"
   print *, "shape(A) = ", shape(A)
   print *, "nnz(A) = ", mfNnz(A)
   print "()"

   !-- auto-detect

   print "(/,A)", "*** test number 154 ***"
   A = mfLoadSparse( "data/A.csc" )
   print "()"
   print *, "mfLoadSparse( 'data/A.csc' ) : format auto-detected"

   print "(/,A)", "*** test number 155 ***"
   A = mfLoadSparse( "data/D.csr" )
   print *, "mfLoadSparse( 'data/D.csr' ) : format auto-detected"

   print "(/,A)", "*** test number 156 ***"
   A = mfLoadSparse( "data/test11.mtx" )
   print *, "mfLoadSparse( 'data/test11.mtx' ) : format auto-detected"

   print "(/,A)", "*** test number 157 ***"
   A = mfLoadSparse( "data/lap_64.hbo" )
   print *, "mfLoadSparse( 'data/lap_64.hbo' ) : format auto-detected"
   print "()"

   ! msLoadSparse ------------------------------------------------------
   call print_separation("msLoadSparse")

   ! add32.hbo contains a RHS
   print "(/,A)", "*** test number 158 ***"
   call msLoadSparse( mfOut(A), "data/add32.hbo", format="HBO" )
   print "()"
   print *, "msLoadSparse( mfOut(A), 'data/add32.hbo', format='HBO' ) : ok"
   print *, "shape(A) = ", shape(A)
   print *, "nnz(A) = ", mfNnz(A)
   print "()"

   print "(/,A)", "*** test number 159 ***"
   call msLoadSparse( mfOut(A,RHS), "data/add32.hbo", format="HBO" )
   print "()"
   print *, "msLoadSparse( mfOut(A,RHS), 'data/add32.hbo', format='HBO' ) : ok"
   print *, "shape(A) = ", shape(A)
   print *, "nnz(A) = ", mfNnz(A)
   print *, "shape(RHS) = ", shape(RHS)
   print "()"

   print "()"

   ! msSave ------------------------------------------------------------
   call print_separation("msSave (mfTriConnect)")

   print "(/,A)", "*** test number 160 ***"

   ! Squared domain
   allocate( PL_domain%n_xy(4,2) )
   PL_domain%n_xy(:,1) = [ 0.0d0, 2.0d0, 2.0d0, 0.0d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.0d0, 0.0d0, 2.0d0, 2.0d0 ] ! y
   allocate( PL_domain%edge_n(4,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 1 ]

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,      &
                    area_max=1.5d0 )
   call msBuildTriConnect( x, y, tri, tri_connect )

   call msPrintTriConnect( tri_connect )

   call msSave( "tri_connect_tmp.mbf", tri_connect )

   call msRelease( tri_connect )

   tri_connect = mfLoadTriConnect( "tri_connect_tmp.mbf" )

   call msPrintTriConnect( tri_connect )

   call msSave( "tri_connect_tmp.mbf.gz", tri_connect )

   ! no data copy, then greater performance for large structures
   call msAssign( tri_connect, mfLoadTriConnect( "tri_connect_tmp.mbf.gz" ) )

   call msPrintTriConnect( tri_connect )

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_fileio ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, magic_501, tri )
   call msRelease( A, B, C, D, v, p, RHS )

   call msRelease( PL_domain )
   call msRelease( tri_connect )

end program
