program pcolor_XY_map_interp_light

   ! test de PcolorCoreMat* (x et y : matrices)

   ! shading interp

   use fml
   use fgl

   implicit none

   integer, parameter :: nx = 31, ny = 43,                              &
                         grid_step(2) = [ 2, 3 ]

   type(mfArray) :: x, y, z, r, x1, y1

!!call msSetX11Device( "off" )
   call msSetMsgLevel( 2 ) ! only severe warnings are displayed

   !----------------------------------

   call msFigure(1)
   call msCharInPixels( "on" )

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0,  5.0d0, nx),          &
                            .t. mfLinspace(0.0d0, 10.0d0, ny) )
   r = mfSqrt(x**2 + y**2)
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, 1, 1 ) ! avoid NaN value : sin(0)/0 = 1
   x1 = x - y
   y1 = x + y

   call msColormapSize( 256 )
   call msColormap( "parula" )

   call msAxis( "equal" )
   call msShading( "interp" )

   call msPcolor( x1, y1, z, view="XY", grid=.true.,                    &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msColorbar( "on" )

   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "Top view of Z values" )

   call msPrint( "pcolor_map_XY_interp.eps" )
   call msPrint( "pcolor_map_XY_interp.pdf" )

   !----------------------------------

   call msFigure(2)
   call msCharInPixels( "on" )

   call msColormapSize( 256 )
   call msColormap( "grey" )
   call msShading( "interp" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x1, y1, z, view="YZ", lighting=.true. )

   call msXLabel( "Y" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (Y,Z) plane (forward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_map_YZ_interp_light.eps" )
   call msPrint( "pcolor_map_YZ_interp_light.pdf" )

   !----------------------------------

   call msFigure(3)
   call msCharInPixels( "on" )

   call msColormapSize( 256 )
   call msColormap( "grey" )
   call msShading( "interp" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x1, y1, z, view="YZb", lighting=.true. )

   call msXLabel( "Y" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (Y,Z) plane (backward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_map_YZb_interp_light.eps" )
   call msPrint( "pcolor_map_YZb_interp_light.pdf" )

   !----------------------------------

   call msFigure(4)
   call msCharInPixels( "on" )

   call msColormapSize( 256 )
   call msColormap( "grey" )
   call msShading( "interp" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x1, y1, z, view="XZ", lighting=.true. )

   call msXLabel( "X" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (X,Z) plane (forward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_map_XZ_interp_light.eps" )
   call msPrint( "pcolor_map_XZ_interp_light.pdf" )

   !----------------------------------

   call msFigure(5)
   call msCharInPixels( "on" )

   call msColormapSize( 256 )
   call msColormap( "grey" )
   call msShading( "interp" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x1, y1, z, view="XZb", lighting=.true. )

   call msXLabel( "X" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (X,Z) plane (backward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_map_XZb_interp_light.eps" )
   call msPrint( "pcolor_map_XZb_interp_light.pdf" )

!_______________________________________________________________________
!
99 continue

   ! waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z, r, x1, y1 )

end program
