! this program test needs that X11 device is not disabled.

program Zoom_test

   use fml
   use fgl

   implicit none

   type(mfArray) :: x, y
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   call msFigure(1)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )

   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    1.,    1.,    0.,    0. ]

   call msPlot( x, y, "b" )
   ! adding some text outside the current view area...
   call msText( 1.3d0, 1.3d0, "hello", height=2.5d0, clipping=.true. )
   call msHold( "on" )
   call msPlot( mf(1.5d0), mf(1.45d0), "b*" )

   call msLegend( "curve 1", "symbol"  )

   ! Ctrl+Right-click in order to view all the graphic objects...
   call msZoom()
   call msDisplay(mfAxis(),"current axis")

   call msPanAndZoom()

   !------------------------------

   call msFigure(2)

   call msAxis( "loglog" )

   x = mfLogSpace( -3.0d0, 3.0d0, 7 )
   y = x

   call msPlot( x, y, "o-" )

   call msHold( "on" )
   call msPlot( x, y*10.0d0, "ro-" )
   call msLegend( "red", "blue" )

   call msZoom( )
   call msDisplay(mfAxis(),"current axis")

   call msPanAndZoom()

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

#endif

end program
