program TriStreamline_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, val, u, v, start
   type(mfArray) :: tri
   type(mfTriConnect) :: tri_connect

!_______________________________________________________________________
!

   call run_options()

   !---------------

   call msFigure(1)

   call msAxis( "equal" )
   call msAxis( [ -0.35d0, 1.6d0, -0.4d0, 1.6d0 ] )

   x = [ 0.05d0, 1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0,   &
         0.4d0, 0.15d0, 0.85d0, 1.35d0, 1.45d0, 1.5d0, 0.6d0, -0.3d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0, 0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0,   &
         0.9d0, 1.5d0, 1.45d0, 1.35d0, 0.75d0, 0.2d0, -0.3d0, 0.45d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   u = mfRand( size(x,1), size(x,2) )
   v = mfRand( size(x,1), size(x,2) )

   ! all start points can be stored in one mfArray
   start = reshape( [ 0.0, 1.2,                                         &
                      0.2, 1.0,                                         &
                      0.4, 0.8,                                         &
                      0.6, 0.6,                                         &
                      0.8, 0.4,                                         &
                      1.0, 0.2                                          &
                    ], [2,6] )
   start = .t. start

   call msTriQuiver( x, y, u, v )
   call msHold( "on" )

   call msTriStreamline( x, y, u, v, start, color="r" )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriStreamline_1.eps" )
   call msPrint( "TriStreamline_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !---------------

   call msFigure(2)

   call msAxis( "equal" )
   call msAxis( [ -0.35d0, 1.6d0, -0.4d0, 1.6d0 ] )

   x = [ 0.05d0, 1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0,   &
         0.4d0, 0.15d0, 0.85d0, 1.35d0, 1.45d0, 1.5d0, 0.6d0, -0.3d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0, 0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0,   &
         0.9d0, 1.5d0, 1.45d0, 1.35d0, 0.75d0, 0.2d0, -0.3d0, 0.45d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   u = mfRand( size(x,1), size(x,2) )
   v = mfRand( size(x,1), size(x,2) )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msTriMesh( x, y, tri, color=[0.7d0,0.7d0,0.7d0] )
   call msHold( "on" )
!!   call msTriQuiver( x, y, u, v )

   ! all start points can be stored in one mfArray
   start = reshape( [ 0.0, 1.2,                                         &
                      0.2, 1.0,                                         &
                      0.4, 0.8,                                         &
                      0.6, 0.6,                                         &
                      0.8, 0.4,                                         &
                      1.0, 0.2                                          &
                    ], [2,6] )
   start = .t. start

   ! here, the triangulation is passed as argument
   call msTriStreamline( x, y, u, v, start, tri=tri, color="r",         &
                         n_arrow=0, linestyle="--" )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriStreamline_2.eps" )
   call msPrint( "TriStreamline_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !---------------

   call msFigure(3)

   call msAxis( "equal" )
   call msAxis( [ -0.35d0, 1.6d0, -0.4d0, 1.6d0 ] )

   x = [ 0.05d0, 1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0,   &
         0.4d0, 0.15d0, 0.85d0, 1.35d0, 1.45d0, 1.5d0, 0.6d0, -0.3d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0, 0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0,   &
         0.9d0, 1.5d0, 1.45d0, 1.35d0, 0.75d0, 0.2d0, -0.3d0, 0.45d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   u = mfRand( size(x,1), size(x,2) )
   v = mfRand( size(x,1), size(x,2) )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msBuildTriConnect( x, y, tri, tri_connect )

   call msTriMesh( tri_connect, color=[0.7d0,0.7d0,0.7d0] )
   call msHold( "on" )
!!   call msTriQuiver( x, y, u, v )

   ! all start points can be stored in one mfArray
   start = reshape( [ 0.2, 1.4,                                         &
                      0.0, 1.2,                                         &
                      0.1, 1.1,                                         &
                      0.2, 1.0,                                         &
                      0.3, 0.9,                                         &
                      0.4, 0.8,                                         &
                      0.5, 0.7,                                         &
                      0.6, 0.6,                                         &
                      0.7, 0.5,                                         &
                      0.8, 0.4,                                         &
                      0.9, 0.3,                                         &
                      1.0, 0.2,                                         &
                      1.1, 0.1                                          &
                    ], [2,13] )
   start = .t. start

   ! here, the triangles connectivity is also passed as argument
   call msTriStreamline( x, y, u, v, start,                             &
                         tri_connect=tri_connect, color="b" )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriStreamline_3.eps" )
   call msPrint( "TriStreamline_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, val, u, v, start )
   call msRelease( tri )
   call msRelease( tri_connect )

   call RngStream_end()

end program
