program TriMesh_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, tri
   type(mfTriConnect) :: tri_connect

   integer :: convexity

!_______________________________________________________________________
!

   call run_options()

   !---------------

   call msFigure(1)

   call msAxis( "equal" )
   call msAxis( [ -0.5d0, 1.5d0, -0.5d0, 1.5d0 ] )

   x = [ -0.05d0,  1.05d0, 1.0d0, -0.15d0, 0.7d0, 0.4d0, 1.2d0,         &
         0.2d0, 0.4d0, 0.6d0, 0.5d0, -0.3d0 ]
   y = [ -0.1d0, -0.05d0, 1.0d0,  0.95d0, 0.6d0, 1.3d0, 0.3d0,          &
         0.4d0, 0.9d0, 0.1d0, -0.3d0, 0.4d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "original triangles" )

   ! making a hole by removing triangles #7 and 10.
   call msSet( MF_EMPTY, tri, 10, MF_ALL )
   call msSet( MF_EMPTY, tri,  7, MF_ALL )
   call msDisplay( tri, "new triangles" )

   call msTriMesh( x, y, tri, color="b" )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriMesh_1.eps" )
   call msPrint( "TriMesh_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause( "adding boundaries..." )

   call msHold( "on" )

   call msTriMesh( x, y, tri, color="r",                                &
                   linewidth=2.0d0, boundary_only=.true.,               &
                   nod_num=.true. )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriMesh_1bis.eps" )
   call msPrint( "TriMesh_1bis.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   !---------------

   call msFigure(2)

   call msAxis( "equal" )
   call msAxis( [ -0.5d0, 1.5d0, -0.5d0, 1.5d0 ] )

   call msBuildTriConnect( x, y, tri, tri_connect )
   call msPrintTriConnect( tri_connect, short_info=.true. )

   call msTriMesh( tri_connect, color=[0.7d0,0.7d0,0.7d0], linewidth=1.5d0 )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriMesh_2.eps" )
   call msPrint( "TriMesh_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause( "adding boundaries..." )

   call msHold( "on" )

   call msTriMesh( tri_connect, color="r",                              &
                   linewidth=2.0d0, boundary_only=.true.,               &
                   nod_num=.true., fac_num=.true. )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriMesh_2bis.eps" )
   call msPrint( "TriMesh_2bis.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msCheckDomainConvexity( tri_connect )
   call msExtractTriConnect( tri_connect, convexity=convexity )
   print *, "Domain convexity: ", convexity

   !---------------

   call msFigure(3)

   call msAxis( "equal" )
   call msAxis( [ 0.35d0, 1.05d0, 0.43d0, 1.13d0 ] )

   call msBuildTriConnect( x, y, tri, tri_connect )
   call msPrintTriConnect( tri_connect, short_info=.true. )

   call msTriMesh( tri_connect, color=[0.7d0,0.7d0,0.7d0], linewidth=1.5d0, &
                   tri_num=.true., nod_num=.true., fac_num=.true. )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriMesh_3.eps" )
   call msPrint( "TriMesh_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, tri )
   call msRelease( tri_connect )

end program
