program TriFill_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, val
   type(mfArray) :: tri
   integer :: color_depth

!_______________________________________________________________________
!

   call run_options()

   !---------------

   call msFigure(1)

   color_depth = mfGetX11ColorDepth()
   write(STDOUT,"(A,I0)") " Color Depth = ", color_depth

   call msColormapSize( 256 )
   print *, " Colormap size = ", mfColormapSize()
   call msColormap( "rainbow" )
   call msAxis( "equal" )

   x = [ 0.05d0,  1.05d0, 1.00d0, -0.15d0, 0.50d0 ]
   y = [ 0.00d0, -0.05d0, 1.00d0,  0.80d0, 0.60d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   val = .t. [ 0.20d0, 0.40d0, 0.60d0, 0.80d0 ]
   call msDisplay( val, "values" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msCAxis( [ 0.0d0, 1.0d0 ] )
   call msTriFill( x, y, val, tri )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriFill_1a.eps" )
   call msPrint( "TriFill_1a.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause( "Check that NaNs are valid entries in 'val' array" )

   call msSet( MF_NAN, val, 2 )
   call msDisplay( val, "values" )

   call msTriFill( x, y, val, tri )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriFill_1a.eps" )
   call msPrint( "TriFill_1a.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   !---------------

   call msFigure(2)

   color_depth = mfGetX11ColorDepth()
   write(STDOUT,"(A,I0)") " Color Depth = ", color_depth

   call msColormapSize( 256 )
   print *, " Colormap size = ", mfColormapSize()
   call msColormap( "parula" )
   call msAxis( "equal" )

   x = [ 0.05d0,  1.05d0, 1.00d0, -0.15d0, 0.50d0 ]
   y = [ 0.00d0, -0.05d0, 1.00d0,  0.80d0, 0.60d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   val = .t. [ 0.20d0, 0.40d0, 0.60d0, 0.80d0 ]
   call msDisplay( val, "values" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msCAxis( [ 0.0d0, 1.0d0 ] )

   call msTriFill( x, y, val, tri )
   call msHold( "on" )

   call msTriMesh( x, y, tri ) ! default color is black

   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriFill_2.eps" )
   call msPrint( "TriFill_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, val )
   call msRelease( tri )

end program
