program Quiver_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, z, xc, yc, r, theta
   type(mfArray) :: zrange, dx, dy, d_r, d_theta
   real(kind=MF_DOUBLE) :: h_r, h_theta
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

   call msMeshGrid( mfOut(x,y), mfColon(0.0d0,2.0d0,0.2d0),             &
                            .t. mfColon(1.8d0,0.0d0,-0.2d0) )

   z = x*mfExp(-x**2 - y**2)
   call msGradient( mfOut(dy,dx), z, -0.2d0, 0.2d0 )

   !---------------------------

   !----------------------------------
   call msFigure(1)

   call msQuiver( dx, dy )

   call msPrint("Quiver_1.eps")
   call msPrint("Quiver_1.pdf")

   !---------------------------

   call msFigure(2)

   call msColormap( "rainbow" )
   call msCAxis( mfExtrema(z) )
   call msContour( z )
   call msColorbar( "on" )
   call msXLabel("column index")
   call msYLabel("row index")

   call msHold( "on" )

   call msQuiver( dx, dy )

   call msPrint("Quiver_2.eps")
   call msPrint("Quiver_2.pdf")

   !---------------------------

   call msFigure(3)

   call msAxis( "equal" )

   call msColormap( "parula" )
   call msCAxis( mfExtrema(z) )
   call msContour( x, y, z )
   call msColorbar( "on" )
   call msXLabel("X axis")
   call msYLabel("Y axis")

   call msHold( "on" )

   ! (x,y) are matrices
   call msQuiver( x, y, dx, dy )

   call msPrint("Quiver_3.eps")
   call msPrint("Quiver_3.pdf")

   !---------------------------

   call msFigure(4)

   call msAxis( "equal" )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 1.9d0 ] )
   call msPlot( mf([0.,2.,2.,0.,0.]), mf([0.,0.,1.8,1.8,0.]), color="grey" )
   call msHold( "on" )

   call msColormap( "rainbow" )
   call msCAxis( mfExtrema(z) )
   call msContour( x, y, z )
   call msColorbar( "on" )
   call msXLabel("X axis")
   call msYLabel("Y axis")

   ! reducing matrices (x,y) to vectors
   x = mfGet( x, 1, MF_ALL )
   y = mfGet( y, MF_ALL, 1 )
   call msQuiver( x, y, dx, dy )

   call msPrint("Quiver_4.eps")
   call msPrint("Quiver_4.pdf")

   !---------------------------

   call msFigure(5)

   call msAxis( "equal" )

   call msColormap( "rainbow" )
   call msCAxis( mfExtrema(z) )
   call msPColor( z )
   call msColorbar( "on" )
   call msXLabel("column index")
   call msYLabel("row index")

   call msHold( "on" )

   ! (dx,dy) reconstruit pour le cas "cell_centered"
   call msGradient( mfOut(dy,dx), z, -0.2d0, 0.2d0, location="centered" )
   call msQuiver( dx, dy, data_centering="cell" )

   call msPrint("Quiver_5.eps")
   call msPrint("Quiver_5.pdf")

   !---------------------------

   call msFigure(6)

   call msAxis( "equal" )

   xc = mfLinspace( -0.1d0, 2.1d0, 12 )
   yc = .t. mfLinspace( 1.9d0, -0.1d0, 11 )

   call msColormap( "rainbow" )
   call msCAxis( mfExtrema(z) )
   call msPColor( xc, yc, z, data_centering="cell" )
   call msColorbar( "on" )
   call msXLabel("X axis")
   call msYLabel("Y axis")

   call msHold( "on" )

   call msQuiver( x, y, dx, dy, data_centering="cell" )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 1.9d0 ] )

   call msPrint("Quiver_6.eps")
   call msPrint("Quiver_6.pdf")

   !---------------------------

   call msFigure(7)

   ! using a fine grid
   call msMeshGrid( mfOut(x,y), mfColon(0.0d0,2.0d0,0.035d0),           &
                            .t. mfColon(2.0d0,0.0d0,-0.035d0) )
   z = x*mfExp(-x**2 - y**2)

   call msAxis( "equal" )

   call msColormap( "fusion" )
   call msCAxis( mfExtrema(z) )
   call msPColor( z )
   call msColorbar( "on" )
   call msXLabel("column index")
   call msYLabel("row index")

   call msHold( "on" )

   ! (dx,dy) reconstruit pour le cas "cell_centered"
   call msGradient( mfOut(dy,dx), z, -0.2d0, 0.2d0, location="centered" )
   call msQuiver( dx, dy, data_centering="cell" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msZoom()
!!      call msPanAndZoom()
   end if
#endif

   call msPrint("Quiver_7.eps")
   call msPrint("Quiver_7.pdf")

   !---------------------------

   call msFigure(8)
   call msAxisFontSize(1.2d0)
   call msLabelFontSize(1.35d0)

   call msMeshGrid( mfOut(r,theta), mfLinspace(1.0d0,  4.0d0, 10),      &
                                .t. mfLinspace(0.0d0, MF_PI, 30) )
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, MF_ALL, [1] ) ! avoid NaN value : sin(0)/0 = 1

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -4.1d0, +5.6d0 ] )

   ! the transformation is globally non-linear, but locally linear
   x = r * mfCos(theta)
   y = r * mfSin(theta)
   z = 0.0d0*z + y + x

   call msPcolor( x, y, z )
   call msHold( "on" )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   h_r     = (4.0d0-1.0d0)/(10-1)
   h_theta = (MF_PI-0.0d0)/(30-1)
   call msGradient( mfOut(d_theta,d_r), z, h_theta, h_r )
   ! convert to (x,y) coordinates
   dx = d_r*mfCos(theta) - d_theta/r*mfSin(theta)
   dy = d_r*mfSin(theta) + d_theta/r*mfCos(theta)
   ! scale to easy visualization
   call msQuiver( x, y, dx, dy, arrow_length=2.0d0 )

   call msAxis( [ -4.1d0, 4.2d0, -0.05d0, 4.2d0 ] )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Quiver_8.eps" )
   call msPrint( "Quiver_8.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z )
   call msRelease( zrange, dx, dy )

end program
