program PlotHist_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   double precision :: hope, mean, nbin_width, val, val_min, val_max,   &
                       amplitude, xi
   integer :: n, nbin, iratio, i
   character(len=1) :: ans
   logical :: interactive
double precision :: xx

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   n = 1.0e6
   nbin = 60

!--------------------------

   call msFigure(1)
   hope = dble(n)/dble(nbin)

   x = mfRand( n, 1 )
   call msPlotHist( mfOut(), x, 0.0d0, 1.0d0, nbin )

   call msHold( "on" )

   x = [ 0.0d0, 1.0d0 ]
   y = [ hope, hope ]
   call msPlot( x, y, "--r" )
   call msTitle( "Uniform Distribution" )

   print *, "printing ..."
   call msPrint( "PlotHist_1.eps" )
   call msPrint( "PlotHist_1.pdf" )

!--------------------------

   call msFigure(2)
   val_min = -3.0d0
   val_max =  3.0d0
   nbin_width = ( val_max - val_min )/nbin
   amplitude = n*nbin_width/sqrt(2.0d0*MF_PI)

   x = mfRandN( n, 1 )
   call msPlotHist( mfOut(), x, val_min, val_max, nbin )

   call msHold( "on" )

   x = mfLinspace( val_min, val_max, 500 )
   ! Theoretically, the mfRandN generator leads to numbers having a zero
   ! mean and a unit variance.
   y = amplitude*mfExp(-0.5d0*x**2)
   call msPlot( x, y, "--r" )
   call msTitle( "Normal Distribution" )

   print *, "printing ..."
   call msPrint( "PlotHist_2.eps" )
   call msPrint( "PlotHist_2.pdf" )

!--------------------------

   call msFigure(3)
   call msAxis( [ 1.0d0, 3.0d0, 4.0d2, 4.0d4 ] )
   call msAxis( "linlog" )

   x = mfRandN( n, 1 )
   call msPlotHist( mfOut(), x, -3.0d0, 3.0d0, nbin )
   call msTitle( "Normal Distribution -- Lin-Log scales" )

   print *, "printing ..."
   call msPrint( "PlotHist_3.eps" )
   call msPrint( "PlotHist_3.pdf" )

!--------------------------

   call msFigure(4)
   call msAxis( [ 1.0d0, 12.0d0], axis="x" ) ! avoid warning about neg. values in log
   call msAxis( "loglin" )

   ! Shift required for using log
   x = mfRand( n, 1 )*10.0d0 + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 11.0d0, nbin )
   call msTitle( "Uniform Distribution -- Log-Lin scales" )

   print *, "printing ..."
   call msPrint( "PlotHist_4.eps" )
   call msPrint( "PlotHist_4.pdf" )

!--------------------------

   call msFigure(5)
   call msAxis( [ 1.0d0, 6.0d0], axis="x" ) ! avoid warning about neg. values in log
   call msAxis( "loglin" )

   ! abs() + shift required for using log
   x = mfabs( mfRandN( n, 1 ) ) + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 6.0d0, nbin )
   call msTitle( "Normal Distribution -- Log-Lin scales" )

   print *, "printing ..."
   call msPrint( "PlotHist_5.eps" )
   call msPrint( "PlotHist_5.pdf" )

!--------------------------

   call msFigure(6)
   call msAxis( [ 1.0d0, 6.0d0, 1.0d0, 1.0d5 ] )
   call msAxis( "loglog" )

   ! abs() + shift required for logarithmic axis
   x = mfabs( mfRandN( n, 1 ) ) + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 6.0d0, nbin, filled=.true. )
   call msTitle( "Normal Distribution -- Log-Log scales" )

   call msHold("on")

   x = mfabs( mfRandN( n/10, 1 ) ) + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 6.0d0, nbin, filled=.true. )

   x = mfabs( mfRandN( n/100, 1 ) ) + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 6.0d0, nbin, filled=.true. )

   x = mfabs( mfRandN( n/1000, 1 ) ) + 1.0d0
   call msPlotHist( mfOut(), x, 1.0d0, 6.0d0, nbin, filled=.true. )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   print *, "printing ..."
   call msPrint( "PlotHist_6.eps" )
   call msPrint( "PlotHist_6.pdf" )

!--------------------------

   call msFigure(7)
   ! Be careful by chosing the histogram parameters, because generated
   ! numbers are integer.
   mean = 5.0d0
   val_min = 0
   val_max = nint( 3*mean )
   ! Choose nbin such that each bin limit is between two integers (on the
   ! contrary, spurious histograms may be obtained).
   nbin = (val_max-val_min) + 1
   ! Fix val_max in order to have the same number of integers in each bin.
   val_max = nbin -1 + val_min
   nbin_width = ( val_max - val_min )/nbin
   amplitude = n/6.0d0 ! estimated
   call msAxis( [ val_min-0.5d0, val_max+0.5d0 ], axis="x" )

   x = mfRandPoiss( mean, n, 1 )
   call msPlotHist( mfOut(), x, val_min-0.5d0, val_max+0.5d0, nbin )

   call msHold( "on" )

   x = mfColon( val_min, val_max )
   ! For low value of the mean, the exact Poisson distribution is known
   y = x ! just for getting the good size
   do i = 1, size(x)
      xi = mfGet( x, i )
      ! compute log of the theoretical distribution: mu^k*exp(-mu)/k!
      val = xi*log(mean) - mean - log_gamma(xi+1.0d0)
      call msSet( exp(val), y, i )
   end do
   ! previous y vector is normalized; get the good amplitude now
   y = y*n
   call msPlot( x, y, "r*" )
   call msTitle( "Poisson Distribution with low mean" )
   call msLegend( "theoretical Poisson law", location="TR" )

   print *, "printing ..."
   call msPrint( "PlotHist_7.eps" )
   call msPrint( "PlotHist_7.pdf" )
!--------------------------

   call msFigure(8)
   ! Be careful by chosing the histogram parameters, because generated
   ! numbers are integer.
   mean = 250.0d0
   val_min = nint( mean - mean/3 )
   val_max = nint( mean + mean/3 )
   ! Choose nbin such that each bin limit is between two integers (on the
   ! contrary, spurious histograms may be obtained).
   iratio = 3
   nbin = ( (val_max-val_min) + 1 )/iratio
   ! Fix val_max in order to have the same number of integers in each bin.
   val_max = iratio*nbin -1 + val_min
   nbin_width = ( val_max - val_min )/nbin
   amplitude = n*nbin_width/sqrt(2.0d0*MF_PI)/sqrt(mean)

   x = mfRandPoiss( mean, n, 1 )
   call msPlotHist( mfOut(), x, val_min-0.5d0, val_max+0.5d0, nbin )

   call msHold( "on" )

   x = mfLinspace( val_min, val_max, 500 )
   ! For high value of the mean, a gaussian distribution is a well
   ! approximation
   y = amplitude*mfExp(-0.5d0*(x-mean)**2/mean)
   call msPlot( x, y, "--r" )
   call msTitle( "Poisson Distribution with high mean" )
   call msLegend( "approximated gaussian distribution" )

   print *, "printing ..."
   call msPrint( "PlotHist_8.eps" )
   call msPrint( "PlotHist_8.pdf" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
