program Patch_test_2

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, c, range, colormap

!_______________________________________________________________________
!

   call run_options()

   ! ------ simpler test of transparency  ------
   ! when using a black background, additive colors

   call msSetBackgroundColor( "black" )

   !----------------------------------
   call msFigure(1)

   call msAxis( [ 0.0d0, 1.0d0, -0.001d0, 1.0d0] )
   call msAxis( "equal" )
   call msAxis( "off" )

   x = [ 0.000, 0.667, 0.667, 0.000 ]
   y = [ 0.000, 0.000, 0.667, 0.667 ]
   call msPatch( x, y, color=[1.0d0,0.0d0,0.0d0], opacity=0.5d0 )

   call msHold( "on" )

   x = x + 0.1667
   y = y + 0.1667
   call msPatch( x, y, color=[0.0d0,1.0d0,0.0d0], opacity=0.5d0 )

   x = [ 0.333, 1.000, 1.000, 0.333 ]
   y = [ 0.333, 0.333, 1.000, 1.000 ]
   call msPatch( x, y, color=[0.0d0,0.0d0,1.0d0], opacity=0.5d0 )

   x = [ 0.60, 0.95, 0.95, 0.60 ]
   y = [ 0.40, 0.40, 0.05, 0.05 ]
   call msPatch( x, y, color="k", grid=.true. )

   if( mfGetX11Device() == "on" ) then
      call msPrint("Patch_additive_colors.eps")
   end if
   call msPrint("Patch_additive_colors.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, range, colormap, c )

end program
