! this program test needs that X11 device is not disabled.

program Pan_test

   use fml
   use fgl

   implicit none

   type(mfArray) :: x, y
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   !------------------------------

   ! linear axes, increasing values, with a legend
   call msFigure( 1, position=[30,30], size=[800,600],                  &
                  title="linear, normal axes" )

   ! standard axes
   call msAxis( [ -0.2d0, 1.2001d0, -0.2d0, 1.2001d0 ] )

   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    1.,    1.,    0.,    0. ]

   call msPlot( x, y, "b" )

   call msHold( "on" )
   call msPlot( x+0.02d0, y+0.02d0, "ro-", linewidth=1.5d0 )

   ! adding some text outside the current view area...
   call msText( 1.21d0, 1.28d0, "hello", height=2.0d0, clipping=.true. )
   call msPlot( mf(1.35d0), mf(1.35d0), "b*" )

   call msLegend( "curve 1", "curve 2", "symbol", location="TL" )

   call msPan()
   call msDisplay(mfAxis(),"current axis")

   !------------------------------

   ! linear axes, decreasing values, with a legend
   call msFigure( 2, position=[60,60], size=[800,600],                  &
                  title="linear, inverted axes" )

   ! inverted axes
   call msAxis( [ 1.1d0, -0.1d0, 1.1d0, -0.1d0 ] )

   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    1.,    1.,    0.,    0. ]

   call msPlot( x, y, "b" )

   call msHold( "on" )
   call msPlot( x+0.02d0, y+0.02d0, "r" )
   call msLegend( "curve 1", "curve 2", location="TR" )

   call msPan( )
   call msDisplay(mfAxis(),"current axis")

   !------------------------------

   ! log axes, increasing values, with a legend
   call msFigure( 3, position=[90,90], size=[800,600],                  &
                  title="log, normal axes" )

   ! standard axes
   call msAxis( [ 7.0d-4, 2.0d3, 7.0d-4, 2.0d4 ] )
   call msAxis( "loglog" )

   x = mfLogSpace( -3.0d0, 3.0d0, 7 )
   y = x

   call msPlot( x, y, "o-" )

   call msHold( "on" )
   call msPlot( x, y*10.0d0, "ro-" )
   call msLegend( "curve 1", "curve 2", location="BL" )

   call msPan( )
   call msDisplay(mfAxis(),"current axis")

   !------------------------------

   ! log axes, decreasing values, with a legend
   call msFigure( 4, position=[120,120], size=[800,600],                &
                  title="log, inverted axes" )

   ! inverted axes
   call msAxis( [ 2.0d3, 7.0d-4, 2.0d4, 7.0d-4 ] )
   call msAxis( "loglog" )

   x = mfLogSpace( -3.0d0, 3.0d0, 7 )
   y = x

   call msPlot( x, y, "o-" )

   call msHold( "on" )
   call msPlot( x, y*10.0d0, "ro-" )
   call msLegend( "curve 1", "curve 2", location="BR" )

   call msPan( )
   call msDisplay(mfAxis(),"current axis")

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

#endif

end program
