program Grid_test

   use fml
   use fgl

   use test_aux

   implicit none

   type( mfArray) :: x, y
   real(kind=MF_DOUBLE) :: d

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------

   call msFigure(1)

   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )

   x = [ 0.55, 0.85, 0.85, 0.55 ]
   y = [ 0.5, 0.5, 0.7, 0.7 ]
   call msPatch( x, y, "c" )

   call msHold( "on" )

   call msText( 0.1d0, 0.1d0, "mbgdy_MBGDY_12345",                      &
                height=3.0d0 )
   d = 0.015d0
   call msPlot( mf([0.1d0,0.1d0]), mf([0.1d0-d,0.1d0+d]),  "r" )
   call msPlot( mf([0.1d0-d,0.1d0+d]),  mf([0.1d0,0.1d0]), "r" )
   call msText( 0.4d0, 0.4d0, "mbgdy_MBGDY_12345",                      &
                height=2.25d0, angle=30.0d0 )
   call msPlot( mf([0.4d0,0.4d0]), mf([0.4d0-d,0.4d0+d]),  "r" )
   call msPlot( mf([0.4d0-d,0.4d0+d]),  mf([0.4d0,0.4d0]), "r" )

   call msPause( "now, activating grid 'on'" )
   call msGrid( "on", minor=.true. )

   call msPrint( "Grid.eps" )
   call msPrint( "Grid.pdf" )

   call msPause( "now, activating grid 'off'" )
   call msGrid( "off" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
