! this program test needs that X11 device is not disabled.

program Ginput_test_2

   use fml
   use fgl

   implicit none

   type(mfArray) :: x, y, z
   type(mfArray) :: tri
   integer :: color_depth
   type(mfArray) :: p, keycode, color
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   call msFigure(1)

   color_depth = mfGetX11ColorDepth()
   write(STDOUT,"(A,I0)") "  Color Depth = ", color_depth

   call msColormapSize( 256 )
   print "(A,I0)", "  Colormap size = ", mfColormapSize()
   call msColormap( "rainbow" )
   call msAxis( "equal" )

   x = [ 0.05d0, 1.05d0, 1.0d0, -0.05d0, 0.5d0 ]
   y = [ 0.0d0, -0.05d0, 1.0d0, 0.95d0, 0.5d0 ]
   z = x + y

   tri = mfDelaunay( x, y )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msCAxis( [ 0.0d0, 2.0d0 ] )
   call msShading( "interp" ) ! default is flat
   call msTriPcolor( x, y, z, tri )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   print *, " getting position of the pointer and the colored pixel, via the mouse"

   do
      call msGinput( mfOut(p,keycode,color) )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", color, "color" )
   end do

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z )
   call msRelease( tri )

#endif

end program
