! this program test needs that X11 device is not disabled.

program Ginput_test

   use fml
   use fgl

   implicit none

   type(mfArray) :: x, y, p, keycode
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   call msFigure(1)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )

   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    1.,    1.,    0.,    0. ]

   call msPlot( x, y, "r" )

   !====================================================================
   ! first serie (A) is for the classical use of Ginput (like in Matlab)

   print *
   print *, "---------------------- test A-1 ----------------------"
   print *, " getting only position of the pointer, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! first test: we don't want know which mouse button or key
   !             has been pressed
   do
      p = mfGinput()
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point" )
   end do

   print *
   print *, "---------------------- test A-2 ----------------------"
   print *, " getting position of the pointer and the mouse button, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! second test: we get the mouse button
   do
      call msGinput( mfOut(p,keycode) )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test A-3 ----------------------"
   print *, " getting position of the pointer and the key pressed"
   print *, " [mouse wheel detected as ichar(8)=56 and ichar(2)=50]"
   print *
   ! third test: we get the key
   do
      call msGinput( mfOut(p,keycode), whole_keyboard=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   !====================================================================
   ! second serie (B) concerns an added extension where a rectangle is
   ! drawn on the screen

   print *
   print *, "---------------------- test B-1 ----------------------"
   print *, " getting position of the pointer and the mouse button, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! first test: we get the mouse button
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]) )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test B-2 ----------------------"
   print *, " getting position of the pointer and the key pressed"
   print *, " [mouse wheel detected as ichar(8)=56 and ichar(2)=50]"
   print *
   ! second test: we get the key
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]),      &
                                       whole_keyboard=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test B-3 ----------------------"
   print *, " the rectangle is constrained to be located inside the axes"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! third test: whole rectangle must be located inside the axes
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]),      &
                                       rect_inside_axes=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point" )
   end do

   !####################################################################
   !####################################################################

   call msFigure(2) ! test inverted 'y' axis
   call msAxis( [ -0.1d0, 1.1d0, 1.1d0, -0.1d0] )

   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    1.,    1.,    0.,    0. ]

   call msPlot( x, y, "r" )

   !====================================================================
   ! first serie (A) is for the classical use of Ginput (like in Matlab)

   print *
   print *, "---------------------- test A-1 ----------------------"
   print *, " getting only position of the pointer, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! first test: we don't want know which mouse button or key
   !             has been pressed
   do
      p = mfGinput()
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point" )
   end do

   print *
   print *, "---------------------- test A-2 ----------------------"
   print *, " getting position of the pointer and the mouse button, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! second test: we get the mouse button
   do
      call msGinput( mfOut(p,keycode) )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test A-3 ----------------------"
   print *, " getting position of the pointer and the key pressed"
   print *, " [mouse wheel detected as ichar(8)=56 and ichar(2)=50]"
   print *
   ! third test: we get the key
   do
      call msGinput( mfOut(p,keycode), whole_keyboard=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   !====================================================================
   ! second serie (B) concerns an added extension where a rectangle is
   ! drawn on the screen

   print *
   print *, "---------------------- test B-1 ----------------------"
   print *, " getting position of the pointer and the mouse button, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! first test: we get the mouse button
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]) )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test B-2 ----------------------"
   print *, " getting position of the pointer and the key pressed"
   print *, " [mouse wheel detected as ichar(8)=56 and ichar(2)=50]"
   print *
   ! second test: we get the key
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]),      &
                                       whole_keyboard=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point", keycode, "keycode" )
   end do

   print *
   print *, "---------------------- test B-3 ----------------------"
   print *, " the rectangle is constrained to be located inside the axes"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! third test: whole rectangle must be located inside the axes
   do
      call msGinput( mfOut(p,keycode), rect_size = mf([0.2, 0.1]),      &
                                       rect_inside_axes=.true. )
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point" )
   end do

   !####################################################################
   !####################################################################

   call msFigure(3) ! log-log axis
   call msAxis( [ 1.0d0, 100.0d0, 1.0d0, 100.0d0] )
   call msAxis( "loglog" )

   x = [  2., 8.,  8., 20., 20., 50. ]
   y = [  3., 3., 50., 50.,  3.,  3. ]

   call msPlot( x, y, "r" )

   !====================================================================
   ! first serie (A) is for the classical use of Ginput (like in Matlab)

   print *
   print *, "---------------------- test A-1 ----------------------"
   print *, " getting only position of the pointer, via the mouse"
   print *, " [or mouse emulation by using 'L+?', 'M+?' or 'R+?' keys only]"
   print *
   ! first test: we don't want know which mouse button or key
   !             has been pressed
   do
      p = mfGinput()
      if( mfIsEqual(p,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( p, "got graphic point" )
   end do

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, p )

#endif

end program
