program Figure_test

   use fml
   use fgl

   use test_aux

   implicit none

!_______________________________________________________________________
!

   call run_options()

   ! thie figure is not numbered: FGL will choose one for it;
   ! its position cannot be recorded in a WIN_POS_DB file.
   call msFigure()

   ! Even empty, the printing should give a valid EPS or PDF...
   print *, "printing ..."
   call msPrint( "Figure_1.eps" )
   call msPrint( "Figure_1.pdf" )

   call msPause()

   ! this figure is numbered: if available, FGL will get its position
   ! from an existing WIN_POS_DB file.
   call msFigure(2)

   call msPause()

   ! this figure has a title, shown in the X11 window frame.
   call msFigure( 4, title="best results" )

   call msPause()

   ! this figure has imposed position and size.
   call msFigure( 6, position=[20, 20], size=[1000, 1000],              &
                  title="a big figure" )

   print *, "printing ..."
   call msPrint( "Figure_2.eps" )
   call msPrint( "Figure_2.pdf" )

   ! lastly, we can imposed only a part of the geometry
   call msFigure( 8, position=[20, 20],                                 &
                  title="imposed position, but default size" )

   call msFigure( 10, size=[300, 250],                                  &
                  title="default position, but minimum size" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
