program Delaunay_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, z, p, tri
   type(mfTriConnect) :: tri_connect
   type(mfPLdomain) :: PL_domain

   integer :: i, nb_pt, nb_tri, i1, i2, i3
   double precision :: xp, yp, x1, y1, x2, y2, x3, y3
   character(len=6) :: string
   ! for fixed height (~ 12 pixels) : 1.0d0
   double precision :: char_height = 1.2d0
   integer :: handle
   integer :: num, j
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   call msFigure(1)
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0] )

   call msHold( "on" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      ! interactive part
      x = MF_EMPTY
      y = MF_EMPTY
      do
         p = mfGinput()
         if( mfIsEqual(p,MF_EMPTY) ) then
            exit
         end if
         call msDisplay( p, "got graphic point" )
         call msPlot( mfGet(p,1), mfGet(p,2), "r+" )
         x = x .vc. mfGet(p,1)
         y = y .vc. mfGet(p,2)
      end do
   else
#endif
      ! non interactive part
      x = .t. mf( [ 0.0d0, 0.0d0, 1.0d0 ] )
      y = .t. mf( [ 1.0d0, 0.0d0, 1.0d0 ] )
#ifndef _NO_X11
   end if
#endif

   tri = mfDelaunay( x, y )
   nb_tri = size( tri, 1 )
   print "(/,1X,A,I0)", "nb of triangles: ", nb_tri

   do i = 1, nb_tri
      i1 = mfDble( mfGet(tri,i,1) )
      i2 = mfDble( mfGet(tri,i,2) )
      i3 = mfDble( mfGet(tri,i,3) )
      x1 = mfDble( mfGet( x, i1 ) )
      x2 = mfDble( mfGet( x, i2 ) )
      x3 = mfDble( mfGet( x, i3 ) )
      y1 = mfDble( mfGet( y, i1 ) )
      y2 = mfDble( mfGet( y, i2 ) )
      y3 = mfDble( mfGet( y, i3 ) )
      call msPlot( mf([x1,x2,x3,x1]),                                   &
                   mf([y1,y2,y3,y1]), "b" )
      write(string,"(I0)") i
      call msText( (x1+x2+x3)/3.0d0, (y1+y2+y3)/3.0d0, trim(string) )
   end do

   call msBuildTriConnect( x, y, tri, tri_connect )

   ! strict mode
   print *, "Triangle Search in Strict mode"
   handle = 0
#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      do
         p = mfGinput()
         if( mfIsEqual(p,MF_EMPTY) ) then
            exit
         end if
         if( handle /= 0 ) then
            call msRemoveGrObj( handle )
            handle = 0
         end if
         xp = mfDble( mfGet(p,1) )
         yp = mfDble( mfGet(p,2) )
         num = mfTriSearch( tri_connect, xp, yp )
         if( num == 0 ) then
            print *, "point is not in a triangle!"
         else
            print "(1X,A,I0)", "enclosing triangle: ", num
            i1 = mfDble( mfGet(tri,num,1) )
            i2 = mfDble( mfGet(tri,num,2) )
            i3 = mfDble( mfGet(tri,num,3) )
            x1 = mfDble( mfGet( x, i1 ) )
            x2 = mfDble( mfGet( x, i2 ) )
            x3 = mfDble( mfGet( x, i3 ) )
            y1 = mfDble( mfGet( y, i1 ) )
            y2 = mfDble( mfGet( y, i2 ) )
            y3 = mfDble( mfGet( y, i3 ) )
            handle = mfPlot( mf([x1,x2,x3,x1]),                         &
                             mf([y1,y2,y3,y1]), "r" )
         end if
      end do
   else
#endif
      xp = 0.25d0
      yp = 0.25d0
      num = mfTriSearch( tri_connect, xp, yp )
      print "(1X,A,I0)", "enclosing triangle: ", num
#ifndef _NO_X11
   end if
#endif

   ! non-strict mode
   print *, "Triangle Search in Non-Strict mode"
   handle = 0
#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      do
         p = mfGinput()
         if( mfIsEqual(p,MF_EMPTY) ) then
            exit
         end if
         if( handle /= 0 ) then
            call msRemoveGrObj( handle )
            handle = 0
         end if
         xp = mfDble( mfGet(p,1) )
         yp = mfDble( mfGet(p,2) )
         num = mfTriSearch( tri_connect, xp, yp, strict=.false. )
         print "(1X,A,I0)", "enclosing (or nearest) triangle: ", num
         i1 = mfDble( mfGet(tri,num,1) )
         i2 = mfDble( mfGet(tri,num,2) )
         i3 = mfDble( mfGet(tri,num,3) )
         x1 = mfDble( mfGet( x, i1 ) )
         x2 = mfDble( mfGet( x, i2 ) )
         x3 = mfDble( mfGet( x, i3 ) )
         y1 = mfDble( mfGet( y, i1 ) )
         y2 = mfDble( mfGet( y, i2 ) )
         y3 = mfDble( mfGet( y, i3 ) )
         handle = mfPlot( mf([x1,x2,x3,x1]),                            &
                          mf([y1,y2,y3,y1]), "r" )
      end do
   else
#endif
      xp = 0.25d0
      yp = 0.25d0
      num = mfTriSearch( tri_connect, xp, yp, strict=.false. )
      print "(1X,A,I0)", "enclosing (or nearest) triangle: ", num
#ifndef _NO_X11
   end if
#endif

   call msClf

   nb_pt = size( x, 1 )
   do i = 1, nb_pt
      x1 = mfDble( mfGet( x, i ) )
      y1 = mfDble( mfGet( y, i ) )
      call msPlot( mf(x1), mf(y1), "bo" )
      write(string,"(I0)") i
      call msText( x1+0.01, y1+0.01, trim(string) )
   end do

   ! strict mode
   print *, "Node Search in Strict mode"
   handle = 0
#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      do
         p = mfGinput()
         if( mfIsEqual(p,MF_EMPTY) ) then
            exit
         end if
         if( handle /= 0 ) then
            call msRemoveGrObj( handle )
            handle = 0
         end if
         xp = mfDble( mfGet(p,1) )
         yp = mfDble( mfGet(p,2) )
         num = mfNodeSearch( tri_connect, xp, yp )
         if( num == 0 ) then
            print *, "point is not in the convex hull!"
         else
            print "(1X,A,I0)", "nearest point: ", num
            x1 = mfDble( mfGet( x, num ) )
            y1 = mfDble( mfGet( y, num ) )
            handle = mfPlot( mf(x1), mf(y1), "ro" )
         end if
      end do
   else
#endif
      xp = 0.25d0
      yp = 0.55d0
      num = mfNodeSearch( tri_connect, xp, yp )
      print "(1X,A,I0)", "nearest point: ", num
#ifndef _NO_X11
   end if
#endif

   ! non-strict mode
   print *, "Node Search in Non-Strict mode"
   handle = 0
#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      do
         p = mfGinput()
         if( mfIsEqual(p,MF_EMPTY) ) then
            exit
         end if
         if( handle /= 0 ) then
            call msRemoveGrObj( handle )
            handle = 0
         end if
         xp = mfDble( mfGet(p,1) )
         yp = mfDble( mfGet(p,2) )
         num = mfNodeSearch( tri_connect, xp, yp, strict=.false. )
         print "(1X,A,I0)", "nearest point: ", num
         x1 = mfDble( mfGet( x, num ) )
         y1 = mfDble( mfGet( y, num ) )
         handle = mfPlot( mf(x1), mf(y1), "ro" )
      end do
   else
#endif
      xp = -1.0d0
      yp = -1.0d0
      num = mfNodeSearch( tri_connect, xp, yp, strict=.false. )
      print "(1X,A,I0)", "nearest point: ", num
#ifndef _NO_X11
   end if
#endif

   !=================================================================

   call msFigure(2)
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 2.1d0] )
   call msAxis( "equal" )

   ! L-shaped domain
   allocate( PL_domain%n_xy(6,2) )
   PL_domain%n_xy(:,1) = [ 0.0d0, 2.0d0, 2.0d0, 1.0d0, 1.0d0, 0.0d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.0d0, 0.0d0, 1.0d0, 1.0d0, 2.0d0, 2.0d0 ] ! y
   allocate( PL_domain%edge_n(6,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4, 5, 6 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 5, 6, 1 ]
   allocate( PL_domain%holes_xy(1,2) )
   PL_domain%holes_xy(1,1) = 1.25d0 ! x
   PL_domain%holes_xy(1,2) = 1.25d0 ! y

   call msPlotPLdomain( PL_domain, color=[0.75d0,0.75d0,0.75d0],            &
                    linewidth=4.5d0,                                    &
                    nod_num=.true., edg_num=.true., hol_num=.true. )

   call msPrint( "Delaunay_PLdomain_only.eps" )
   call msPrint( "Delaunay_PLdomain_only.pdf" )

   call msPause()

   !------------------------------

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,        &
                    area_max=0.01d0 )

   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0],             &
                   nod_num=.true., tri_num=.true. )
#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      ! interactive part
      call msPanAndZoom()
   end if
#endif

   call msPrint( "Delaunay_PLdomain_mesh.eps" )
   call msPrint( "Delaunay_PLdomain_mesh.pdf" )

   call msPause()

   ! test to show that TriContour is possible on a non-convex domain
   call msClf()
   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0],             &
                   boundary_only=.true. )

   call msPrint( "Delaunay_PLdomain_Boundary_only.eps" )
   call msPrint( "Delaunay_PLdomain_Boundary_only.pdf" )

   call msHold( "on" )
   z = (x-1.0d0)**2 + (y-1.0d0)**2
   call msColormap( "rainbow" )
   call msTriContourF( x, y, z, tri, labels=.false. )

   call msRelease( PL_domain )

   call msPrint( "Delaunay_PLdomain_ContourF.eps" )
   call msPrint( "Delaunay_PLdomain_ContourF.pdf" )

   call msPause()

   !=================================================================

   call msFigure(3,size=[800,800])
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 2.1d0] )
   call msAxis( "equal" )

   ! L-shaped domain
   allocate( PL_domain%n_xy(18,2) )
   PL_domain%n_xy(:,1) = [ 0.0d0, 2.0d0, 2.0d0, 1.0d0, 1.0d0, 0.0d0,    &
                             0.2d0, 0.8d0, 0.8d0, 0.2d0,                &
                             0.2d0, 0.8d0, 0.8d0, 0.2d0,                &
                             1.2d0, 1.8d0, 1.8d0, 1.2d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.0d0, 0.0d0, 1.0d0, 1.0d0, 2.0d0, 2.0d0,    &
                             1.2d0, 1.2d0, 1.8d0, 1.8d0,                &
                             0.2d0, 0.2d0, 0.8d0, 0.8d0,                &
                             0.2d0, 0.2d0, 0.8d0, 0.8d0 ] ! y
   allocate( PL_domain%edge_n(18,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 5, 6, 1, 8, 9, 10, 7, 12, 13, 14, 11, 16, 17, 18, 15 ]
   allocate( PL_domain%holes_xy(4,2) )
   PL_domain%holes_xy(1,1) = 1.25d0 ! x
   PL_domain%holes_xy(1,2) = 1.25d0 ! y
   PL_domain%holes_xy(2,1) = 0.5d0 ! x
   PL_domain%holes_xy(2,2) = 1.5d0 ! y
   PL_domain%holes_xy(3,1) = 0.5d0 ! x
   PL_domain%holes_xy(3,2) = 0.5d0 ! y
   PL_domain%holes_xy(4,1) = 1.5d0 ! x
   PL_domain%holes_xy(4,2) = 0.5d0 ! y

   call msPlotPLdomain( PL_domain, color=[0.75d0,0.75d0,0.75d0],        &
                        linewidth=4.5d0,                                &
                        nod_num=.true., edg_num=.true., hol_num=.true. )

   call msPause()

   !=================================================================

   call msFigure(4,size=[800,800])
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 2.1d0] )
   call msAxis( "equal" )

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,        &
                    area_max=0.1d0 )

   call msBuildTriConnect( x, y, tri, tri_connect )

   call msTriMesh( tri_connect, color=[0.75d0,0.75d0,0.75d0],           &
                   nod_num=.true., tri_num=.true., fac_num=.true. )

   j = mfTriSearch( tri_connect, 1.2d0, 1.2d0 )
   print "(2X,A,I0)", "TriSearch for pt(1.2,1.2): tri found is #", j

   j = mfTriSearch( tri_connect, 1.0d0, 0.5d0 )
   print "(2X,A,I0)", "TriSearch for pt(1.0,0.5): tri found is #", j

   j = mfTriSearch( tri_connect, 1.9d0, 0.4d0 )
   print "(2X,A,I0)", "TriSearch for pt(1.9,0.4): tri found is #", j

   j = mfTriSearch( tri_connect, 0.3d0, 1.3d0 )
   print "(2X,A,I0)", "TriSearch for pt(0.3,1.3): tri found is #", j

   j = mfTriSearch( tri_connect, 1.5d0, 0.5d0 )
   print "(2X,A,I0)", "TriSearch for pt(1.5,0.5): tri found is #", j

   print "(/,A)", "------------------------"

   j = mfNodeSearch( tri_connect, 1.2d0, 1.2d0 )
   print "(2X,A)",        "NodeSearch for pt(1.2,1.2):"
   print "(2X,A,I0,A,/)", "  node found is #", j, " (strict=TRUE)"

   j = mfNodeSearch( tri_connect, 1.2d0, 1.2d0, strict=.false. )
   print "(2X,A)",        "NodeSearch for pt(1.2,1.2):"
   print "(2X,A,I0,A,/)", "  node found is #", j, " (strict=FALSE)"

   j = mfNodeSearch( tri_connect, 0.7d0, 0.7d0, strict=.false. )
   print "(2X,A)",        "NodeSearch for pt(0.7,0.7):"
   print "(2X,A,I0,A,/)", "  node found is #", j, " (strict=FALSE)"

   call msPause()

   ! test to show that TriContour is possible on a non-convex domain,
   ! and with possible hole(s)...
   call msClf()
   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,        &
                    area_max=0.01d0 )
   call msBuildTriConnect( x, y, tri, tri_connect )
   call msTriMesh( tri_connect, color=[0.75d0,0.75d0,0.75d0],           &
                   boundary_only=.true. )
   call msHold( "on" )
   z = (x-1.0d0)**2 + (y-1.0d0)**2
call msColormap( "rainbow" )
   call msTriContourF( x, y, z, tri )

   call msPrint( "TriContour_on_non-convex_mesh.eps" )
   call msPrint( "TriContour_on_non-convex_mesh.pdf" )

   call msRelease( PL_domain )

   call msPause()

   !=================================================================

   call msFigure(5,size=[800,800])
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 2.1d0] )
   call msAxis( "equal" )

   ! Squared domain
   allocate( PL_domain%n_xy(4,2) )
   PL_domain%n_xy(:,1) = [ 0.0d0, 2.0d0, 2.0d0, 0.0d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.0d0, 0.0d0, 2.0d0, 2.0d0 ] ! y
   allocate( PL_domain%edge_n(4,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 1 ]

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,        &
                    area_max=0.025d0 )

   call msTriMesh( x, y, tri, color=[0.85d0,0.85d0,0.85d0] )

   call msHold( "on" )
   z = (x-1.0d0)**2 + (y-1.0d0)**2

   ! for area_max = 0.025
!   call msSet( MF_NAN, z, [ 18, 14, 122, 135 ] )

   call msTriContour( x, y, z, tri, linespec="r", linewidth=1.5d0 )

   call msPrint( "TriContour_with_NaN_values_a.eps" )
   call msPrint( "TriContour_with_NaN_values_a.pdf" )

!### msTriContourF not yet ready for NaN values in Z.
   call msPause()

   call msClf()

   call msColormap( "rainbow" )
   call msTriContourF( x, y, z, tri, linewidth=1.5d0 )

   call msRelease( PL_domain )

   call msPause()

   !=================================================================

   call msFigure(6,size=[800,800])
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 2.1d0, -0.1d0, 2.1d0] )
   call msAxis( "equal" )

   ! Squared domain
   allocate( PL_domain%n_xy(4,2) )
   PL_domain%n_xy(:,1) = [ 0.0d0, 2.0d0, 2.0d0, 0.0d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.0d0, 0.0d0, 2.0d0, 2.0d0 ] ! y
   allocate( PL_domain%edge_n(4,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 1 ]

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=28.6d0,        &
                    area_max=0.025d0 )

   call msBuildTriConnect( x, y, tri, tri_connect )
   call msTriMesh( tri_connect, color=[0.85d0,0.85d0,0.85d0] )

   call msHold( "on" )
   z = (x-1.0d0)**2 + (y-1.0d0)**2

   ! for area_max = 0.025
   call msSet( MF_NAN, z, [ 18, 14, 122, 135 ] )

   call msTriContour( z, tri_connect, linespec="b", linewidth=2.5d0 )

   call msPrint( "TriContour_with_NaN_values_b.eps" )
   call msPrint( "TriContour_with_NaN_values_b.pdf" )

   call msRelease( PL_domain )

   !=================================================================

   call msFigure(7,size=[800,800])
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height )
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )

   ! Squared domain
   allocate( PL_domain%n_xy(12,2) )
   PL_domain%n_xy(:,1) = [ 0.00d0, 1.00d0, 1.00d0, 0.00d0,              &
                             0.20d0, 0.20d0, 0.40d0, 0.47d0,            &
                             0.65d0, 0.58d0, 0.75d0, 0.85d0 ] ! x
   PL_domain%n_xy(:,2) = [ 0.00d0, 0.00d0, 1.00d0, 1.00d0,              &
                             0.50d0, 0.60d0, 0.40d0, 0.47d0,            &
                             0.80d0, 0.87d0, 0.40d0, 0.40d0 ] ! y
   allocate( PL_domain%edge_n(12,2) )
   PL_domain%edge_n(:,1) = [ 1, 2, 3, 4,  5, 6,  7, 8,   9, 10,   11, 12 ]
   PL_domain%edge_n(:,2) = [ 2, 3, 4, 1,  6, 5,  8, 7,  10,  9,   12, 11 ]

   call msDelaunay( mfOut(x,y,tri), PL_domain, theta_min=25.0d0,        &
                    area_max=0.005d0 )

   call msTriMesh( x, y, tri, color=[0.85d0,0.85d0,0.85d0] )

   call msHold( "on" )

   x = mf(PL_domain%n_xy(1:4,1)) .hc. mf(PL_domain%n_xy(1,1))
   y = mf(PL_domain%n_xy(1:4,2)) .hc. mf(PL_domain%n_xy(1,2))
   call msPlot( x, y, "\C01", linewidth=2.0d0 )

   x = mf(PL_domain%n_xy(5:6,1))
   y = mf(PL_domain%n_xy(5:6,2))
   call msPlot( x, y, "\C02", linewidth=2.0d0 )

   x = mf(PL_domain%n_xy(7:8,1))
   y = mf(PL_domain%n_xy(7:8,2))
   call msPlot( x, y, "\C02", linewidth=2.0d0 )

   x = mf(PL_domain%n_xy(9:10,1))
   y = mf(PL_domain%n_xy(9:10,2))
   call msPlot( x, y, "\C02", linewidth=2.0d0 )

   x = mf(PL_domain%n_xy(11:12,1))
   y = mf(PL_domain%n_xy(11:12,2))
   call msPlot( x, y, "\C02", linewidth=2.0d0 )

   call msPrint( "Delaunay_constrained_by_internal_segments.eps" )
   call msPrint( "Delaunay_constrained_by_internal_segments.pdf" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z, p, tri )
   call msRelease( tri_connect )
   call msRelease( PL_domain )

end program
