program ColorMap_Extern_test

   use fml
   use fgl

   use test_aux

   implicit none

   integer :: iargc
   type(mfArray) :: c
   integer :: nargs, i
   character(len=512)  :: file_in
   logical :: file_exist

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------
   call msFigure(1)

   ! unit square increased to 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )
   call msColorbar( "on" )

   nargs = iargc()
   if( nargs < 1 ) then
      write(STDERR,"(/,A,/)") "  usage: ColorMap_Extern_test <colormap file(s)>"
      write(STDERR,"(A,/)")   "   (ex.) ColorMap_Extern_test colormaps/*"
      stop
   end if

   do i = 1, nargs

      call getarg(i,file_in)

      inquire( file=trim(file_in), exist=file_exist )
      if( .not. file_exist ) then
         write(STDERR,"(A,A,A,/)") "  file: '", trim(file_in), "' not found!"
         stop
      end if

      ! install colormaps (about more or less 256 shades)
      ! from directory 'colormaps' (comes from LabPlot-1.5.0)
      c = mfLoadAscii( trim(file_in) )
      call msColormap( c, int_max=255 )
      call msDisplay( mfShape(c),                                       &
                      "'" // trim(file_in) // "' colormap size" )
      ! repaint graphic window
      call msTitle( trim(file_in) )
      call msRedrawFigure()

      call msPrint( "Colormap_extern.eps" )
      call msPrint( "Colormap_extern.pdf" )

      call msPause()

   end do

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( c )

end program
