program Arrow_test

   use fml
   use fgl

   use test_aux

   implicit none

   integer, allocatable :: hdle_vec(:)
   integer :: i, hdle

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------
   call msFigure(1)

   ! unit square increased to 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )

   call msArrow( -0.75d0, -0.75d0, 0.75d0, 0.75d0 )
   call msText( -0.9d0, -0.85d0, "(foreground color)" )

   hdle = mfArrow( -0.75d0, -0.5d0, 0.25d0, 0.75d0, color="r" )
   ! The following command is used to add a comment only in the EPS file
   ! "Arrow_1.eps (see below its creation) in order to find easily the
   ! PostScript commands related to the graphic object.
   call msSetGrObj( hdle, "EPS_user_comment", "This is the red arrow" )
   call msText( -0.82d0, -0.5d0, "red", color="r" )

   call msArrow( 0.5d0, -0.5d0, 0.0d0, 0.2d0, color=[0.5d0,0.6d0,0.7d0] )
   call msText( 0.55d0, -0.5d0, "grey", color=[0.5d0,0.6d0,0.7d0] )

   call msArrow( 0.25d0, -0.5d0, -0.5d0, -0.25d0, color="light sea green" )
   call msText( 0.15d0, -0.6d0, "light sea green", color="light sea green" )

   print "(/,A,I0,A)", " All handles in figure ", mfGetWinId(), ":"
   hdle_vec = mfGetAllGrObj( )
   do i = 1, size(hdle_vec)
      print *, "    handle = ", hdle_vec(i),                            &
               "    type = ", mfGetTypeGrObj( hdle_vec(i) )
   end do
   print *, "Among the previous list, selecting only 'text' type:"
   hdle_vec = mfSelectTypeGrObj( hdle_vec, "text" )
   do i = 1, size(hdle_vec)
      print *, "    handle = ", hdle_vec(i),                            &
               "    type = ", mfGetTypeGrObj( hdle_vec(i) )
   end do

   call msPrint("Arrow_1.eps")
   call msPrint("Arrow_1.pdf")

   !----------------------------------
   call msFigure(2)
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )
   call msHold( "on" )

   call msPatch( mf([-1,0,0,-1]), mf([-1,-1,0,0]), color="c" )

   call msPatch( mf([0,1,1,0]), mf([0,0,1,1]), color="b" )

   call msPatch( mf([-1,0,0,-1]), mf([0,0,1,1]),                        &
                 color=[0.25d0,0.25d0,0.25d0] )

   call msPatch( mf([0,1,1,0]), mf([-1,-1,0,0]),                        &
                 color=[0.75d0,0.75d0,0.75d0] )

   call msArrow( -0.25d0, -0.75d0, 0.75d0, 0.25d0 )

   call msArrow( 0.25d0, -0.75d0, -0.75d0, 0.25d0, color="k" )

   call msArrow( -0.25d0, 0.75d0, 0.75d0, -0.25d0 )

   call msArrow( 0.25d0, 0.75d0, -0.75d0, -0.25d0, color="k" )

   print "(/,A,I0,A)", " All handles in figure ", mfGetWinId(), ":"
   hdle_vec = mfGetAllGrObj( )
   do i = 1, size(hdle_vec)
      print *, "    handle = ", hdle_vec(i),                            &
               "    type = ", mfGetTypeGrObj( hdle_vec(i) )
   end do
   print *, "Among the previous list, selecting only 'arrow' type:"
   hdle_vec = mfSelectTypeGrObj( hdle_vec, "arrow" )
   do i = 1, size(hdle_vec)
      print *, "    handle = ", hdle_vec(i),                            &
               "    type = ", mfGetTypeGrObj( hdle_vec(i) )
   end do

   call msPrint("Arrow_2.eps")
   call msPrint("Arrow_2.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   deallocate( hdle_vec )

end program
