! f90 include file
!
! list of Fortran 90 interfaces for the JC_VORONOI wrapper routines,
! stored in the file: 'voronoi_f90wrapper.c'.
!
! É. Canot -- IPR/CNRS -- 2024-10-06

interface
!_______________________________________________________________________
!
   subroutine jcv_voronoi_prep( x_min, x_max, y_min, y_max,             &
                                nb_pts, x_pts, y_pts,                   &
                                nb_edges, nb_neighbors,                 &
                                nb_vertices, perm_sites )
      double precision, intent(in)  :: x_min, x_max, y_min, y_max
      integer,          intent(in)  :: nb_pts
      double precision, intent(in)  :: x_pts(*), y_pts(*)
      integer,          intent(out) :: nb_edges, nb_neighbors, nb_vertices
      integer,          intent(out) :: perm_sites(*)
   end subroutine jcv_voronoi_prep
!_______________________________________________________________________
!
   function jcv_voronoi_get_edges( ptr_edges, list_edges, x_vert, y_vert )
      integer,          intent(out) :: ptr_edges(*), list_edges(*)
      double precision, intent(out) :: x_vert(*), y_vert(*)
      integer                       :: jcv_voronoi_get_edges
   end function jcv_voronoi_get_edges
!_______________________________________________________________________
!
   subroutine jcv_voronoi_get_neighbors( ptr_neighbors, neighbors )
      integer,          intent(out) :: ptr_neighbors(*), neighbors(*)
   end subroutine jcv_voronoi_get_neighbors
!_______________________________________________________________________
!
   subroutine jcv_voronoi_free()
   end subroutine jcv_voronoi_free
!_______________________________________________________________________
!
end interface
