!DECK DSTOD
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 3 feb 2022
!
   SUBROUTINE DSTOD( NEQ, Y, YH, NYH, YH1, EWT, SAVF, ACOR, WM, IWM,    &
                     DF, DJAC, SPDJAC, CHECK_JAC, PRINT_CHECK_JAC )

      use mod_mfdebug, only: MF_NUMERICAL_CHECK
      use mod_mfaux, only: mf_save_and_disable_fpe, mf_restore_fpe

      implicit none

      integer :: NEQ, NYH, IWM(*)

      double precision :: Y(*), YH(NYH,*), YH1(*), EWT(*), SAVF(*),     &
                          ACOR(*), WM(*)

      INTEGER :: CHECK_JAC, PRINT_CHECK_JAC

      EXTERNAL DF, DJAC, SPDJAC

!***BEGIN PROLOGUE  DSTOD
!***SUBSIDIARY
!***PURPOSE  Subsidiary to DDEBDF
!***LIBRARY   SLATEC
!***TYPE      DOUBLE PRECISION (STOD-S, DSTOD-D)
!***AUTHOR  Watts, H. A., (SNLA)
!***DESCRIPTION
!
!   DSTOD integrates a system of first order ODEs over one step in the
!   integrator package DDEBDF.
! ----------------------------------------------------------------------
! DSTOD  performs one step of the integration of an initial value
! problem for a system of Ordinary Differential Equations (ODEs).
! Note: DSTOD  is independent of the value of the iteration method
! indicator MITER, when this is /= 0, and hence is independent
! of the type of chord method used, or the Jacobian structure.
!
! Communication with DSTOD is done with the following variables:
! (some of them are arguments, the others are in the /DDEBD1/ common)
!
! Y      = An array of length >= N used as the Y argument in
!          all calls to DF, DJAC and SPDJAC.
! NEQ    = Integer containing problem size (should be equal to N).
! YH     = An NYH by LMAX array containing the dependent variables
!          and their approximate scaled derivatives, where
!          LMAX = MAXORD + 1.  YH(I,J+1) contains the approximate
!          J-th derivative of Y(I), scaled by H**J/FACTORIAL(J)
!          (J = 0,1,...,NQ).  On entry for the first step, the first
!          two columns of YH must be set from the initial values.
!          NQ is the (variable) order of the method (1 to 5).
! NYH    = A constant integer >= N, the first dimension of YH.
! YH1    = A one-dimensional array having same address and size as YH.
!          [Hence, all modifications made into YH1 occur also
!           in YH(:,1)]
! EWT    = An array of N elements with which the estimated local
!          errors in YH are compared.
! SAVF   = An array of working storage, of length N.
! ACOR   = A work array of length N, used for the accumulated
!          corrections.  On a successful return, ACOR(I) contains
!          the estimated one-step local error in Y(I).
! WM,IWM = DOUBLE PRECISION and INTEGER work arrays associated with
!          matrix operations in chord iteration (MITER /= 0).
! DF     = User routine which computes the derivatives of all equations.
! DJAC   = User routine which computes the jacobian matrix in dense
!          or banded storage.
! SPDJAC = User routine which computes the jacobian matrix in sparse
!          storage (CSC = Compact Sparse Columns).
! CHECK_JAC = Flag to check that numerical values from DJAC or SPDJAC
!          are not NaN.
! PRINT_CHECK_JAC = For debugging purpose, flag to print the jacobian
!          matrix in a file.
!
!  *** Hereafter, these variables are in the /DDEBD1/ common
!
! H      = The step size to be attempted on the next step.
!          H is altered by the error control algorithm during the
!          problem.  H can be either positive or negative, but its
!          sign must remain constant throughout the problem.
! HMIN   = The minimum absolute value of the step size H to be used.
! HMXI   = Inverse of the maximum absolute value of H to be used.
!          HMXI = 0.0 is allowed and corresponds to an infinite HMAX.
!          HMIN and HMXI may be changed at any time, but will not
!          take effect until the next change of H is considered.
! TN     = The independent variable. TN is updated on each step taken.
! JSTART = An integer used for input only, with the following
!          values and meanings:
!               0  Perform the first step.
!             > 0  Take a new step continuing from the last.
!              -1  Take the next step with a new value of H, MAXORD,
!                    N, METH, MITER, and/or matrix parameters.
!              -2  Take the next step with a new value of H,
!                    but with other inputs unchanged.
!          On return, JSTART is set to 1 to facilitate continuation.
! KFLAG  = A completion code with the following meanings:
!               0  The step was successful.
!              -1  The requested error could not be achieved.
!              -2  Corrector convergence could not be achieved.
!                  (internally, KFLAG may be decreased down to -10)
!
!             -20  'Emergency exit'    encountered in 'DF' routine
!             -21  'Illegal condition' encountered in 'DF' routine
!             -22  'End condition'     encountered in 'DF' routine
!          A return with KFLAG = -1 or -2 means either
!          ABS(H) = HMIN or 10 consecutive failures occurred.
!          On a return with KFLAG negative, the values of TN and
!          the YH array are as of the beginning of the last
!          step, and H is the last step size attempted.
! MAXORD = The maximum order of integration method to be allowed (5).
! METH/MITER = The method flags.  See description in driver.
! N      = The number of first-order differential equations.
!
! External routines:
! DPJAC  = Name of routine to evaluate and preprocess Jacobian matrix
!          if a chord method is being used.
! DSLVS  = Name of routine to solve linear system in chord iteration.
!
! ----------------------------------------------------------------------
!
!***SEE ALSO  DDEBDF
!***ROUTINES CALLED  DCFOD, DPJAC, DSLVS, DVNRMS
!***COMMON BLOCKS    DDEBD1
!***REVISION HISTORY  (YYMMDD)
!   820301  DATE WRITTEN
!   920422  Last modification. For details see original file.
!***END PROLOGUE  DSTOD

      INTEGER :: I, I1, IALTH, IER, IOD, IOWND, IPUP, IREDO, IRET,      &
                 J, JB, JSTART, KFLAG, KSTEPS, L, LMAX, M,              &
                 MAXORD, MEO, METH, MITER, N, NCF, NEWQ, NFE, NJE,      &
                 NQ, NQNYH, NQU, NST, NSTEPJ, ISPARSE, IUSERCALL,       &
                 JAC_OUTDATED
      DOUBLE PRECISION :: CONIT, CRATE, DCON, DDN, DEL, DELP,           &
                          DSM, DUP, EL, EL0, ELCO, EXDN, EXSM,          &
                          EXUP, H, HMIN, HMXI, HOLD, HU, R, RC, RH,     &
                          RHDN, RHSM, RHUP, RMAX, ROWND, TESCO,         &
                          TN, TOLD, UROUND

      COMMON /DDEBD1/ ROWND, CONIT, CRATE, EL(13), ELCO(13,12), HOLD,   &
                      RC, RMAX, TESCO(3,12), EL0, H, HMIN, HMXI, HU, TN, &
                      UROUND,                                           &
                      IOWND(7), KSTEPS, IOD(6), IALTH, IPUP, LMAX, MEO, &
                      NQNYH, NSTEPJ, IER, JSTART, KFLAG, L, METH, MITER, &
                      MAXORD, N, NQ, NST, NFE, NJE, NQU, ISPARSE,       &
                      IUSERCALL, JAC_OUTDATED

      ! communication with slatec/drkfs.f, slatec/dfehl.f, slatec/dhstrt.f
      !                    slatec/ddes.f, slatec/dsteps.f
      !                    slatec/dlsod.f, slatec/dstod.f
      !                    [fml_funfun]/msOdeSolve_JacDF
      !                    [fml_funfun]/msOdeSolve_JacUser
      !                    [fml_funfun]/msOdeSolve_JacUserSP
      integer :: nb_step, nb_deriv
      double precision :: dt_min, dt_max
      common /slatec_odesolve_1/ dt_min, dt_max, nb_step, nb_deriv
      integer :: nb_jac, nb_solv
      common /slatec_odesolve_2/ nb_jac, nb_solv

      integer :: iflag

      integer :: i_eqn_group, i_group_eqn

      if( MITER == 2 ) then
         ! Only when the jacobian is computed by Finite Differences,
         ! we have to check a continuation without jacobian save.
         if( JAC_OUTDATED == 1 ) then
            JSTART = -1 ! required level of restart, when the continuation
                        ! is done without the jacobian...
            JAC_OUTDATED = 0
         end if
      end if

      KFLAG = 0
      TOLD = TN
      NCF = 0
      IF( JSTART > 0 ) GO TO 160
      IF( JSTART == -1 ) GO TO 10
      IF( JSTART == -2 ) GO TO 90
      !-----------------------------------------------------------------
      ! On the first call, the order is set to 1, and other variables are
      ! initialized.  RMAX is the maximum ratio by which H can be increased
      ! in a single step.  It is initially 1.e4 to compensate for the small
      ! initial H, but then is normally equal to 10.  If a failure occurs
      ! (in corrector convergence or error test), RMAX is set at 2 for the
      ! next increase.
      !-----------------------------------------------------------------
      LMAX = MAXORD + 1
      NQ = 1
      L = 2
      IALTH = 2
      RMAX = 10000.0D0
      RC = 0.0D0
      EL0 = 1.0D0
      CRATE = 0.7D0
      DELP = 0.0D0
      HOLD = H
      MEO = METH
      NSTEPJ = 0
      IRET = 3
      GO TO 50
  10  CONTINUE
      !-----------------------------------------------------------------
      ! The following block handles preliminaries needed when JSTART = -1.
      ! IPUP is set to MITER to force a matrix update.  If an order
      ! increase is about to be considered (IALTH = 1), IALTH is reset to
      ! 2 to postpone consideration one more step.  If the caller has
      ! changed METH, DCFOD  is called to reset the coefficients of the
      ! method.  If the caller has changed MAXORD to a value less than
      ! the current order NQ, NQ is reduced to MAXORD, and a new H chosen
      ! accordingly.  If H is to be changed, YH must be rescaled.  If H
      ! or METH is being changed, IALTH is reset to L = NQ + 1 to prevent
      ! further changes in H for that many steps.
      !-----------------------------------------------------------------
      IPUP = MITER
      LMAX = MAXORD + 1
      IF( IALTH == 1 ) IALTH = 2
      if( METH /= MEO ) then
         CALL DCFOD( METH, ELCO, TESCO )
         MEO = METH
         IF( NQ > MAXORD ) GO TO 30
         IALTH = L
         IRET = 1
         GO TO 60
      end if
      IF( NQ <= MAXORD ) GO TO 90
  30  CONTINUE
      NQ = MAXORD
      L = LMAX
      DO I = 1, L
         EL(I) = ELCO(I,NQ)
      END DO
      NQNYH = NQ*NYH
      RC = RC*EL(1)/EL0
      EL0 = EL(1)
      CONIT = 0.5D0/(NQ+2)
      DDN = DVNRMS(N,SAVF,EWT)/TESCO(1,L)
      EXDN = 1.0D0/L
      RHDN = 1.0D0/(1.3D0*DDN**EXDN + 0.0000013D0)
      RH = MIN(RHDN,1.0D0)
      IREDO = 3
      IF( H == HOLD ) GO TO 660
      RH = MIN(RH,ABS(H/HOLD))
      H = HOLD
      GO TO 100
  50  CONTINUE
      !-----------------------------------------------------------------
      ! DCFOD  is called to get all the integration coefficients for the
      ! current METH.  Then the EL vector and related constants are reset
      ! whenever the order NQ is changed, or at the start of the problem.
      !-----------------------------------------------------------------
      CALL DCFOD(METH,ELCO,TESCO)
  60  CONTINUE
  70  CONTINUE
      DO I = 1, L
         EL(I) = ELCO(I,NQ)
      END DO
      NQNYH = NQ*NYH
      RC = RC*EL(1)/EL0
      EL0 = EL(1)
      CONIT = 0.5D0/(NQ+2)
      GO TO (90,660,160), IRET
      !-----------------------------------------------------------------
      ! If H is being changed, the H ratio RH is checked against RMAX,
      ! HMIN, and HMXI, and the YH array rescaled.  IALTH is set to L =
      ! NQ + 1 to prevent a change of H for that many steps, unless
      ! forced by a convergence or error test failure.
      !-----------------------------------------------------------------
   90 CONTINUE
      IF( H == HOLD ) GO TO 160
      RH = H/HOLD
      H = HOLD
      IREDO = 3
  100 CONTINUE
  110 CONTINUE
      RH = MIN(RH,RMAX)
      RH = RH/MAX(1.0D0,ABS(H)*HMXI*RH)
      R = 1.0D0
      DO J = 2, L
         R = R*RH
         DO I = 1, N
            YH(I,J) = YH(I,J)*R
         END DO
      END DO
      H = H*RH
      RC = RC*RH
      IALTH = L
      if( IREDO == 0 ) then
         RMAX = 10.0D0
         R = 1.0D0/TESCO(2,NQU)
         DO I = 1, N
            ACOR(I) = ACOR(I)*R
         END DO
         GO TO 690
      end if
      !-----------------------------------------------------------------
      ! This section computes the predicted values by effectively
      ! multiplying the YH array by the Pascal triangle matrix.  RC is
      ! the ratio of new to old values of the coefficient  H*EL(1).
      ! When RC differs from 1 by more than 30 percent, IPUP is set to
      ! MITER to force DPJAC to be called, if a jacobian is involved.
      ! In any case, DPJAC is called at least every 20-th step.
      !-----------------------------------------------------------------
  160 CONTINUE
  170 CONTINUE
      IF( ABS(RC-1.0D0) > 0.3D0 ) IPUP = MITER
      IF( NST >= NSTEPJ + 20 ) IPUP = MITER
      TN = TN + H
      I1 = NQNYH + 1
      DO JB = 1, NQ
         I1 = I1 - NYH
         DO I = I1, NQNYH
            YH1(I) = YH1(I) + YH1(I+NYH)
         END DO
      END DO
      KSTEPS = KSTEPS + 1
      !-----------------------------------------------------------------
      ! Up to 3 corrector iterations are taken.  A
      ! convergence test is made on the R.M.S. norm
      ! of each correction, weighted by the error
      ! weight vector EWT.  The sum of the
      ! corrections is accumulated in the vector
      ! ACOR(I).  The YH array is not altered in the
      ! corrector loop.
      !-----------------------------------------------------------------
  200 CONTINUE
      M = 0
      DO I = 1, N
         Y(I) = YH(I,1)
      END DO
      nb_deriv = nb_deriv + 1
      iflag = 0

      call mf_restore_fpe( )
      CALL DF( TN, Y, SAVF, iflag )
      call mf_save_and_disable_fpe( )
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do i = 1, neq
            if( isnan(SAVF(i)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [BDF/dstod] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(i) for i = ", i
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( i, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               return
            end if
         end do
      endif
      if( iflag == -2 ) then
         KFLAG = -20
         return
      else if( iflag == -1 ) then
         KFLAG = -21
         HOLD = H
         return
      else if( iflag == 3 ) then
         KFLAG = -22
         return
      end if
      NFE = NFE + 1

      IF( IPUP <= 0 ) GO TO 220
      !-----------------------------------------------------------------
      ! If indicated, the matrix P = I - H*EL(1)*J is reevaluated and
      ! preprocessed before starting the corrector iteration.
      ! IPUP is set to 0 as an indicator that this has been done.
      !-----------------------------------------------------------------
      IPUP = 0
      RC = 1.0D0
      NSTEPJ = NST
      CRATE = 0.7D0
      nb_jac = nb_jac + 1
      CALL DPJAC( NEQ, Y, YH, NYH, EWT, ACOR, SAVF, WM, IWM, DF,        &
                  iflag, DJAC, SPDJAC, CHECK_JAC, PRINT_CHECK_JAC )
      if( iflag == -2 ) then
         KFLAG = -20
         return
      else if( iflag == -1 ) then
         KFLAG = -21
         HOLD = H
         return
      else if( iflag == 3 ) then
         KFLAG = -22
         return
      end if
      IF( IER /= 0 ) GO TO 440
  220 CONTINUE
      DO I = 1, N
         ACOR(I) = 0.0D0
      END DO
  240 CONTINUE
      IF( MITER /= 0 ) GO TO 270
      !-----------------------------------------------------------------
      ! In the case of functional iteration, update Y directly from the
      ! result of the last function evaluation.
      !-----------------------------------------------------------------
      DO I = 1, N
         SAVF(I) = H*SAVF(I) - YH(I,2)
         Y(I) = SAVF(I) - ACOR(I)
      END DO
      DEL = DVNRMS(N,Y,EWT)
      DO I = 1, N
         Y(I) = YH(I,1) + EL(1)*SAVF(I)
         ACOR(I) = SAVF(I)
      END DO
      GO TO 300
  270 CONTINUE
      !-----------------------------------------------------------------
      ! In the case of the chord method, compute the corrector error, and
      ! solve the linear system with that as right-hand side and P as
      ! coefficient matrix.
      !-----------------------------------------------------------------
      DO I = 1, N
         Y(I) = H*SAVF(I) - (YH(I,2) + ACOR(I))
      END DO

      ! If the jacobian is not ready (due to continuation)
      ! => set up again of the jacobian
      ! (see also the case MITER=2, processed at the beginning ot his routine)
      if( MITER == 6 ) then
         ! sparse jacobian
         if( numeric == 0 .and. symbolic == 0 ) then
            CALL DPJAC( NEQ, Y, YH, NYH, EWT, ACOR, SAVF, WM, IWM, DF, &
                        iflag, DJAC, SPDJAC, CHECK_JAC, PRINT_CHECK_JAC )
         end if
      else
         if( JAC_OUTDATED == 1 ) then
            CALL DPJAC( NEQ, Y, YH, NYH, EWT, ACOR, SAVF, WM, IWM, DF, &
                        iflag, DJAC, SPDJAC, CHECK_JAC, PRINT_CHECK_JAC )
            JAC_OUTDATED = 0
         end if
      end if

      nb_solv = nb_solv + 1
      CALL DSLVS(WM,IWM,Y,SAVF)

      IF( IER /= 0 ) GO TO 430
      DEL = DVNRMS(N,Y,EWT)
      DO I = 1, N
         ACOR(I) = ACOR(I) + Y(I)
         Y(I) = YH(I,1) + EL(1)*ACOR(I)
      END DO
  300 CONTINUE
      !-----------------------------------------------------------------
      ! Test for convergence.  If M > 0, an estimate of the convergence
      ! rate constant is stored in CRATE, and this is used in the test.
      !-----------------------------------------------------------------
      IF( M /= 0 ) CRATE = MAX(0.2D0*CRATE,DEL/DELP)
      DCON = DEL*MIN(1.0D0,1.5D0*CRATE) / (TESCO(2,NQ)*CONIT)
      IF( DCON > 1.0D0 ) GO TO 420
      !-----------------------------------------------------------------
      ! The corrector has converged.  IPUP is set to -1 if MITER /= 0, to
      ! signal that the jacobian involved may need updating later.  The
      ! local error test is made and control passes to statement 500 if it
      ! fails.
      !-----------------------------------------------------------------
      IF( MITER /= 0 ) IPUP = -1
      IF( M == 0 ) DSM = DEL/TESCO(2,NQ)
      IF( M > 0 )                         &
         DSM = DVNRMS(N,ACOR,EWT)         &
               /TESCO(2,NQ)
      IF( DSM > 1.0D0 ) GO TO 380
      !-----------------------------------------------------------------
      ! After a successful step, update the YH array. Consider changing H
      ! if IALTH = 1.  Otherwise decrease IALTH by 1.  If IALTH is then
      ! 1 and NQ < MAXORD, then ACOR is saved for use in a possible order
      ! increase on the next step.  If a change in H is considered, an
      ! increase or decrease in order by one is considered also.  A change
      ! in H is made only if it is by a factor of at least 1.1.  If not,
      ! IALTH is set to 3 to prevent testing for that many steps.
      !-----------------------------------------------------------------
      KFLAG = 0
      IREDO = 0
      NST = NST + 1
      HU = H
      NQU = NQ
      DO J = 1, L
         DO I = 1, N
            YH(I,J) = YH(I,J) + EL(J)*ACOR(I)
         END DO
      END DO
      IALTH = IALTH - 1
      IF( IALTH /= 0 ) GO TO 340
      !-----------------------------------------------------------------
      ! Regardless of the success or failure of the step, factors RHDN,
      ! RHSM, and RHUP are computed, by which H could be multiplied at
      ! order NQ - 1, order NQ, or order NQ + 1, respectively.  In the
      ! case of failure, RHUP = 0.0 to avoid an order increase.  The
      ! largest of these is determined and the new order chosen
      ! accordingly.  If the order is to be increased, we compute one
      ! additional scaled derivative.
      !-----------------------------------------------------------------
      RHUP = 0.0D0
      IF( L == LMAX ) GO TO 490
      DO I = 1, N
         SAVF(I) = ACOR(I) - YH(I,LMAX)
      END DO
      DUP = DVNRMS(N,SAVF,EWT) / TESCO(3,NQ)
      EXUP = 1.0D0/(L+1)
      RHUP = 1.0D0 / (1.4d0*DUP**EXUP + 0.0000014d0 )
      GO TO 490
  340 CONTINUE
      IF( IALTH > 1 ) GO TO 360
      IF( L == LMAX ) GO TO 360
      DO I = 1, N
         YH(I,LMAX) = ACOR(I)
      END DO
  360 CONTINUE
      R = 1.0D0/TESCO(2,NQU)
      DO I = 1, N
         ACOR(I) = ACOR(I)*R
      END DO
      GO TO 690
  380 CONTINUE
      !-----------------------------------------------------------------
      ! The error test failed.  KFLAG keeps track of multiple failures.
      ! Restore TN and the YH array to their previous values, and prepare
      ! to try the step again.  Compute the optimum step size for this
      ! or one lower order.  After 2 or more failures, H is forced to
      ! decrease by a factor of 0.2 or less.
      !-----------------------------------------------------------------
      KFLAG = KFLAG - 1
      TN = TOLD
      I1 = NQNYH + 1
      DO JB = 1, NQ
         I1 = I1 - NYH
         DO I = I1, NQNYH
            YH1(I) = YH1(I) - YH1(I+NYH)
         END DO
      END DO
      RMAX = 2.0D0
      IF( ABS(H) > HMIN*1.00001d0 ) GO TO 410
      !-----------------------------------------------------------------
      ! All returns are made through this section.  H is saved in
      ! HOLD to allow the caller to change H on the next step.
      !-----------------------------------------------------------------
      KFLAG = -1
      GO TO 690
  410 CONTINUE
      IF( KFLAG <= -3 ) GO TO 610
      IREDO = 2
      RHUP = 0.0D0
      GO TO 490
  420 CONTINUE
      M = M + 1
      IF( M == 3 ) GO TO 430
      IF( M >= 2 .AND. DEL > 2.0D0*DELP ) GO TO 430
      DELP = DEL
      nb_deriv = nb_deriv + 1
      iflag = 0

      call mf_restore_fpe( )
      CALL DF( TN, Y, SAVF, iflag )
      call mf_save_and_disable_fpe( )
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do i = 1, neq
            if( isnan(SAVF(i)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [BDF/dstod] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(i) for i = ", i
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( i, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               return
            end if
         end do
      endif

      if( iflag == -2 ) then
         KFLAG = -20
         return
      else if( iflag == -1 ) then
         KFLAG = -21
         HOLD = H
         return
      else if( iflag == 3 ) then
         KFLAG = -22
         return
      end if
      NFE = NFE + 1
      GO TO 240
  430 CONTINUE
      !-----------------------------------------------------------------
      ! The corrector iteration failed to converge in 3 tries.  If
      ! MITER /= 0 and the jacobian is out of date, DPJAC is called for
      ! the next try.  Otherwise the YH array is retracted to its values
      ! before prediction, and H is reduced, if possible.  If H cannot
      ! be reduced or 10 failures have occurred, exit with KFLAG = -2.
      !-----------------------------------------------------------------
      IF( IPUP == 0 ) GO TO 440
      IPUP = MITER
      GO TO 200
  440 CONTINUE
      TN = TOLD
      NCF = NCF + 1
      RMAX = 2.0D0
      I1 = NQNYH + 1
      DO JB = 1, NQ
         I1 = I1 - NYH
         DO I = I1, NQNYH
            YH1(I) = YH1(I) - YH1(I+NYH)
         END DO
      END DO
      if( ABS(H) <= HMIN*1.00001D0 ) then
         KFLAG = -2
         GO TO 690
      end if
      if( NCF == 10) then
         KFLAG = -2
         GO TO 690
      end if
      RH = 0.25D0
      IPUP = MITER
      IREDO = 1
      GO TO 650
  490 CONTINUE
      EXSM = 1.0D0/L
      RHSM = 1.0D0/(1.2D0*DSM**EXSM + 1.2D-6)
      RHDN = 0.0D0
      IF( NQ == 1 ) GO TO 500
         DDN = DVNRMS(N,YH(1,L),EWT)/TESCO(1,NQ)
         EXDN = 1.0D0/NQ
         RHDN = 1.0D0/(1.3D0*DDN**EXDN + 1.3D-6)
  500 CONTINUE
      IF( RHSM >= RHUP ) GO TO 550
         IF( RHUP <= RHDN ) GO TO 540
            NEWQ = L
            RH = RHUP
            IF( RH >= 1.1D0 ) GO TO 520
               IALTH = 3
               R = 1.0D0/TESCO(2,NQU)
               DO I = 1, N
                  ACOR(I) = ACOR(I)*R
               END DO
               GO TO 690
  520       CONTINUE
            R = EL(L)/L
            DO I = 1, N
               YH(I,NEWQ+1) = ACOR(I)*R
            END DO
            NQ = NEWQ
            L = NQ + 1
            IRET = 2
            GO TO 680
  540    CONTINUE
      GO TO 580
  550 CONTINUE
      IF( RHSM < RHDN ) GO TO 580
      NEWQ = NQ
      RH = RHSM
      IF( KFLAG == 0 .AND. RH < 1.1D0 ) GO TO 560
      IF( KFLAG <= -2 ) RH = MIN(RH,0.2D0)
      !-----------------------------------------------------------------
      ! If there is a change of order, reset NQ, L, and the coefficients.
      ! In any case H is reset according to RH and the YH array is
      ! rescaled.  Then exit from 680 if the step was ok, or redo the step
      ! otherwise.
      !-----------------------------------------------------------------
      IF( NEWQ == NQ ) GO TO 650
      NQ = NEWQ
      L = NQ + 1
      IRET = 2
      GO TO 680
  560 CONTINUE
      IALTH = 3
      R = 1.0D0/TESCO(2,NQU)
      DO I = 1, N
         ACOR(I) = ACOR(I)*R
      END DO
      GO TO 690
  580 CONTINUE
      NEWQ = NQ - 1
      RH = RHDN
      IF( KFLAG < 0 .AND. RH > 1.0D0 ) RH = 1.0D0
      IF( KFLAG == 0 .AND. RH < 1.1D0 ) GO TO 590
      IF( KFLAG <= -2 ) RH = MIN(RH,0.2D0)
      !-----------------------------------------------------------------
      ! If there is a change of order, reset NQ, L, and the coefficients
      ! In any case H is reset according to RH and the YH array is
      ! rescaled.  Then exit from 680 if the step was ok, or redo the st
      ! otherwise.
      !-----------------------------------------------------------------
      IF( NEWQ == NQ ) GO TO 650
      NQ = NEWQ
      L = NQ + 1
      IRET = 2
      GO TO 680
  590 CONTINUE
      IALTH = 3
      R = 1.0D0/TESCO(2,NQU)
      DO I = 1, N
         ACOR(I) = ACOR(I)*R
      END DO
      GO TO 690
  610 CONTINUE
      !-----------------------------------------------------------------
      ! Control reaches this section if 3 or more failures have occurred
      ! If 10 failures have occurred, exit with KFLAG = -1.  It is assumed
      ! that the derivatives that have accumulated in the YH array
      ! have errors of the wrong order.  Hence the first derivative is
      ! recomputed, and the order is set to 1.  Then H is reduced by a
      ! factor of 10, and the step is retried, until it succeeds or H
      ! reaches HMIN.
      !-----------------------------------------------------------------
                     IF( KFLAG /= -10 ) GO TO 620
      !-----------------------------------------------------------------
      ! All returns are made through this section.  H is saved in HOLD
      ! to allow the caller to change H on the next step.
      !-----------------------------------------------------------------
      KFLAG = -1
      GO TO 690
  620 CONTINUE
      RH = 0.1D0
      RH = MAX(HMIN/ABS(H),RH)
      H = H*RH
      DO I = 1, N
         Y(I) = YH(I,1)
      END DO
      nb_deriv = nb_deriv + 1
      iflag = 0

      call mf_restore_fpe( )
      CALL DF( TN, Y, SAVF, iflag )
      call mf_save_and_disable_fpe( )
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do i = 1, neq
            if( isnan(SAVF(i)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [BDF/dstod] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(i) for i = ", i
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( i, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               return
            end if
         end do
      endif

      if( iflag == -2 ) then
         KFLAG = -20
         return
      else if( iflag == -1 ) then
         KFLAG = -21
         HOLD = H
         return
      else if( iflag == 3 ) then
         KFLAG = -22
         return
      end if
      NFE = NFE + 1
      DO I = 1, N
         YH(I,2) = H*SAVF(I)
      END DO
      IPUP = MITER
      IALTH = 5
      IF( NQ /= 1 ) GO TO 670
      GO TO 170
  650 CONTINUE
  660 CONTINUE
      RH = MAX(RH,HMIN/ABS(H))
      GO TO 110
  670 CONTINUE
      NQ = 1
      L = 2
      IRET = 3
  680 CONTINUE
      GO TO 70
  690 CONTINUE
      HOLD = H
      JSTART = 1

   END
