!DECK DPBSL
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 25 feb 2019
!
      SUBROUTINE DPBSL( ABD, LDA, N, M, B )
!***BEGIN PROLOGUE  DPBSL
!***PURPOSE  Solve a real symmetric positive definite band system
!            using the factors computed by DPBCO or DPBFA.
!***LIBRARY   SLATEC (LINPACK)
!***CATEGORY  D2B2
!***TYPE      DOUBLE PRECISION (SPBSL-S, DPBSL-D, CPBSL-C)
!***KEYWORDS  BANDED, LINEAR ALGEBRA, LINPACK, MATRIX,
!             POSITIVE DEFINITE, SOLVE
!***AUTHOR  Moler, C. B., (U. of New Mexico)
!***DESCRIPTION
!
!     DPBSL solves the double precision symmetric positive definite
!     band system  A*X = B
!     using the factors computed by DPBCO or DPBFA.
!
!     On Entry
!
!        ABD     DOUBLE PRECISION(LDA, N)
!                the output from DPBCO or DPBFA.
!
!        LDA     INTEGER
!                the leading dimension of the array  ABD .
!
!        N       INTEGER
!                the order of the matrix  A .
!
!        M       INTEGER
!                the number of diagonals above the main diagonal.
!
!        B       DOUBLE PRECISION(N)
!                the right hand side vector.
!
!     On Return
!
!        B       the solution vector  X .
!
!     Error Condition
!
!        A division by zero will occur if the input factor contains
!        a zero on the diagonal.  Technically this indicates
!        singularity, but it is usually caused by improper subroutine
!        arguments.  It will not occur if the subroutines are called
!        correctly, and  INFO = 0 (from DPBCO or DPBFA).
!
!     To compute  INVERSE(A) * C  where  C  is a matrix
!     with  P  columns
!           CALL DPBCO(ABD,LDA,N,RCOND,Z,INFO)
!           IF( RCOND is too small .or. INFO /= 0 ) GO TO ...
!           DO J = 1, P
!              CALL DPBSL(ABD,LDA,N,C(1,J))
!           END DO
!
!***REFERENCES  J. J. Dongarra, J. R. Bunch, C. B. Moler, and G. W.
!                 Stewart, LINPACK Users' Guide, SIAM, 1979.
!***ROUTINES CALLED  DAXPY, DDOT
!***REVISION HISTORY  (YYMMDD)
!   780814  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890831  Modified array declarations.  (WRB)
!   890831  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900326  Removed duplicate information from DESCRIPTION section.
!           (WRB)
!   920501  Reformatted the REFERENCES section.  (WRB)
!***END PROLOGUE  DPBSL

      INTEGER :: LDA, N, M
      DOUBLE PRECISION :: ABD(LDA,*), B(*)

      DOUBLE PRECISION :: DDOT, T
      INTEGER :: K, KB, LA, LB, LM

      !
      !     SOLVE TRANS(R)*Y = B
      !
      DO K = 1, N
         LM = MIN(K-1,M)
         LA = M + 1 - LM
         LB = K - LM
         T = DDOT(LM,ABD(LA,K),1,B(LB),1)
         B(K) = (B(K) - T)/ABD(M+1,K)
      END DO
      !
      !     SOLVE R*X = Y
      !
      DO KB = 1, N
         K = N + 1 - KB
         LM = MIN(K-1,M)
         LA = M + 1 - LM
         LB = K - LM
         B(K) = B(K)/ABD(M+1,K)
         T = -B(K)
         CALL DAXPY(LM,T,ABD(LA,K),1,B(LB),1)
      END DO

      END
