!DECK DLSOD
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 27 jan 2022
!
   SUBROUTINE DLSOD( DF, NEQ, T, Y, TOUT, RTOL, ATOL, IDID, YPOUT, YH,  &
                     YH1, EWT, SAVF, ACOR, WM, IWM, DJAC, INTOUT, TSTOP,&
                     TOLFAC, DELSGN, SPDJAC, CHECK_JAC, PRINT_CHECK_JAC )

      use mod_mfdebug, only: MF_NUMERICAL_CHECK, muesli_trace
      use mod_core, only: MF_DOUBLE, MF_NAN, STDOUT, mf_restore_fpe,    &
          mf_save_and_disable_fpe, sec_2_hms, go_home_on_term, msFlush, &
          msPause

      implicit none

      integer :: NEQ, IDID, IWM(*)
      logical :: INTOUT
      double precision :: T, Y(*), TOUT, RTOL(*), ATOL(*), YPOUT(*),    &
                          YH(NEQ,6), YH1(*), EWT(*), SAVF(*), ACOR(*),  &
                          WM(*), TSTOP, TOLFAC, DELSGN

      EXTERNAL DF, DJAC, SPDJAC
      INTEGER :: CHECK_JAC, PRINT_CHECK_JAC

!***BEGIN PROLOGUE  DLSOD
!***SUBSIDIARY
!***PURPOSE  Subsidiary to DDEBDF
!***LIBRARY   SLATEC
!***TYPE      DOUBLE PRECISION (LSOD-S, DLSOD-D)
!***AUTHOR  (UNKNOWN)
!***DESCRIPTION
!
!   DDEBDF merely allocates storage for DLSOD to relieve the user of
!   the inconvenience of a long call list. Consequently DLSOD is used
!   as described in the comments for DDEBDF.
!
!***SEE ALSO  DDEBDF
!***ROUTINES CALLED  D1MACH, DHSTRT, DINTYD, DSTOD, DVNRMS, XERMSG
!***COMMON BLOCKS    DDEBD1
!***REVISION HISTORY  (YYMMDD)
!   820301  DATE WRITTEN
!   900510  Last modification. For details see original file.
!***END PROLOGUE  DLSOD

      INTEGER :: IBAND, IBEGIN, IER, IINTEG, IJAC, INIT, INTFLG, IOWNS, &
                 IQUIT, ITOL, ITSTOP, JSTART, K, KFLAG, KSTEPS, L,      &
                 LACOR, LDUM, LEWT, LSAVF, LTOL, LWM, LYH, MAXORD,      &
                 METH, MITER, N, NATOLP, NFE, NJE, NQ, NQU, NRTOLP,     &
                 NST, ISPARSE, NDIAG, J, IUSERCALL, JAC_OUTDATED

      ! Warning, the declaration: YH(NEQ,6) implies that MAXORD = 5
      DOUBLE PRECISION :: ABSDEL, BIG, DEL, DT, EL0, H, HA, HMIN, HMXI, &
                          HU, ROWNS, TOL, TOLD, U, X
      LOGICAL :: diag_found
      CHARACTER*8 :: XERN1
      CHARACTER*16 :: XERN3, XERN4

      COMMON /DDEBD1/ TOLD, ROWNS(210), EL0, H, HMIN, HMXI, HU, X, U,   &
                      IQUIT, INIT, LYH, LEWT, LACOR, LSAVF, LWM, KSTEPS, &
                      IBEGIN, ITOL, IINTEG, ITSTOP, IJAC, IBAND, IOWNS(6), &
                      IER, JSTART, KFLAG, LDUM, METH, MITER, MAXORD, N, NQ, &
                      NST, NFE, NJE, NQU, ISPARSE, IUSERCALL, JAC_OUTDATED

      !..................................................................

      double precision :: x_old, h_effective, TN
      integer :: job

      ! communication with slatec/drkfs.f, slatec/dfehl.f, slatec/dhstrt.f
      !                    slatec/ddes.f, slatec/dsteps.f
      !                    slatec/dlsod.f, slatec/dstod.f
      !                    [fml_funfun]/msOdeSolve_JacDF
      !                    [fml_funfun]/msOdeSolve_JacUser
      !                    [fml_funfun]/msOdeSolve_JacUserSP
      integer :: nb_step, nb_deriv
      double precision :: dt_min, dt_max
      common /slatec_odesolve_1/ dt_min, dt_max, nb_step, nb_deriv
      integer :: nb_jac, nb_solv
      common /slatec_odesolve_2/ nb_jac, nb_solv

      integer :: times_current_length, orders_current_length
      double precision, allocatable :: vector_tmp(:)

      logical :: print_progress, disp_times
      character(len=80) :: string
      real(kind=MF_DOUBLE) :: t_0, t_end, pc_fact, percent
      real(kind=MF_DOUBLE) :: total_time, left_time, rem_time
      integer :: clock_rate, clock_init, clock, kk
      integer :: hrs_1, min_1, sec_1, hrs_2, min_2, sec_2
      common /slatec_odesolve_progress/ print_progress, disp_times,     &
             t_0, t_end, pc_fact, clock_rate, clock_init

      integer :: iflag, istat
      integer, save :: COUNT_ILL_COND
      integer, parameter :: COUNT_ILL_COND_MAX = 10 ! original value is 10

      ! Warning, the declaration: YH_OLD(NEQ,6) implies that MAXORD = 5
      ! (same shape as YH)
      double precision :: YH_OLD(NEQ,6), factorial
      integer :: i, NQ_OLD

      logical :: end_condition_found

      integer*8 :: total_size, n1
      character(len=20) :: n1sq_str
      character(len=11) :: nnz_str

      integer :: i_eqn_group, i_group_eqn

      !..................................................................

      end_condition_found = .false.

      IF( IBEGIN == 0 ) THEN
         ! On the first call, perform initialization --
         COUNT_ILL_COND = 0

         ! Define the machine unit roundoff quantity  U  by calling the
         ! function routine D1MACH. The user must make sure that the
         ! values set in D1MACH are relevant to the computer being used.
         U = D1MACH(4)
         ! Set associated machine dependent parameter
         WM(1) = SQRT(U)
         ! Set termination flag
         IQUIT = 0
         ! Set initialization indicator
         INIT = 0
         ! Set counter for attempted steps
         KSTEPS = 0
         ! Set indicator for intermediate-output
         INTOUT = .FALSE.
         ! Set start indicator for DSTOD code
         JSTART = 0
         ! Set BDF method indicator
         METH = 2
         ! Set maximum order for BDF method
         MAXORD = 5
         ! Set iteration matrix indicator
         IF( IJAC == 0 .AND. IBAND == 0 ) MITER = 2
         IF( IJAC == 1 .AND. IBAND == 0 ) MITER = 1
         IF( IJAC == 0 .AND. IBAND == 1 ) MITER = 5
         IF( IJAC == 1 .AND. IBAND == 1 ) MITER = 4
         IF( ISPARSE == 1 ) THEN
            MITER = 6
            ! -- Make also some initialization for the sparse case
            !    (the arrays are declared in mod_ddebd2 module)
            IF( .NOT. ALLOCATED(JPD) ) THEN
               ALLOCATE( JPD(NEQ+1), JPD_C(NEQ+1) )
               ! The first call only initializes NNZ (job=0)
               job = 0
               CALL SPDJAC(T,Y,NEQ,job,WM,IWM,JPD(1),NNZ)
               n1 = neq
               total_size = n1*n1
               if( nnz < 0 .or. total_size < nnz ) then
                  write(n1sq_str,'(I0)') total_size
                  write(nnz_str,'(I0)') nnz
                  CALL XERMSG ('SLATEC', 'DDASSL',                         &
                    'INVALID IMPLEMENTATION OF THE USER-DEFINED SPARSE' // &
                    ' JACOBIAN:$$FIRST CALL MUST RETURN A VALID VALUE ' // &
                    'FOR NNZ! Got: NNZ = ' // trim(adjustl(nnz_str))    // &
                    ' WHICH IS OUT OF RANGE: [0,'                       // &
                    trim(adjustl(n1sq_str)) // ']',                        &
                    18, 1)
                  IDID = -34
                  return
               end if
               ALLOCATE( PD(NNZ), IPD(NNZ), IPD_C(NNZ) )
               ! The second call checks that all diagonal terms are present.
               ! (standard call: job=1)
               job = 1

               call mf_restore_fpe( )
               CALL SPDJAC(T,Y,NEQ,job,PD(1),IPD(1),JPD(1),NNZ)
               call mf_save_and_disable_fpe( )

               NDIAG = 0
               DO J = 1, NEQ
                  diag_found = .false.
                  DO K = JPD(J), JPD(J+1)-1
                     IF( IPD(K) == J ) THEN
                        diag_found = .true.
                        NDIAG = NDIAG + 1
                     ENDIF
                  ENDDO
                  if( .not. diag_found ) then
                     print "(2X,A)", "(MUESLI:) dlsod: check of the sparse jacobian"
                     print "(2X,A,I0,A)", "          Equation number ", J, " doesn't have a diagonal term!"
                  end if
               ENDDO
               IF( NDIAG /= NEQ ) THEN
                  CALL XERMSG ('SLATEC', 'DLSOD',                          &
                     'INVALID IMPLEMENTATION OF THE USER-DEFINED SPARSE' //&
                     ' JACOBIAN:$$ALL DIAGONAL ENTRIES MUST BE PRESENT,' //&
                     ' EVEN ZEROES!',                                      &
                     18, 1)
                  IDID = -34
               ENDIF
            ENDIF
         ENDIF

         ! -- Set other necessary items in common block
         N = NEQ
         NST = 0
         NJE = 0
         HMXI = 0.0D0
         NQ = 1
         H = 1.0D0
         JAC_OUTDATED = 0 ! set to 1 only by msOdeSolve_SaveRest_nojac
         ! -- Reset IBEGIN for subsequent calls
         IBEGIN = 1
      ENDIF

      if( IUSERCALL == 0 ) then
         ! This is not for computation, only to log some quantities...
         nb_step = 0
         dt_min =  8.8888D+88
         dt_max = -8.8888D+88
         nb_deriv = 0
         nb_jac = 0
         nb_solv = 0
         if( save_times ) then
           allocate( times_solve(500) )
           n_times = 1
           times_solve(1) = T
         end if
         if( save_orders ) then
           allocate( orders_solve(500) )
           n_orders = 1
           orders_solve(1) = MF_NAN
         end if
         ! -- Reset IUSERCALL for subsequent user-calls
         IUSERCALL = 1
      end if

      ! Check validity of input parameters on each entry
      IF( NEQ < 1 ) THEN
         WRITE (XERN1, '(I0)') NEQ
         CALL XERMSG ('SLATEC', 'DLSOD',                                &
            'IN DDEBDF, THE NUMBER OF EQUATIONS MUST BE A ' //          &
            'POSITIVE INTEGER.$$YOU HAVE CALLED THE CODE WITH NEQ = ' //&
            XERN1, 6, 1)
         IDID = -33
      ENDIF

      NRTOLP = 0
      NATOLP = 0
      DO K = 1, NEQ
         IF( NRTOLP <= 0 ) THEN
            IF( RTOL(K) < 0. ) THEN
               WRITE (XERN1, '(I0)') K
               WRITE (XERN3, '(ES13.6)') RTOL(K)
               CALL XERMSG ('SLATEC', 'DLSOD',                          &
                  'IN DDEBDF, THE RELATIVE ERROR TOLERANCES MUST ' //   &
                  'BE NON-NEGATIVE.$$YOU HAVE CALLED THE CODE WITH ' // &
                  'RTOL(' // XERN1 // ') = ' // XERN3 // '$$IN THE ' // &
                  'CASE OF VECTOR ERROR TOLERANCES, NO FURTHER ' //     &
                  'CHECKING OF RTOL COMPONENTS IS DONE.', 7, 1)
               IDID = -33
               IF( NATOLP > 0 ) GO TO 70
               NRTOLP = 1
            ELSEIF( NATOLP > 0 ) THEN
               GO TO 50
            ENDIF
         ENDIF

         IF( ATOL(K) < 0. ) THEN
            WRITE (XERN1, '(I0)') K
            WRITE (XERN3, '(ES13.6)') ATOL(K)
            CALL XERMSG ('SLATEC', 'DLSOD',                             &
               'IN DDEBDF, THE ABSOLUTE ERROR ' //                      &
               'TOLERANCES MUST BE NON-NEGATIVE.$$YOU HAVE CALLED ' //  &
               'THE CODE WITH ATOL(' // XERN1 // ') = ' // XERN3 //     &
               '$$IN THE CASE OF VECTOR ERROR TOLERANCES, NO FURTHER '  &
               // 'CHECKING OF ATOL COMPONENTS IS DONE.', 8, 1)
            IDID = -33
            IF( NRTOLP > 0 ) GO TO 70
            NATOLP = 1
         ENDIF
   50    IF( ITOL == 0 ) GO TO 70
      END DO

   70 IF( ITSTOP == 1 ) THEN
         IF( SIGN(1.0D0,TOUT-T) /= SIGN(1.0D0,TSTOP-T) .OR.             &
             ABS(TOUT-T) > ABS(TSTOP-T) ) THEN
            WRITE (XERN3, '(ES13.6)') TOUT
            WRITE (XERN4, '(ES13.6)') TSTOP
            CALL XERMSG ('SLATEC', 'DLSOD',                             &
               'IN DDEBDF, YOU HAVE CALLED THE ' //                     &
               'CODE WITH TOUT = ' // XERN3 // '$$BUT YOU HAVE ' //     &
               'ALSO TOLD THE CODE NOT TO INTEGRATE PAST THE POINT ' // &
               'TSTOP = ' // XERN4 // ' BY SETTING INFO(4) = 1.$$' //   &
               'THESE INSTRUCTIONS CONFLICT.', 14, 1)
            IDID = -33
         ENDIF
      ENDIF

      ! Check some continuation possibilities
      IF( INIT /= 0 ) THEN
         IF( T == TOUT ) THEN
            WRITE (XERN3, '(ES13.6)') T
            CALL XERMSG ('SLATEC', 'DLSOD',                             &
               'IN DDEBDF, YOU HAVE CALLED THE CODE WITH T = TOUT = ' //&
               XERN3 // '$$THIS IS NOT ALLOWED ON CONTINUATION CALLS.', &
               9, 1)
            IDID = -33
         ENDIF

         IF(T /= TOLD ) THEN
            WRITE (XERN3, '(ES13.6)') TOLD
            WRITE (XERN4, '(ES13.6)') T
            CALL XERMSG ('SLATEC', 'DLSOD',                             &
               'IN DDEBDF, YOU HAVE CHANGED THE VALUE OF T FROM ' //    &
               XERN3 // ' TO ' // XERN4 //                              &
               '  THIS IS NOT ALLOWED ON CONTINUATION CALLS.', 10, 1)
            IDID = -33
         ENDIF

         IF( INIT /= 1 ) THEN
            IF( DELSGN*(TOUT-T) < 0.0D0 ) THEN
               WRITE (XERN3, '(ES13.6)') TOUT
               CALL XERMSG ('SLATEC', 'DLSOD',                          &
                  'IN DDEBDF, BY CALLING THE CODE WITH TOUT = ' //      &
                  XERN3 // ' YOU ARE ATTEMPTING TO CHANGE THE ' //      &
                  'DIRECTION OF INTEGRATION.$$THIS IS NOT ALLOWED ' //  &
                  'WITHOUT RESTARTING.', 11, 1)
               IDID = -33
            ENDIF
         ENDIF
      ENDIF

      IF( IDID == -33 ) THEN
         IF( IQUIT /= -33 ) THEN
            ! -- Invalid input detected
            IQUIT = -33
            IBEGIN = -1
         ELSE
            CALL XERMSG ('SLATEC', 'DLSOD',                             &
               'IN DDEBDF, INVALID INPUT WAS DETECTED ON ' //           &
               'SUCCESSIVE ENTRIES.  IT IS IMPOSSIBLE TO PROCEED ' //   &
               'BECAUSE YOU HAVE NOT CORRECTED THE PROBLEM, ' //        &
               'SO EXECUTION IS BEING TERMINATED.', 12, 2)
         ENDIF
         RETURN
      ENDIF

      ! RTOL = ATOL = 0 is allowed as valid input and interpreted
      ! as asking for the most accurate solution possible. In this
      ! case, the relative error tolerance RTOL is reset to the
      ! smallest value 100*U which is likely to be reasonable for
      ! this method and machine.
      DO K = 1, NEQ
         if( RTOL(K) + ATOL(K) <= 0.0D0 ) then
            RTOL(K) = 100.0D0*U
            IDID = -2
         end if
         IF( ITOL == 0 ) exit
      END DO

      IF( IDID == -2 ) then
         ! RTOL = ATOL = 0 on input, so RTOL is changed to a
         !                           small positive value
         IBEGIN = -1
         return
      end if

      ! Branch on status of initialization indicator
      !        INIT=0 means initial derivatives, nominal step size
      !               and direction not yet set
      !        INIT=1 means nominal step size and direction not yet set
      !        INIT=2 means no further initialization required
      IF( INIT == 0 ) GO TO 210
      IF( INIT == 1 ) GO TO 230
      GO TO 260

      ! More initialization -- Evaluate initial derivatives
  210 CONTINUE
      INIT = 1
      nb_deriv = nb_deriv + 1
      iflag = 0

      call mf_restore_fpe( )
      ! Store first derivative at all points in the second column of YH
      CALL DF( T, Y, YH(1,2), iflag )
      call mf_save_and_disable_fpe( )
      ! check NaN values
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do k = 1, neq
            if( isnan(YH(k,2)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [dlsod] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(k) for k = ", k
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( k, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               IDID = -14
               return
            end if
         end do
      end if
      if( iflag /= 0 ) then
         IDID = -100
         return
      end if

      NFE = 1
      if( T == TOUT ) then
         IDID = 2
         YPOUT(1:NEQ) = YH(1:NEQ,2)
         TOLD = T
         return
      end if

      ! -- Compute initial step size (DHSTRT)
      ! -- Save sign of integration direction
      ! -- Set independent and dependent variables X and YH(*) for DSTOD
  230 CONTINUE
      LTOL = 1
      DO L = 1, NEQ
         IF( ITOL == 1 ) LTOL = L
         TOL = RTOL(LTOL)*ABS(Y(L)) + ATOL(LTOL)
         IF( TOL == 0.0D0 ) GO TO 390
         EWT(L) = TOL
      END DO

      BIG = SQRT(D1MACH(2))
      CALL DHSTRT( DF, NEQ, T, TOUT, Y, YH(1,2), EWT, 1, U, BIG,        &
                   YH(1,3), YH(1,4), YH(1,5), YH(1,6), H, istat )

      if( istat /= 0 ) then
         print *, "(MUESLI:) internal error."
         print *, "          (SLATEC/dlsod: line 440:",                 &
                  " istat /= 0 after calling DHSTRT)"
         print *, "          For your information, istat = ",           &
                  istat, " after calling DHSTRT."
         print *, "          Please report this bug to:",               &
                  " Edouard.Canot@univ-rennes.fr"
         print *
         call msPause( "pause for debugging purposes" )
         stop "*** job aborted ***"
      end if

      DELSGN = SIGN(1.0D0,TOUT-T)
      X = T
      YH(1:NEQ,1) = Y(1:NEQ)
      YH(1:NEQ,2) = H*YH(1:NEQ,2)
      INIT = 2

  260 CONTINUE

      ! On each call set information which determines the allowed interval
      ! of integration before returning with an answer at TOUT
      DEL = TOUT - T
      ABSDEL = ABS(DEL)

  270 CONTINUE

      ! If already past output point, interpolate and return
      if( ABS(X-T) >= ABSDEL ) then
         CALL DINTYD( TOUT, 0, YH, NEQ, Y, INTFLG )
         CALL DINTYD( TOUT, 1, YH, NEQ, YPOUT, INTFLG )
         IDID = 3
         if( X == TOUT ) then
            IDID = 2
!### Why set INTOUT?
            INTOUT = .FALSE.
         end if
         T = TOUT
         TOLD = T
         return
      end if

      ! If cannot go past TSTOP and sufficiently
      ! close, extrapolate and return
      IF( ITSTOP /= 1 ) GO TO 310
      IF( ABS(TSTOP-X) >= 100.0D0*U*ABS(X) ) GO TO 310

      ! Compute Y at TOUT
      DT = TOUT - X
      Y(1:NEQ) = YH(1:NEQ,1) + (DT/H)*YH(1:NEQ,2)
      nb_deriv = nb_deriv + 1
      iflag = 0

      ! Compute YP at TOUT
      call mf_restore_fpe( )
      CALL DF( TOUT, Y, YPOUT, iflag )
      call mf_save_and_disable_fpe( )
      ! check NaN values
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do k = 1, neq
            if( isnan(YPOUT(k)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [dlsod] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                              "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(k) for k = ", k
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( k, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               IDID = -14
               return
            end if
         end do
      end if
      if( iflag < 0 ) then
         IDID = -100
         return
      end if
      if( iflag == 3 ) then
         print *, "(MUESLI:) internal error."
         print *, "          (SLATEC/dlsod: line 528:",                 &
                  " iflag /= 0 after calling DF)"
         print *, "          For your information, iflag = ",           &
                  iflag, " after calling DF."
         print *, "          Please report this bug to:",               &
                  " Edouard.Canot@univ-rennes.fr"
         print *
         call msPause( "pause for debugging purposes" )
         stop "*** job aborted ***"
      end if

      NFE = NFE + 1
      IDID = 3
      T = TOUT
      TOLD = T
      return

  310 CONTINUE

      if( IINTEG /= 0 .AND. INTOUT ) then
         ! Intermediate-output mode
         IDID = 1
         GO TO 370
      end if

      ! Limit step size and set weight vector
      HMIN = 100.0D0*U*ABS(X)
      HA = MAX(ABS(H),HMIN)
      IF( ITSTOP == 1 ) HA = MIN(HA,ABS(TSTOP-X))
      H = SIGN(HA,H)
      LTOL = 1
      DO L = 1, NEQ
         IF( ITOL == 1 ) LTOL = L
         EWT(L) = RTOL(LTOL)*ABS(YH(L,1)) + ATOL(LTOL)
         IF( EWT(L) <= 0.0D0 ) GO TO 380
      END DO
      TOLFAC = U*DVNRMS(NEQ,YH,EWT)
      IF( TOLFAC <= 1.0D0 ) GO TO 400

      ! Tolerances too small
      IDID = -2
      TOLFAC = 2.0D0*TOLFAC
      RTOL(1) = TOLFAC*RTOL(1)
      ATOL(1) = TOLFAC*ATOL(1)
      if( ITOL /= 0 ) then
         RTOL(2:NEQ) = TOLFAC*RTOL(2:NEQ)
         ATOL(2:NEQ) = TOLFAC*ATOL(2:NEQ)
      end if
      IBEGIN = -1

  370 CONTINUE
      GO TO 430
  380 CONTINUE

      ! Relative error criterion inappropriate
  390 CONTINUE
      IDID = -3
      IBEGIN = -1
      GO TO 430

  400 CONTINUE

      ! Take a step
      x_old = X

      ! Curiously enough, no way to restore the old value of Y(:)
      ! Be aware to save YH, not Y (this latter variable is a working array)
      factorial = 1.0d0
      do i = 1, NQ+1
         YH_OLD(1:NEQ,i) = ( factorial/H**(i-1) )*YH(1:NEQ,i)
         factorial = factorial*i
      end do
      NQ_OLD = NQ

  410 continue

      CALL DSTOD( NEQ, Y, YH, NEQ, YH1, EWT, SAVF, ACOR,                &
                  WM, IWM, DF, DJAC, SPDJAC,                            &
                  CHECK_JAC, PRINT_CHECK_JAC )

      TN = X

      ! storing y(:) and yp(:) in files (monitoring)
      if( unit_monitor_y /= -1 ) then
         write( unit_monitor_y, format_monitor_y )                      &
                X, YH(monitoryind,1)
         call flush( unit_monitor_y )
      end if
      if( unit_monitor_yp /= -1 ) then
         write( unit_monitor_yp, format_monitor_yp )                    &
                X, YH(monitorypind,2)/H
         call flush( unit_monitor_yp )
      end if
      if( monitor_pause ) then
         print *
         call msPause( "[MUESLI] ODE solver: monitoring pause" )
      end if

      if( save_times ) then
         times_current_length = size(times_solve)
         n_times = n_times + 1
         if( n_times > times_current_length ) then
            allocate( vector_tmp(times_current_length) )
            vector_tmp(:) = times_solve(:)
            deallocate( times_solve )
            allocate( times_solve(2*times_current_length) )
            times_solve(1:times_current_length) = vector_tmp(:)
            deallocate( vector_tmp )
         end if
         times_solve(n_times) = TN
         ! saving the current time (for debugging purpose)
         current_time = TN
      end if

      if( save_orders ) then
         orders_current_length = size(orders_solve)
         n_orders = n_orders + 1
         if( n_orders > orders_current_length ) then
            allocate( vector_tmp(orders_current_length) )
            vector_tmp(:) = orders_solve(:)
            deallocate( orders_solve )
            allocate( orders_solve(2*orders_current_length) )
            orders_solve(1:orders_current_length) = vector_tmp(:)
            deallocate( vector_tmp )
         end if
         orders_solve(n_orders) = NQ
      end if

      nb_step = nb_step + 1

      if( print_progress ) then
         percent = (TN-t_0)*pc_fact
         if( percent > 100.0d0 ) percent = 100.0d0
         if( disp_times ) then
            call system_clock( count=clock )
            left_time = dble(clock-clock_init)/clock_rate
            ! Global Linear Estimator
            total_time = left_time/(TN-t_0)*(t_end-t_0)
            call sec_2_hms( left_time, hrs_1, min_1, sec_1 )
            rem_time = nint(max(0.0d0, total_time-left_time))
            call sec_2_hms( rem_time, hrs_2, min_2, sec_2 )
            write(string,'(F5.1,A,I3,A,2(I2,A),A,I3,A,2(I2,A))')        &
                  percent, ' % (time left = ',                          &
                  hrs_1, 'h ', min_1, 'm ', sec_1, 's ',                &
                  '-- estim. remain. time = ',                          &
                  hrs_2, 'h ', min_2, 'm ', sec_2, 's)'
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_back_on_term_no_adv( trim(string) // char(0) )
#else
            call go_home_on_term()
            write(STDOUT,'(A)',advance='no') trim(string)
            call msFlush(STDOUT)
#endif
         else
            write(string,'(F5.1,A)') percent, ' %'
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_back_on_term_no_adv( trim(string) // char(0) )
#else
            call go_home_on_term()
            write(STDOUT,'(A)',advance='no') trim(string)
            call msFlush(STDOUT)
#endif
         end if
      end if

      if( X > TOUT ) then
         h_effective = TOUT - x_old
      else
         h_effective = h
      end if
      if( h_effective < dt_min ) dt_min = h_effective
      if( h_effective > dt_max ) dt_max = h_effective

      JSTART = -2
      INTOUT = .TRUE.
      if( KFLAG == 0 ) then
         GO TO 270
      else if( KFLAG == -1 ) then
         ! Repeated error test failures
         IDID = -7
         IBEGIN = -1
      else if( KFLAG == -2 ) then
         ! Repeated corrector convergence failures
         IDID = -6
         IBEGIN = -1
      else if( KFLAG == -20 ) then
         T = x_old
         Y(1:NEQ) = YH_OLD(1:NEQ,1)
         YPOUT(1:NEQ) = YH_OLD(1:NEQ,2)
         IDID = -11
         return
      else if( KFLAG == -21 ) then
         COUNT_ILL_COND = COUNT_ILL_COND + 1
         if( COUNT_ILL_COND > COUNT_ILL_COND_MAX ) then
            T = x_old
            Y(1:NEQ) = YH_OLD(1:NEQ,1)
            YPOUT(1:NEQ) = YH_OLD(1:NEQ,2)
            IDID = -10
            return
         else
            JSTART = -2
            if( NQ > NQ_OLD ) then
               print *, "(MUESLI:) internal error."
               print *, "          (SLATEC/dlsod: line 734:",           &
                        " NQ has increased, some derivatives cannot be restored)"
               print *, "          Please report this bug to:",         &
                        " Edouard.Canot@univ-rennes.fr"
               print *
               call msPause( "pause for debugging purposes" )
               stop "*** job aborted ***"
            end if
            ! Recompute new values for YH
            X = x_old
            factorial = 1.0d0
            do i = 1, NQ+1
               YH(1:NEQ,i) = ( H**(i-1)/factorial )*YH_OLD(1:NEQ,i)
               factorial = factorial*i
            end do
            ! The new value of H must be set after the restore,
            ! because a rescaling will be done at lines 267-272 of dstod
            H = 0.25d0*H
            GO TO 410
         end if
      else if( KFLAG == -22 .and.                                       &
              .not. end_condition_found ) then
         end_condition_found = .true.
         ! This the new value of Tout (which can only be decrease
         TOUT = min( TOUT, X )
         if( NQ > NQ_OLD ) then
            print *, "(MUESLI:) internal error."
            print *, "          (SLATEC/dlsod: line 761:",              &
                     " NQ has increased, some derivatives cannot be restored)"
            print *, "          Please report this bug to:",            &
                     " Edouard.Canot@univ-rennes.fr"
            print *
            call msPause( "pause for debugging purposes" )
            stop "*** job aborted ***"
         end if
         X = x_old
         factorial = 1.0d0
         do i = 1, NQ+1
            YH(1:NEQ,i) = ( H**(i-1)/factorial )*YH_OLD(1:NEQ,i)
            factorial = factorial*i
         end do
         ! The new value of H must be set after the restore,
         ! because a rescaling will be done at lines 267-272 of dstod
         H = TOUT - X
         GO TO 410
      end if
  430 CONTINUE

      ! Store values before returning to DDEBDF
      Y(1:NEQ) = YH(1:NEQ,1)
      YPOUT(1:NEQ) = YH(1:NEQ,2)/H
      T = X
      TOLD = T
      INTOUT = .FALSE.
      if( end_condition_found ) idid = 12

      ! Deallocation must be made in the calling program, after any
      ! call to DDEBDF. Cf. routine 'ddebd2_free' in 'mod_ddebd2.F90'

   END
