!DECK DINTYD
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 15 jan 2022
!
   SUBROUTINE DINTYD( T, K, YH, NYH, DKY, IFLAG )

      implicit none

      double precision, intent(in)  :: T, YH(NYH,*)
      integer,          intent(in)  :: K, NYH
      double precision, intent(out) :: DKY(*)
      integer,          intent(out) :: IFLAG

!***BEGIN PROLOGUE  DINTYD
!***SUBSIDIARY
!***PURPOSE  Subsidiary to DDEBDF
!***LIBRARY   SLATEC
!***TYPE      DOUBLE PRECISION (INTYD-S, DINTYD-D)
!***AUTHOR  Watts, H. A., (SNLA)
!***DESCRIPTION
!
!   DINTYD approximates the solution and derivatives at T by polynomial
!   interpolation. Must be used in conjunction with the integrator
!   package DDEBDF.
! ----------------------------------------------------------------------
! DINTYD computes interpolated values of the K-th derivative of the
! dependent variable vector Y, and stores it in DKY.
! This routine is called by DDEBDF with K = 0,1 and T = TOUT, but may
! also be called by the user for any K up to the current order.
! (see detailed instructions in LSODE usage documentation.)
! ----------------------------------------------------------------------
! The computed values in DKY are gotten by interpolation using the
! Nordsieck history array YH.  This array corresponds uniquely to a
! vector-valued polynomial of degree NQCUR or less, and DKY is set
! to the K-th derivative of this polynomial at T.
! The formula for DKY is
!              Q
!  DKY(I)  =  Sum  C(J,K) * (T - TN)**(J-K) * H**(-J) * YH(I,J+1)
!             J=K
! where  C(J,K) = J*(J-1)*...*(J-K+1), Q = NQCUR, TN = TCUR, H = HCUR.
! The quantities  NQ = NQCUR, L = NQ+1, N = NEQ, TN, and H are
! communicated by common.  The above sum is done in reverse order.
! IFLAG is returned negative if either K or T is out of bounds.
! ----------------------------------------------------------------------
!
!***SEE ALSO  DDEBDF
!***ROUTINES CALLED  (NONE)
!***COMMON BLOCKS    DDEBD1
!***REVISION HISTORY  (YYMMDD)
!   820301  DATE WRITTEN
!   890911  Removed unnecessary intrinsics.  (WRB)
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900328  Added TYPE section.  (WRB)
!   910722  Updated AUTHOR section.  (ALS)
!***END PROLOGUE  DINTYD

      INTEGER :: I, IC, IER, IOWND, IOWNS, ISPARSE, J, JB, JB2, JJ, JJ1, &
                 JP1, JSTART, KFLAG, L, MAXORD, METH, MITER, N, NFE,    &
                 NJE, NQ, NQU, NST, IUSERCALL, JAC_OUTDATED
      DOUBLE PRECISION :: C, EL0, H, HMIN, HMXI, HU, R, ROWND, ROWNS,   &
                          S, TN, TP, UROUND

      COMMON /DDEBD1/ ROWND, ROWNS(210), EL0, H, HMIN, HMXI, HU, TN, UROUND, &
                      IOWND(14), IOWNS(6), IER, JSTART, KFLAG, L, METH, &
                      MITER, MAXORD, N, NQ, NST, NFE, NJE, NQU, ISPARSE, &
                      IUSERCALL, JAC_OUTDATED

      IFLAG = 0
      if( K < 0 .OR. NQ < K ) then
         ! K out-of-range
         IFLAG = -1
         return
      end if
      TP = TN - HU*(1.0d0 + 1.0d2*UROUND)
      if( (T - TP)*(T - TN) > 0.0d0 ) then
         ! T out-of-range
         IFLAG = -2
         return
      end if

      S = (T - TN)/H
      IC = 1
      if( K /= 0 ) then
         JJ1 = L - K
         do JJ = JJ1, NQ
            IC = IC*JJ
         end do
      end if
      C = IC
      do I = 1, N
         DKY(I) = C*YH(I,L)
      end do
      if( K /= NQ ) then
         JB2 = NQ - K
         do JB = 1, JB2
            J = NQ - JB
            JP1 = J + 1
            IC = 1
            if( K /= 0 ) then
               JJ1 = JP1 - K
               do JJ = JJ1, J
                  IC = IC*JJ
               end do
            end if
            C = IC
            do I = 1, N
               DKY(I) = C*YH(I,JP1) + S*DKY(I)
            end do
         end do
         if( K == 0 ) return
      end if
      R = H**(-K)
      do I = 1, N
         DKY(I) = R*DKY(I)
      end do

   END
