!DECK DDES
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 17 oct 2017
!
   SUBROUTINE DDES( DF, NEQ, T, Y, TOUT, INFO, RTOL, ATOL, IDID,        &
         YPOUT, YP, YY, WT, P, PHI, ALPHA, BETA, PSI, V, W, SIG, G, GI, &
         H, EPS, X, XOLD, HOLD, TOLD, DELSGN, TSTOP, TWOU, FOURU, START,&
         PHASE1, NORND, STIFF, INTOUT, NS, KORD, KOLD, INIT, KSTEPS,    &
         KLE4, IQUIT, KPREV, IVC, IV, KGI )
!***BEGIN PROLOGUE  DDES
!***SUBSIDIARY
!***PURPOSE  Subsidiary to DDEABM
!***LIBRARY   SLATEC
!***TYPE      DOUBLE PRECISION (DES-S, DDES-D)
!***AUTHOR  Watts, H. A., (SNLA)
!***DESCRIPTION
!
!   DDEABM merely allocates storage for DDES to relieve the user of the
!   inconvenience of a long call list. Consequently DDES is used as
!   described in the comments for DDEABM.
!
!***SEE ALSO  DDEABM
!***ROUTINES CALLED  D1MACH, DINTP, DSTEPS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   820301  DATE WRITTEN
!   910722  Last modification. For details see original file.
!***END PROLOGUE  DDES
!
      use mod_mfaux, only: mf_save_and_disable_fpe, mf_restore_fpe
      use mod_mfdebug, only: MF_NUMERICAL_CHECK
      use mod_core, only: STDOUT, sec_2_hms, msFlush, go_home_on_term,  &
                          msPause


      IMPLICIT NONE

      INTEGER IDID, INFO, INIT, IQUIT, IV, IVC, K, KGI, KLE4,           &
            KOLD, KORD, KPREV, KSTEPS, L, LTOL, MAXNUM, NATOLP, NEQ,    &
            NRTOLP, NS
      DOUBLE PRECISION A, ABSDEL, ALPHA, ATOL, BETA,                    &
            DEL, DELSGN, DT, EPS, FOURU, G, GI, H,                      &
            HA, HOLD, P, PHI, PSI, RTOL, SIG, T, TOLD, TOUT,            &
            TSTOP, TWOU, U, V, W, WT, X, XOLD, Y, YP, YPOUT, YY
      LOGICAL STIFF, CRASH, START, PHASE1, NORND, INTOUT

      DIMENSION Y(*), YY(*), WT(*), PHI(NEQ,16), P(*), YP(*),           &
                YPOUT(*), PSI(12), ALPHA(12), BETA(12), SIG(13), V(12), &
                W(12), G(13), GI(11), IV(10), INFO(15), RTOL(*), ATOL(*)
      CHARACTER*8 XERN1
      CHARACTER*16 XERN3, XERN4

      EXTERNAL DF

      !.................................................................
      !
      ! The expense of solving the problem is monitored by counting the
      ! number of  steps attempted. When this exceeds  maxnum, the counter
      ! is reset to zero and the user is informed about possible excessive
      ! work.

      SAVE MAXNUM
      DATA MAXNUM /500/

      ! communication with slatec/drkfs.f, slatec/dfehl.f, slatec/dhstrt.f
      !                    slatec/ddes.f, slatec/dsteps.f
      !                    slatec/dlsod.f, slatec/dstod.f
      !                    [fml_funfun]/msOdeSolve_JacDF
      integer :: nb_step, nb_deriv
      double precision :: dt_min, dt_max, TN
      common /slatec_odesolve_1/ dt_min, dt_max, nb_step, nb_deriv

      integer :: times_current_length
      double precision, allocatable :: vector_tmp(:)

      logical :: print_progress, disp_times
      character(len=80) :: string
      real(kind=MF_DOUBLE) :: t_0, t_end, pc_fact, percent
      real(kind=MF_DOUBLE) :: total_time, left_time, rem_time
      integer :: clock_rate, clock_init, clock, kk
      integer :: hrs_1, min_1, sec_1, hrs_2, min_2, sec_2
      common /slatec_odesolve_progress/ print_progress, disp_times,     &
             t_0, t_end, pc_fact, clock_rate, clock_init

      integer :: iflag

      integer :: i_eqn_group, i_group_eqn

      !.................................................................
      !
      !***FIRST EXECUTABLE STATEMENT  DDES
      IF( INFO(1) == 0 ) THEN
         nb_step = 0
         dt_min =  8.8888D+88
         dt_max = -8.8888D+88
         nb_deriv = 0

         if( save_times ) then
           allocate( times_solve(500) )
           n_times = 1
           times_solve(1) = T
         end if

         ! On the first call, perform initialization --
         !   Define the machine unit roundoff quantity  U  by calling the
         !   function routine  D1MACH. The user must make sure that the
         !   values set in  D1MACH  are relevant to the computer being used.
         U = D1MACH(4)
         ! Set associated machine dependent parameters
         TWOU = 2.D0*U
         FOURU = 4.D0*U
         ! Set termination flag
         IQUIT = 0
         ! Set initialization indicator
         INIT = 0
         ! Set counter for attempted steps
         KSTEPS = 0
         ! Set indicator for intermediate-output
         INTOUT = .FALSE.
         ! Set indicator for stiffness detection
         STIFF = .FALSE.
         ! Set step counter for stiffness detection
         KLE4 = 0
         ! Set indicators for steps code
         START = .TRUE.
         PHASE1 = .TRUE.
         NORND = .TRUE.
         ! Reset INFO(1) for subsequent calls
         INFO(1) = 1
      ENDIF

      !.................................................................
      !
      ! Check validity of input parameters on each entry
      IF(INFO(1) /= 0 .AND. INFO(1) /= 1 ) THEN
         WRITE (XERN1, '(I8)') INFO(1)
         CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, INFO(1) MUST BE ' //&
            'SET TO 0 FOR THE START OF A NEW PROBLEM, AND MUST BE ' //  &
            'SET TO 1 FOLLOWING AN INTERRUPTED TASK.  YOU ARE ' //      &
            'ATTEMPTING TO CONTINUE THE INTEGRATION ILLEGALLY BY ' //   &
            'CALLING THE CODE WITH INFO(1) = ' // XERN1, 3, 1)
         IDID = -33
      ENDIF

      IF( INFO(2) /= 0 .AND. INFO(2) /= 1 ) THEN
         WRITE (XERN1, '(I8)') INFO(2)
         CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, INFO(2) MUST BE ' //&
            '0 OR 1 INDICATING SCALAR AND VECTOR ERROR TOLERANCES, ' // &
            'RESPECTIVELY.  YOU HAVE CALLED THE CODE WITH INFO(2) = ' //&
            XERN1, 4, 1)
         IDID = -33
      ENDIF

      IF( INFO(3) /= 0 .AND. INFO(3) /= 1 ) THEN
         WRITE (XERN1, '(I8)') INFO(3)
         CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, INFO(3) MUST BE ' //&
            '0 OR 1 INDICATING THE INTERVAL OR INTERMEDIATE-OUTPUT ' // &
            'MODE OF INTEGRATION, RESPECTIVELY.  YOU HAVE CALLED ' //   &
            'THE CODE WITH  INFO(3) = ' // XERN1, 5, 1)
         IDID = -33
      ENDIF

      IF( INFO(4) /= 0 .AND. INFO(4) /= 1 ) THEN
         WRITE (XERN1, '(I8)') INFO(4)
         CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, INFO(4) MUST BE ' //&
            '0 OR 1 INDICATING WHETHER OR NOT THE INTEGRATION ' //      &
            'INTERVAL IS TO BE RESTRICTED BY A POINT TSTOP.  YOU ' //   &
            'HAVE CALLED THE CODE WITH INFO(4) = ' // XERN1, 14, 1)
         IDID = -33
      ENDIF

      IF( NEQ < 1 ) THEN
         WRITE (XERN1, '(I8)') NEQ
         CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM,  THE NUMBER OF ' // &
            'EQUATIONS NEQ MUST BE A POSITIVE INTEGER.  YOU HAVE ' //   &
            'CALLED THE CODE WITH  NEQ = ' // XERN1, 6, 1)
         IDID = -33
      ENDIF

      NRTOLP = 0
      NATOLP = 0
      DO K = 1, NEQ
         IF( NRTOLP == 0 .AND. RTOL(K) < 0.D0 ) THEN
            WRITE (XERN1, '(I8)') K
            WRITE (XERN3, '(1PE15.6)') RTOL(K)
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, THE RELATIVE ' //&
               'ERROR TOLERANCES RTOL MUST BE NON-NEGATIVE.  YOU ' //   &
               'HAVE CALLED THE CODE WITH  RTOL(' // XERN1 // ') = ' // &
               XERN3 // '.  IN THE CASE OF VECTOR ERROR TOLERANCES, ' //&
               'NO FURTHER CHECKING OF RTOL COMPONENTS IS DONE.', 7, 1)
            IDID = -33
            NRTOLP = 1
         ENDIF

         IF( NATOLP == 0 .AND. ATOL(K) < 0.D0 ) THEN
            WRITE (XERN1, '(I8)') K
            WRITE (XERN3, '(1PE15.6)') ATOL(K)
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, THE ABSOLUTE ' //&
               'ERROR TOLERANCES ATOL MUST BE NON-NEGATIVE.  YOU ' //   &
               'HAVE CALLED THE CODE WITH  ATOL(' // XERN1 // ') = ' // &
               XERN3 // '.  IN THE CASE OF VECTOR ERROR TOLERANCES, ' //&
               'NO FURTHER CHECKING OF ATOL COMPONENTS IS DONE.', 8, 1)
            IDID = -33
            NATOLP = 1
         ENDIF

         IF( INFO(2) == 0 ) GO TO 100
         IF( NATOLP > 0 .AND. NRTOLP > 0 ) GO TO 100
      END DO

  100 IF( INFO(4) == 1 ) THEN
         IF( SIGN(1.D0,TOUT-T) /= SIGN(1.D0,TSTOP-T)                    &
            .OR. ABS(TOUT-T) > ABS(TSTOP-T) ) THEN
            WRITE (XERN3, '(1PE15.6)') TOUT
            WRITE (XERN4, '(1PE15.6)') TSTOP
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, YOU HAVE ' //    &
               'CALLED THE CODE WITH  TOUT = ' // XERN3 // ' BUT ' //   &
               'YOU HAVE ALSO TOLD THE CODE (INFO(4) = 1) NOT TO ' //   &
               'INTEGRATE PAST THE POINT TSTOP = ' // XERN4 //          &
               ' THESE INSTRUCTIONS CONFLICT.', 14, 1)
            IDID = -33
         ENDIF
      ENDIF

      ! Check some continuation possibilities
      IF( INIT /= 0 ) THEN
         IF( T == TOUT ) THEN
            WRITE (XERN3, '(1PE15.6)') T
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, YOU HAVE ' //    &
               'CALLED THE CODE WITH  T = TOUT = ' // XERN3 //          &
               '$$THIS IS NOT ALLOWED ON CONTINUATION CALLS.', 9, 1)
            IDID = -33
         ENDIF

         IF( T /= TOLD ) THEN
            WRITE (XERN3, '(1PE15.6)') TOLD
            WRITE (XERN4, '(1PE15.6)') T
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, YOU HAVE ' //    &
               'CHANGED THE VALUE OF T FROM ' // XERN3 // ' TO ' //     &
               XERN4 //'  THIS IS NOT ALLOWED ON CONTINUATION CALLS.',  &
               10, 1)
            IDID = -33
         ENDIF

         IF( INIT /= 1 ) THEN
            IF( DELSGN*(TOUT-T) < 0.D0 ) THEN
               WRITE (XERN3, '(1PE15.6)') TOUT
               CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, BY ' //       &
                  'CALLING THE CODE WITH TOUT = ' // XERN3 //           &
                  ' YOU ARE ATTEMPTING TO CHANGE THE DIRECTION OF ' //  &
                  'INTEGRATION.$$THIS IS NOT ALLOWED WITHOUT ' //       &
                  'RESTARTING.', 11, 1)
               IDID = -33
            ENDIF
         ENDIF
      ENDIF

      ! Invalid input detected
      IF( IDID == -33 ) THEN
         IF( IQUIT /= -33 ) THEN
            IQUIT = -33
            INFO(1) = -1
         ELSE
            CALL XERMSG ('SLATEC', 'DDES', 'IN DDEABM, INVALID ' //     &
               'INPUT WAS DETECTED ON SUCCESSIVE ENTRIES.  IT IS ' //   &
               'IMPOSSIBLE TO PROCEED BECAUSE YOU HAVE NOT ' //         &
               'CORRECTED THE PROBLEM, SO EXECUTION IS BEING ' //       &
               'TERMINATED.', 12, 2)
         ENDIF
         RETURN
      ENDIF

      !.................................................................
      !
      ! RTOL = ATOL = 0 is allowed as valid input and interpreted as
      ! asking for the most accurate solution possible. In this case,
      ! the relative error tolerance RTOL is reset to the smallest value
      ! FOURU which is likely to be reasonable for this method and machine.
      DO K = 1, NEQ
        IF( RTOL(K)+ATOL(K) > 0.D0 ) GO TO 170
        RTOL(K) = FOURU
        IDID = -2
  170   IF( INFO(2) == 0 ) GO TO 190
      END DO

  190 IF( IDID /= -2 ) GO TO 200
      ! RTOL=ATOL=0 on input, so RTOL is changed to a small positive value
      INFO(1) = -1
      RETURN

      ! Branch on status of initialization indicator
      !   INIT=0 means initial derivatives and nominal step size
      !          and direction not yet set
      !   INIT=1 means nominal step size and direction not yet set
      !   INIT=2 means no further initialization required
  200 IF( INIT == 0 ) GO TO 210
      IF( INIT == 1 ) GO TO 220
      GO TO 240

      !.................................................................
      !
      ! More initialization -- Evaluate initial derivatives
  210 INIT = 1
      A = T
      nb_deriv = nb_deriv + 1
      iflag = 0
      call mf_restore_fpe( )
      CALL DF( A, Y, YP, iflag )
      call mf_save_and_disable_fpe( )
      ! check NaN values
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do k = 1, neq
            if( isnan(YP(k)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [ddes] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(k) for k = ", k
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( k, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               IDID = -14
               return
            end if
         end do
      end if
      if( T == TOUT ) then
         IDID = 2
         DO L = 1, NEQ
            YPOUT(L) = YP(L)
         END DO
         TOLD=T
         RETURN
      end if

      ! Set independent and dependent variables X and YY(*) for steps
      ! Set sign of integration direction
      ! Initialize the step size
  220 INIT = 2
      X = T
      DO L = 1, NEQ
        YY(L) = Y(L)
      END DO
      DELSGN = SIGN(1.0D0,TOUT-T)
      H = SIGN(MAX(FOURU*ABS(X),ABS(TOUT-X)),TOUT-X)

      !.................................................................
      !
      ! On each call set information which determines the allowed interval
      ! of integration before returning with an answer at TOUT
  240 DEL = TOUT - T
      ABSDEL = ABS(DEL)

      !.......................................................................
      !
      ! If already past output point, interpolate and return
  250 if( ABS(X-T) >= ABSDEL ) then
         CALL DINTP(X,YY,TOUT,Y,YPOUT,NEQ,KOLD,PHI,IVC,IV,KGI,GI,       &
                    ALPHA,G,W,XOLD,P)
         IDID = 3
         if( X == TOUT ) then
            IDID = 2
            INTOUT = .FALSE.
         end if
         T = TOUT
         TOLD = T
         RETURN
      end if

      ! If cannot go past TSTOP and sufficiently close, extrapolate and return
      IF( INFO(4) /= 1 ) GO TO 280
      IF( ABS(TSTOP-X) >= FOURU*ABS(X) ) GO TO 280
      DT = TOUT - X
      DO L = 1, NEQ
        Y(L) = YY(L) + DT*YP(L)
      END DO
      nb_deriv = nb_deriv + 1
      iflag = 0
      call mf_restore_fpe( )
      CALL DF( TOUT, Y, YPOUT, iflag )
      call mf_save_and_disable_fpe( )
      ! check NaN values
      if( MF_NUMERICAL_CHECK .and. iflag >= 0 ) then
         do k = 1, neq
            if( isnan(YP(k)) ) then
               print "(/,A)", "(MUESLI OdeSolve:) [ddes] ERROR"
               print "(20X,A)", "A NaN value has been found after calling the", &
                                "user-supplied DERIV routine."
               print "(20X,A,I0)", "This occured in yprime(k) for k = ", k
               if( NAMED_EQN_PRESENCE ) then
                  call search_index_in_eqn_groups( k, i_eqn_group,      &
                                                      i_group_eqn )
                  print "(/,20X,A,A)", "Named equation is: ",           &
                                       trim(NAMED_EQN_PTR(i_eqn_group)%name)
                  print "(20X,A,I0)", "Equation number is: ", i_group_eqn
               end if
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               IDID = -14
               return
            end if
         end do
      end if
      IDID = 3
      T = TOUT
      TOLD = T
      RETURN

  280 IF( INFO(3) == 0 .OR. .NOT. INTOUT ) GO TO 300

      ! Intermediate-output mode
      IDID = 1
      DO L = 1, NEQ
        Y(L)=YY(L)
        YPOUT(L) = YP(L)
      END DO
      T = X
      TOLD = T
      INTOUT = .FALSE.
      RETURN

      !................................................................
      !
      ! Monitor number of steps attempted
  300 IF( KSTEPS <= MAXNUM ) GO TO 330

      ! A significant amount of work has been expended
      IDID = -1
      KSTEPS = 0
      IF( .NOT. STIFF ) GO TO 310

      ! Problem appears to be stiff
      IDID = -4
      STIFF = .FALSE.
      KLE4 = 0

  310 DO L = 1, NEQ
        Y(L) = YY(L)
        YPOUT(L) = YP(L)
      END DO
      T = X
      TOLD = T
      INFO(1) = -1
      INTOUT = .FALSE.
      RETURN

      !.................................................................
      !
      ! Limit step size, set weight vector and take a step
  330 HA = ABS(H)
      IF( INFO(4) /= 1 ) GO TO 340
      HA = MIN(HA,ABS(TSTOP-X))
  340 H = SIGN(HA,H)
      EPS = 1.0D0
      LTOL = 1
      DO L = 1, NEQ
        IF( INFO(2) == 1 ) LTOL = L
        WT(L) = RTOL(LTOL)*ABS(YY(L)) + ATOL(LTOL)
        IF( WT(L) <= 0.0D0 ) GO TO 360
      END DO
      GO TO 380

      ! Relative error criterion inappropriate
  360 IDID = -3
      DO L = 1, NEQ
        Y(L) = YY(L)
        YPOUT(L) = YP(L)
      END DO
      T = X
      TOLD = T
      INFO(1) = -1
      INTOUT = .FALSE.
      RETURN

  380 continue
      nb_step = nb_step + 1
      CALL DSTEPS(DF,NEQ,YY,X,H,EPS,WT,START,HOLD,KORD,KOLD,CRASH,PHI,P,&
                  YP,PSI,ALPHA,BETA,SIG,V,W,G,PHASE1,NS,NORND,KSTEPS,   &
                  TWOU,FOURU,XOLD,KPREV,IVC,IV,KGI,GI)

      TN = X

      ! storing y(:) and yp(:) in files (monitoring)
      if( unit_monitor_y /= -1 ) then
         write( unit_monitor_y, format_monitor_y )                      &
                X, YY(monitoryind)
         call flush( unit_monitor_y )
      end if
      if( unit_monitor_yp /= -1 ) then
         write( unit_monitor_yp, format_monitor_yp )                    &
                X, YP(monitorypind)
         call flush( unit_monitor_yp )
      end if
      if( monitor_pause ) then
         print *
         call msPause( "[MUESLI] ODE solver: monitoring pause" )
      end if

      if( save_times ) then
        times_current_length = size(times_solve)
        n_times = n_times + 1
        if( n_times > times_current_length ) then
            allocate( vector_tmp(times_current_length) )
            vector_tmp(:) = times_solve(:)
            deallocate( times_solve )
            allocate( times_solve(2*times_current_length) )
            times_solve(1:times_current_length) = vector_tmp(:)
            deallocate( vector_tmp )
        end if
        times_solve(n_times) = X
        ! saving the current time (for debugging purpose)
        current_time = X
      end if

      if( print_progress ) then
        percent = (TN-t_0)*pc_fact
        if( percent > 100.0d0 ) percent = 100.0d0
        if( disp_times ) then
          call system_clock( count=clock )
          left_time = dble(clock-clock_init)/clock_rate
          ! Global Linear Estimator
          total_time = left_time/(TN-t_0)*(t_end-t_0)
          call sec_2_hms( left_time, hrs_1, min_1, sec_1 )
          rem_time = nint(max(0.0d0, total_time-left_time))
          call sec_2_hms( rem_time, hrs_2, min_2, sec_2 )
          write(string,'(F5.1,A,I3,A,2(I2,A),A,I3,A,2(I2,A))')          &
                percent, ' % (time left = ',                            &
                hrs_1, 'h ', min_1, 'm ', sec_1, 's ',                  &
                '-- estim. remain. time = ',                            &
                hrs_2, 'h ', min_2, 'm ', sec_2, 's)'
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
          call put_string_back_on_term_no_adv( trim(string) // char(0) )
#else
          call go_home_on_term()
          write(STDOUT,'(A)',advance='no') trim(string)
          call msFlush(STDOUT)
#endif
        else
          write(string,'(F5.1,A)') percent, ' %'
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
          call put_string_back_on_term_no_adv( trim(string) // char(0) )
#else
          call go_home_on_term()
          write(STDOUT,'(A)',advance='no') trim(string)
          call msFlush(STDOUT)
#endif
        end if
      end if

      !................................................................
      !
      IF( .NOT. CRASH ) GO TO 420

      ! Tolerances too small
      IDID = -2
      RTOL(1) = EPS*RTOL(1)
      ATOL(1) = EPS*ATOL(1)
      if( INFO(2) /= 0 ) then
         DO L = 2, NEQ
            RTOL(L) = EPS*RTOL(L)
            ATOL(L) = EPS*ATOL(L)
         END DO
      end if
      DO L = 1, NEQ
        Y(L) = YY(L)
        YPOUT(L) = YP(L)
      END DO
      T = X
      TOLD = T
      INFO(1) = -1
      INTOUT = .FALSE.
      RETURN

      ! (Stiffness test) Count number of consecutive steps taken with the
      ! order of the method being less or equal to 4
  420 KLE4 = KLE4 + 1
      IF( KOLD > 4 ) KLE4 = 0
      IF( KLE4 >= 50 ) STIFF = .TRUE.
      INTOUT = .TRUE.
      GO TO 250

   END
