!DECK DDAWTS
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 22 jul 2014
!
   SUBROUTINE DDAWTS( NEQ, IWT, RTOL, ATOL, Y, WT )
!***BEGIN PROLOGUE  DDAWTS
!***SUBSIDIARY
!***PURPOSE  Set error weight vector for DDASSL.
!***LIBRARY   SLATEC (DASSL)
!***TYPE      DOUBLE PRECISION (SDAWTS-S, DDAWTS-D)
!***AUTHOR  Petzold, Linda R., (LLNL)
!***DESCRIPTION
!-----------------------------------------------------------------------
!   THIS SUBROUTINE SETS THE ERROR WEIGHT VECTOR WT ACCORDING TO
!        WT(I) = RTOL(I)*ABS(Y(I)) + ATOL(I),   I=1,...,N
!   RTOL AND ATOL ARE SCALARS IF IWT = 0, AND VECTORS IF IWT = 1.
!-----------------------------------------------------------------------
!***ROUTINES CALLED  (NONE)
!***REVISION HISTORY  (YYMMDD)
!   830315  DATE WRITTEN
!   901009  Finished conversion to SLATEC 4.0 format (F.N.Fritsch)
!   901019  Merged changes made by C. Ulrich with SLATEC 4.0 format.
!   901026  Added explicit declarations for all variables and minor
!           cosmetic changes to prologue.  (FNF)
!***END PROLOGUE  DDAWTS

      IMPLICIT NONE

      INTEGER :: NEQ, IWT
      DOUBLE PRECISION :: RTOL(*), ATOL(*), Y(*), WT(*)

      INTEGER :: I
      DOUBLE PRECISION :: ATOLI, RTOLI

      RTOLI = RTOL(1)
      ATOLI = ATOL(1)
      DO I = 1, NEQ
         IF( IWT /= 0 ) THEN
           RTOLI = RTOL(I)
           ATOLI = ATOL(I)
         END IF
         WT(I) = RTOLI*ABS(Y(I)) + ATOLI
      if( WT(I) <= 0.0d0 ) then
         print *, "(MUESLI ddawts:) found a problem computing weights:"
         print *, "        for I = ", I, ":"
         print *, "        RTOLI = ", RTOLI, ", ATOLI = ", ATOLI
         print *, "        Y(I) = ", Y(I)
         print *
         print *, "  [RETURN] to resume..."
         read *
      end if
      END DO

   END
