!DECK DDATRP
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 22 jul 2014
!
   SUBROUTINE DDATRP( X, XOUT, YOUT, YPOUT, NEQ, KOLD, PHI, PSI )
!***BEGIN PROLOGUE  DDATRP
!***SUBSIDIARY
!***PURPOSE  Interpolation routine for DDASSL.
!***LIBRARY   SLATEC (DASSL)
!***TYPE      DOUBLE PRECISION (SDATRP-S, DDATRP-D)
!***AUTHOR  Petzold, Linda R., (LLNL)
!***DESCRIPTION
!-----------------------------------------------------------------------
!     THE METHODS IN SUBROUTINE DDASTP USE POLYNOMIALS
!     TO APPROXIMATE THE SOLUTION. DDATRP APPROXIMATES THE
!     SOLUTION AND ITS DERIVATIVE AT TIME XOUT BY EVALUATING
!     ONE OF THESE POLYNOMIALS, AND ITS DERIVATIVE,THERE.
!     INFORMATION DEFINING THIS POLYNOMIAL IS PASSED FROM
!     DDASTP, SO DDATRP CANNOT BE USED ALONE.
!
!     THE PARAMETERS ARE:
!     X     THE CURRENT TIME IN THE INTEGRATION.
!     XOUT  THE TIME AT WHICH THE SOLUTION IS DESIRED
!     YOUT  THE INTERPOLATED APPROXIMATION TO Y AT XOUT
!           (THIS IS OUTPUT)
!     YPOUT THE INTERPOLATED APPROXIMATION TO YPRIME AT XOUT
!           (THIS IS OUTPUT)
!     NEQ   NUMBER OF EQUATIONS
!     KOLD  ORDER USED ON LAST SUCCESSFUL STEP
!     PHI   ARRAY OF SCALED DIVIDED DIFFERENCES OF Y
!     PSI   ARRAY OF PAST STEPSIZE HISTORY
!-----------------------------------------------------------------------
!***ROUTINES CALLED  (NONE)
!***REVISION HISTORY  (YYMMDD)
!   830315  DATE WRITTEN
!   901009  Finished conversion to SLATEC 4.0 format (F.N.Fritsch)
!   901019  Merged changes made by C. Ulrich with SLATEC 4.0 format.
!   901026  Added explicit declarations for all variables and minor
!           cosmetic changes to prologue.  (FNF)
!***END PROLOGUE  DDATRP
!
      IMPLICIT NONE

      INTEGER :: NEQ, KOLD
      DOUBLE PRECISION :: X, XOUT,                                      &
                          YOUT(*), YPOUT(*), PHI(NEQ,*), PSI(*)
!
      INTEGER :: I, J, KOLDP1
      DOUBLE PRECISION :: C, D, GAMMA, TEMP1

      KOLDP1 = KOLD + 1
      TEMP1 = XOUT - X
      DO I = 1, NEQ
         YOUT(I) = PHI(I,1)
         YPOUT(I) = 0.0D0
      END DO
      C = 1.0D0
      D = 0.0D0
      GAMMA = TEMP1/PSI(1)
      DO J = 2, KOLDP1
         D = D*GAMMA+C/PSI(J-1)
         C = C*GAMMA
         GAMMA = (TEMP1+PSI(J-1))/PSI(J)
         DO I = 1, NEQ
            YOUT(I) = YOUT(I)+C*PHI(I,J)
            YPOUT(I) = YPOUT(I)+D*PHI(I,J)
         END DO
      END DO

   END
