!DECK DDANRM
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 18 aug 2014
!
   DOUBLE PRECISION FUNCTION DDANRM( NEQ, V, WT )
!***BEGIN PROLOGUE  DDANRM
!***SUBSIDIARY
!***PURPOSE  Compute vector norm for DDASSL.
!***LIBRARY   SLATEC (DASSL)
!***TYPE      DOUBLE PRECISION (SDANRM-S, DDANRM-D)
!***AUTHOR  Petzold, Linda R., (LLNL)
!***DESCRIPTION
!-----------------------------------------------------------------------
!     This function routine computes the weighted RMS (Root-Mean-Square)
!     norm of the vector of length NEQ contained in the array V, with
!     weights contained in the array WT of same length.
!        DDANRM = SQRT( (1/NEQ)*SUM( (V(I)/WT(I))**2 ) )
!-----------------------------------------------------------------------
!***ROUTINES CALLED  (NONE)
!***REVISION HISTORY  (YYMMDD)
!   830315  DATE WRITTEN
!   901009  Finished conversion to SLATEC 4.0 format (F.N. Fritsch)
!   901019  Merged changes made by C. Ulrich with SLATEC 4.0 format.
!   901026  Added explicit declarations for all variables and minor
!           cosmetic changes to prologue.  (FNF)
!***END PROLOGUE  DDANRM

      IMPLICIT NONE

      INTEGER :: NEQ
      DOUBLE PRECISION :: V(NEQ), WT(NEQ)

      INTEGER :: I
      DOUBLE PRECISION :: SUM, VMAX, TMP

!***FIRST EXECUTABLE STATEMENT  DDANRM
      DDANRM = 0.0D0
      VMAX = 0.0D0

      do I = 1, NEQ
         TMP = ABS(V(I)/WT(I))
         if( TMP > VMAX) then
            VMAX = TMP
         end if
      end do

      if( VMAX <= 0.0D0 ) return

      SUM = 0.0D0
      do I = 1, NEQ
         SUM = SUM + ((V(I)/WT(I))/VMAX)**2
      end do
      DDANRM = VMAX*SQRT(SUM/NEQ)

   END
