!DECK DCFOD
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 jan 2022
!
   SUBROUTINE DCFOD( METH, ELCO, TESCO )

      implicit none

      integer,          intent(in)  :: METH
      double precision, intent(out) :: ELCO(13,12), TESCO(3,12)

!***BEGIN PROLOGUE  DCFOD
!***SUBSIDIARY
!***PURPOSE  Subsidiary to DDEBDF
!***LIBRARY   SLATEC
!***TYPE      DOUBLE PRECISION (CFOD-S, DCFOD-D)
!***AUTHOR  (UNKNOWN)
!***DESCRIPTION
!
!   DCFOD defines coefficients needed in the integrator package DDEBDF
!
!***SEE ALSO  DDEBDF
!***ROUTINES CALLED  (NONE)
!***REVISION HISTORY  (YYMMDD)
!   820301  DATE WRITTEN
!   900328  Last modification. For details see original file.
!***END PROLOGUE  DCFOD

      integer :: I, IB, NQ, NQM1, NQP1
      double precision :: AGAMQ, FNQ, FNQM1, PC(12), PINT, RAGQ,        &
                          RQ1FAC, RQFAC, TSIGN, XPIN

!     ------------------------------------------------------------------
!      DCFOD is called by the integrator routine to set coefficients
!      needed there.  The coefficients for the current method, as
!      given by the value of METH, are set for all orders and saved.
!      The maximum order assumed here is 12 if METH = 1 and 5 if METH = 2.
!      (A smaller value of the maximum order is also allowed.)
!      DCFOD is called once at the beginning of the problem,
!      and is not called again unless and until METH is changed.
!
!      The ELCO array contains the basic method coefficients.
!      The coefficients EL(I), 1 <= I <= NQ+1, for the method of
!      order NQ are stored in ELCO(I,NQ).  They are given by a
!      generating polynomial, i.e.,
!          L(X) = EL(1) + EL(2)*X + ... + EL(NQ+1)*X**NQ.
!      For the implicit ADAMS methods, L(X) is given by
!          DL/DX = (X+1)*(X+2)*...*(X+NQ-1)/FACTORIAL(NQ-1), L(-1) = 0.
!      For the BDF methods, L(X) is given by
!          L(X) = (X+1)*(X+2)* ... *(X+NQ)/K,
!      where         K = FACTORIAL(NQ)*(1 + 1/2 + ... + 1/NQ).
!
!      The TESCO array contains test constants used for the
!      local error test and the selection of step size and/or order.
!      At order NQ, TESCO(K,NQ) is used for the selection of step
!      size at order NQ-1 if K = 1, at order NQ if K = 2, and at order
!      NQ+1 if K = 3.
!     ------------------------------------------------------------------

      if( METH == 1 ) then

         ELCO(1,1) = 1.0d0
         ELCO(2,1) = 1.0d0
         TESCO(1,1) = 0.0d0
         TESCO(2,1) = 2.0d0
         TESCO(1,2) = 1.0d0
         TESCO(3,12) = 0.0d0
         PC(1) = 1.0d0
         RQFAC = 1.0d0
         DO NQ = 2, 12
            !-----------------------------------------------------------
            ! The PC array will contain the coefficients of the polynomial
            !    P(X) = (X+1)*(X+2)*...*(X+NQ-1).
            ! Initially, P(X) = 1.
            !-----------------------------------------------------------
            RQ1FAC = RQFAC
            RQFAC = RQFAC/NQ
            NQM1 = NQ - 1
            FNQM1 = NQM1
            NQP1 = NQ + 1
            ! Form coefficients of P(X)*(X+NQ-1).
            PC(NQ) = 0.0d0
            DO IB = 1, NQM1
               I = NQP1 - IB
               PC(I) = PC(I-1) + FNQM1*PC(I)
            END DO
            PC(1) = FNQM1*PC(1)
            ! Compute integral, -1 TO 0, of P(X) and X*P(X).
            PINT = PC(1)
            XPIN = PC(1)/2.0d0
            TSIGN = 1.0d0
            DO I = 2, NQ
               TSIGN = -TSIGN
               PINT = PINT + TSIGN*PC(I)/I
               XPIN = XPIN + TSIGN*PC(I)/(I+1)
            END DO
            ! Store coefficients in ELCO and TESCO.
            ELCO(1,NQ) = PINT*RQ1FAC
            ELCO(2,NQ) = 1.0d0
            DO I = 2, NQ
               ELCO(I+1,NQ) = RQ1FAC*PC(I)/I
            END DO
            AGAMQ = RQFAC*XPIN
            RAGQ = 1.0d0/AGAMQ
            TESCO(2,NQ) = RAGQ
            if( NQ < 12 ) TESCO(1,NQP1) = RAGQ*RQFAC/NQP1
            TESCO(3,NQM1) = RAGQ
         END DO

      else ! METH = 2

         PC(1) = 1.0d0
         RQ1FAC = 1.0d0
         DO NQ = 1, 5
            !-----------------------------------------------------------
            ! The PC array will contain the coefficients of the polynomial
            !   P(X) = (X+1)*(X+2)*...*(X+NQ).
            ! Initially, P(X) = 1.
            !-----------------------------------------------------------
            FNQ = NQ
            NQP1 = NQ + 1
            ! Form coefficients of P(X)*(X+NQ).
            PC(NQP1) = 0.0d0
            DO IB = 1, NQ
               I = NQ + 2 - IB
               PC(I) = PC(I-1) + FNQ*PC(I)
            END DO
            PC(1) = FNQ*PC(1)
            ! Store coefficients in ELCO and TESCO.
            DO I = 1, NQP1
               ELCO(I,NQ) = PC(I)/PC(2)
            END DO
            ELCO(2,NQ) = 1.0d0
            TESCO(1,NQ) = RQ1FAC
            TESCO(2,NQ) = NQP1/ELCO(1,NQ)
            TESCO(3,NQ) = (NQ+2)/ELCO(1,NQ)
            RQ1FAC = RQ1FAC/FNQ
         END DO

      end if

   END
