!DECK DBSK1E
   DOUBLE PRECISION FUNCTION DBSK1E( X )
!***BEGIN PROLOGUE  DBSK1E
!***PURPOSE  Compute the exponentially scaled modified (hyperbolic)
!            Bessel function of the third kind of order one.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10B1
!***TYPE      DOUBLE PRECISION (BESK1E-S, DBSK1E-D)
!***KEYWORDS  EXPONENTIALLY SCALED, FNLIB, HYPERBOLIC BESSEL FUNCTION,
!             MODIFIED BESSEL FUNCTION, ORDER ONE, SPECIAL FUNCTIONS,
!             THIRD KIND
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DBSK1E(S) computes the double precision exponentially scaled
! modified (hyperbolic) Bessel function of the third kind of order
! one for positive double precision argument X.
!
! Series for BK1        on the interval  0.          to  4.00000E+00
!                                        with weighted error   9.16E-32
!                                         log weighted error  31.04
!                               significant figures required  30.61
!                                    decimal places required  31.64
!
! Series for AK1        on the interval  1.25000E-01 to  5.00000E-01
!                                        with weighted error   3.07E-32
!                                         log weighted error  31.51
!                               significant figures required  30.71
!                                    decimal places required  32.30
!
! Series for AK12       on the interval  0.          to  1.25000E-01
!                                        with weighted error   2.41E-32
!                                         log weighted error  31.62
!                               significant figures required  30.25
!                                    decimal places required  32.38
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, DBESI1, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!***END PROLOGUE  DBSK1E
      DOUBLE PRECISION X, BK1CS(16), AK1CS(38), AK12CS(33), XMIN,       &
        XSML, Y
      LOGICAL FIRST
      SAVE BK1CS, AK1CS, AK12CS, NTK1, NTAK1, NTAK12, XMIN, XSML,       &
        FIRST
      DATA BK1CS(  1) / +.25300227338947770532531120868533D-1     /
      DATA BK1CS(  2) / -.35315596077654487566723831691801D+0     /
      DATA BK1CS(  3) / -.12261118082265714823479067930042D+0     /
      DATA BK1CS(  4) / -.69757238596398643501812920296083D-2     /
      DATA BK1CS(  5) / -.17302889575130520630176507368979D-3     /
      DATA BK1CS(  6) / -.24334061415659682349600735030164D-5     /
      DATA BK1CS(  7) / -.22133876307347258558315252545126D-7     /
      DATA BK1CS(  8) / -.14114883926335277610958330212608D-9     /
      DATA BK1CS(  9) / -.66669016941993290060853751264373D-12    /
      DATA BK1CS( 10) / -.24274498505193659339263196864853D-14    /
      DATA BK1CS( 11) / -.70238634793862875971783797120000D-17    /
      DATA BK1CS( 12) / -.16543275155100994675491029333333D-19    /
      DATA BK1CS( 13) / -.32338347459944491991893333333333D-22    /
      DATA BK1CS( 14) / -.53312750529265274999466666666666D-25    /
      DATA BK1CS( 15) / -.75130407162157226666666666666666D-28    /
      DATA BK1CS( 16) / -.91550857176541866666666666666666D-31    /
      DATA AK1CS(  1) / +.27443134069738829695257666227266D+0     /
      DATA AK1CS(  2) / +.75719899531993678170892378149290D-1     /
      DATA AK1CS(  3) / -.14410515564754061229853116175625D-2     /
      DATA AK1CS(  4) / +.66501169551257479394251385477036D-4     /
      DATA AK1CS(  5) / -.43699847095201407660580845089167D-5     /
      DATA AK1CS(  6) / +.35402774997630526799417139008534D-6     /
      DATA AK1CS(  7) / -.33111637792932920208982688245704D-7     /
      DATA AK1CS(  8) / +.34459775819010534532311499770992D-8     /
      DATA AK1CS(  9) / -.38989323474754271048981937492758D-9     /
      DATA AK1CS( 10) / +.47208197504658356400947449339005D-10    /
      DATA AK1CS( 11) / -.60478356628753562345373591562890D-11    /
      DATA AK1CS( 12) / +.81284948748658747888193837985663D-12    /
      DATA AK1CS( 13) / -.11386945747147891428923915951042D-12    /
      DATA AK1CS( 14) / +.16540358408462282325972948205090D-13    /
      DATA AK1CS( 15) / -.24809025677068848221516010440533D-14    /
      DATA AK1CS( 16) / +.38292378907024096948429227299157D-15    /
      DATA AK1CS( 17) / -.60647341040012418187768210377386D-16    /
      DATA AK1CS( 18) / +.98324256232648616038194004650666D-17    /
      DATA AK1CS( 19) / -.16284168738284380035666620115626D-17    /
      DATA AK1CS( 20) / +.27501536496752623718284120337066D-18    /
      DATA AK1CS( 21) / -.47289666463953250924281069568000D-19    /
      DATA AK1CS( 22) / +.82681500028109932722392050346666D-20    /
      DATA AK1CS( 23) / -.14681405136624956337193964885333D-20    /
      DATA AK1CS( 24) / +.26447639269208245978085894826666D-21    /
      DATA AK1CS( 25) / -.48290157564856387897969868800000D-22    /
      DATA AK1CS( 26) / +.89293020743610130180656332799999D-23    /
      DATA AK1CS( 27) / -.16708397168972517176997751466666D-23    /
      DATA AK1CS( 28) / +.31616456034040694931368618666666D-24    /
      DATA AK1CS( 29) / -.60462055312274989106506410666666D-25    /
      DATA AK1CS( 30) / +.11678798942042732700718421333333D-25    /
      DATA AK1CS( 31) / -.22773741582653996232867840000000D-26    /
      DATA AK1CS( 32) / +.44811097300773675795305813333333D-27    /
      DATA AK1CS( 33) / -.88932884769020194062336000000000D-28    /
      DATA AK1CS( 34) / +.17794680018850275131392000000000D-28    /
      DATA AK1CS( 35) / -.35884555967329095821994666666666D-29    /
      DATA AK1CS( 36) / +.72906290492694257991679999999999D-30    /
      DATA AK1CS( 37) / -.14918449845546227073024000000000D-30    /
      DATA AK1CS( 38) / +.30736573872934276300799999999999D-31    /
      DATA AK12CS(  1) / +.6379308343739001036600488534102D-1      /
      DATA AK12CS(  2) / +.2832887813049720935835030284708D-1      /
      DATA AK12CS(  3) / -.2475370673905250345414545566732D-3      /
      DATA AK12CS(  4) / +.5771972451607248820470976625763D-5      /
      DATA AK12CS(  5) / -.2068939219536548302745533196552D-6      /
      DATA AK12CS(  6) / +.9739983441381804180309213097887D-8      /
      DATA AK12CS(  7) / -.5585336140380624984688895511129D-9      /
      DATA AK12CS(  8) / +.3732996634046185240221212854731D-10     /
      DATA AK12CS(  9) / -.2825051961023225445135065754928D-11     /
      DATA AK12CS( 10) / +.2372019002484144173643496955486D-12     /
      DATA AK12CS( 11) / -.2176677387991753979268301667938D-13     /
      DATA AK12CS( 12) / +.2157914161616032453939562689706D-14     /
      DATA AK12CS( 13) / -.2290196930718269275991551338154D-15     /
      DATA AK12CS( 14) / +.2582885729823274961919939565226D-16     /
      DATA AK12CS( 15) / -.3076752641268463187621098173440D-17     /
      DATA AK12CS( 16) / +.3851487721280491597094896844799D-18     /
      DATA AK12CS( 17) / -.5044794897641528977117282508800D-19     /
      DATA AK12CS( 18) / +.6888673850418544237018292223999D-20     /
      DATA AK12CS( 19) / -.9775041541950118303002132480000D-21     /
      DATA AK12CS( 20) / +.1437416218523836461001659733333D-21     /
      DATA AK12CS( 21) / -.2185059497344347373499733333333D-22     /
      DATA AK12CS( 22) / +.3426245621809220631645388800000D-23     /
      DATA AK12CS( 23) / -.5531064394246408232501248000000D-24     /
      DATA AK12CS( 24) / +.9176601505685995403782826666666D-25     /
      DATA AK12CS( 25) / -.1562287203618024911448746666666D-25     /
      DATA AK12CS( 26) / +.2725419375484333132349439999999D-26     /
      DATA AK12CS( 27) / -.4865674910074827992378026666666D-27     /
      DATA AK12CS( 28) / +.8879388552723502587357866666666D-28     /
      DATA AK12CS( 29) / -.1654585918039257548936533333333D-28     /
      DATA AK12CS( 30) / +.3145111321357848674303999999999D-29     /
      DATA AK12CS( 31) / -.6092998312193127612416000000000D-30     /
      DATA AK12CS( 32) / +.1202021939369815834623999999999D-30     /
      DATA AK12CS( 33) / -.2412930801459408841386666666666D-31     /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DBSK1E
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NTK1 = INITDS (BK1CS, 16, ETA)
         NTAK1 = INITDS (AK1CS, 38, ETA)
         NTAK12 = INITDS (AK12CS, 33, ETA)
!
         XMIN = EXP (MAX(LOG(D1MACH(1)), -LOG(D1MACH(2))) + 0.01D0)
         XSML = SQRT(4.0D0*D1MACH(3))
      ENDIF
      FIRST = .FALSE.
!
      IF (X .LE. 0.D0) CALL XERMSG ('SLATEC', 'DBSK1E',                 &
         'X IS ZERO OR NEGATIVE', 2, 2)
      IF (X.GT.2.0D0) GO TO 20
!
      IF (X .LT. XMIN) CALL XERMSG ('SLATEC', 'DBSK1E',                 &
         'X SO SMALL K1 OVERFLOWS', 3, 2)
      Y = 0.D0
      IF (X.GT.XSML) Y = X*X
      DBSK1E = EXP(X)*(LOG(0.5D0*X)*DBESI1(X) + (0.75D0 +               &
        DCSEVL (0.5D0*Y-1.D0, BK1CS, NTK1))/X )
      RETURN
!
   20 IF (X.LE.8.D0) DBSK1E = (1.25D0 + DCSEVL ((16.D0/X-5.D0)/3.D0,    &
        AK1CS, NTAK1))/SQRT(X)
      IF (X.GT.8.D0) DBSK1E = (1.25D0 +                                 &
        DCSEVL (16.D0/X-1.D0, AK12CS, NTAK12))/SQRT(X)
!
   END
