!DECK DBSK0E
   DOUBLE PRECISION FUNCTION DBSK0E( X )
!***BEGIN PROLOGUE  DBSK0E
!***PURPOSE  Compute the exponentially scaled modified (hyperbolic)
!            Bessel function of the third kind of order zero.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10B1
!***TYPE      DOUBLE PRECISION (BESK0E-S, DBSK0E-D)
!***KEYWORDS  EXPONENTIALLY SCALED, FNLIB, HYPERBOLIC BESSEL FUNCTION,
!             MODIFIED BESSEL FUNCTION, ORDER ZERO, SPECIAL FUNCTIONS,
!             THIRD KIND
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DBSK0E(X) computes the double precision exponentially scaled
! modified (hyperbolic) Bessel function of the third kind of
! order zero for positive double precision argument X.
!
! Series for BK0        on the interval  0.          to  4.00000E+00
!                                        with weighted error   3.08E-33
!                                         log weighted error  32.51
!                               significant figures required  32.05
!                                    decimal places required  33.11
!
! Series for AK0        on the interval  1.25000E-01 to  5.00000E-01
!                                        with weighted error   2.85E-32
!                                         log weighted error  31.54
!                               significant figures required  30.19
!                                    decimal places required  32.33
!
! Series for AK02       on the interval  0.          to  1.25000E-01
!                                        with weighted error   2.30E-32
!                                         log weighted error  31.64
!                               significant figures required  29.68
!                                    decimal places required  32.40
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, DBESI0, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!***END PROLOGUE  DBSK0E
      DOUBLE PRECISION X, BK0CS(16), AK0CS(38), AK02CS(33),             &
        XSML, Y
      LOGICAL FIRST
      SAVE BK0CS, AK0CS, AK02CS, NTK0, NTAK0, NTAK02, XSML, FIRST
      DATA BK0CS(  1) / -.353273932339027687201140060063153D-1    /
      DATA BK0CS(  2) / +.344289899924628486886344927529213D+0    /
      DATA BK0CS(  3) / +.359799365153615016265721303687231D-1    /
      DATA BK0CS(  4) / +.126461541144692592338479508673447D-2    /
      DATA BK0CS(  5) / +.228621210311945178608269830297585D-4    /
      DATA BK0CS(  6) / +.253479107902614945730790013428354D-6    /
      DATA BK0CS(  7) / +.190451637722020885897214059381366D-8    /
      DATA BK0CS(  8) / +.103496952576336245851008317853089D-10   /
      DATA BK0CS(  9) / +.425981614279108257652445327170133D-13   /
      DATA BK0CS( 10) / +.137446543588075089694238325440000D-15   /
      DATA BK0CS( 11) / +.357089652850837359099688597333333D-18   /
      DATA BK0CS( 12) / +.763164366011643737667498666666666D-21   /
      DATA BK0CS( 13) / +.136542498844078185908053333333333D-23   /
      DATA BK0CS( 14) / +.207527526690666808319999999999999D-26   /
      DATA BK0CS( 15) / +.271281421807298560000000000000000D-29   /
      DATA BK0CS( 16) / +.308259388791466666666666666666666D-32   /
      DATA AK0CS(  1) / -.7643947903327941424082978270088D-1      /
      DATA AK0CS(  2) / -.2235652605699819052023095550791D-1      /
      DATA AK0CS(  3) / +.7734181154693858235300618174047D-3      /
      DATA AK0CS(  4) / -.4281006688886099464452146435416D-4      /
      DATA AK0CS(  5) / +.3081700173862974743650014826660D-5      /
      DATA AK0CS(  6) / -.2639367222009664974067448892723D-6      /
      DATA AK0CS(  7) / +.2563713036403469206294088265742D-7      /
      DATA AK0CS(  8) / -.2742705549900201263857211915244D-8      /
      DATA AK0CS(  9) / +.3169429658097499592080832873403D-9      /
      DATA AK0CS( 10) / -.3902353286962184141601065717962D-10     /
      DATA AK0CS( 11) / +.5068040698188575402050092127286D-11     /
      DATA AK0CS( 12) / -.6889574741007870679541713557984D-12     /
      DATA AK0CS( 13) / +.9744978497825917691388201336831D-13     /
      DATA AK0CS( 14) / -.1427332841884548505389855340122D-13     /
      DATA AK0CS( 15) / +.2156412571021463039558062976527D-14     /
      DATA AK0CS( 16) / -.3349654255149562772188782058530D-15     /
      DATA AK0CS( 17) / +.5335260216952911692145280392601D-16     /
      DATA AK0CS( 18) / -.8693669980890753807639622378837D-17     /
      DATA AK0CS( 19) / +.1446404347862212227887763442346D-17     /
      DATA AK0CS( 20) / -.2452889825500129682404678751573D-18     /
      DATA AK0CS( 21) / +.4233754526232171572821706342400D-19     /
      DATA AK0CS( 22) / -.7427946526454464195695341294933D-20     /
      DATA AK0CS( 23) / +.1323150529392666866277967462400D-20     /
      DATA AK0CS( 24) / -.2390587164739649451335981465599D-21     /
      DATA AK0CS( 25) / +.4376827585923226140165712554666D-22     /
      DATA AK0CS( 26) / -.8113700607345118059339011413333D-23     /
      DATA AK0CS( 27) / +.1521819913832172958310378154666D-23     /
      DATA AK0CS( 28) / -.2886041941483397770235958613333D-24     /
      DATA AK0CS( 29) / +.5530620667054717979992610133333D-25     /
      DATA AK0CS( 30) / -.1070377329249898728591633066666D-25     /
      DATA AK0CS( 31) / +.2091086893142384300296328533333D-26     /
      DATA AK0CS( 32) / -.4121713723646203827410261333333D-27     /
      DATA AK0CS( 33) / +.8193483971121307640135680000000D-28     /
      DATA AK0CS( 34) / -.1642000275459297726780757333333D-28     /
      DATA AK0CS( 35) / +.3316143281480227195890346666666D-29     /
      DATA AK0CS( 36) / -.6746863644145295941085866666666D-30     /
      DATA AK0CS( 37) / +.1382429146318424677635413333333D-30     /
      DATA AK0CS( 38) / -.2851874167359832570811733333333D-31     /
      DATA AK02CS(  1) / -.1201869826307592239839346212452D-1      /
      DATA AK02CS(  2) / -.9174852691025695310652561075713D-2      /
      DATA AK02CS(  3) / +.1444550931775005821048843878057D-3      /
      DATA AK02CS(  4) / -.4013614175435709728671021077879D-5      /
      DATA AK02CS(  5) / +.1567831810852310672590348990333D-6      /
      DATA AK02CS(  6) / -.7770110438521737710315799754460D-8      /
      DATA AK02CS(  7) / +.4611182576179717882533130529586D-9      /
      DATA AK02CS(  8) / -.3158592997860565770526665803309D-10     /
      DATA AK02CS(  9) / +.2435018039365041127835887814329D-11     /
      DATA AK02CS( 10) / -.2074331387398347897709853373506D-12     /
      DATA AK02CS( 11) / +.1925787280589917084742736504693D-13     /
      DATA AK02CS( 12) / -.1927554805838956103600347182218D-14     /
      DATA AK02CS( 13) / +.2062198029197818278285237869644D-15     /
      DATA AK02CS( 14) / -.2341685117579242402603640195071D-16     /
      DATA AK02CS( 15) / +.2805902810643042246815178828458D-17     /
      DATA AK02CS( 16) / -.3530507631161807945815482463573D-18     /
      DATA AK02CS( 17) / +.4645295422935108267424216337066D-19     /
      DATA AK02CS( 18) / -.6368625941344266473922053461333D-20     /
      DATA AK02CS( 19) / +.9069521310986515567622348800000D-21     /
      DATA AK02CS( 20) / -.1337974785423690739845005311999D-21     /
      DATA AK02CS( 21) / +.2039836021859952315522088960000D-22     /
      DATA AK02CS( 22) / -.3207027481367840500060869973333D-23     /
      DATA AK02CS( 23) / +.5189744413662309963626359466666D-24     /
      DATA AK02CS( 24) / -.8629501497540572192964607999999D-25     /
      DATA AK02CS( 25) / +.1472161183102559855208038400000D-25     /
      DATA AK02CS( 26) / -.2573069023867011283812351999999D-26     /
      DATA AK02CS( 27) / +.4601774086643516587376640000000D-27     /
      DATA AK02CS( 28) / -.8411555324201093737130666666666D-28     /
      DATA AK02CS( 29) / +.1569806306635368939301546666666D-28     /
      DATA AK02CS( 30) / -.2988226453005757788979199999999D-29     /
      DATA AK02CS( 31) / +.5796831375216836520618666666666D-30     /
      DATA AK02CS( 32) / -.1145035994347681332155733333333D-30     /
      DATA AK02CS( 33) / +.2301266594249682802005333333333D-31     /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DBSK0E
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NTK0 = INITDS (BK0CS, 16, ETA)
         NTAK0 = INITDS (AK0CS, 38, ETA)
         NTAK02 = INITDS (AK02CS, 33, ETA)
         XSML = SQRT(4.0D0*D1MACH(3))
      ENDIF
      FIRST = .FALSE.
!
      IF (X .LE. 0.D0) CALL XERMSG ('SLATEC', 'DBSK0E',                 &
         'X IS ZERO OR NEGATIVE', 2, 2)
      IF (X.GT.2.0D0) GO TO 20
!
      Y = 0.D0
      IF (X.GT.XSML) Y = X*X
      DBSK0E = EXP(X)*(-LOG(0.5D0*X)*DBESI0(X) - 0.25D0 +               &
        DCSEVL (.5D0*Y-1.D0, BK0CS, NTK0))
      RETURN
!
   20 IF (X.LE.8.D0) DBSK0E = (1.25D0 + DCSEVL ((16.D0/X-5.D0)/3.D0,    &
        AK0CS, NTAK0))/SQRT(X)
      IF (X.GT.8.D0) DBSK0E = (1.25D0 +                                 &
        DCSEVL (16.D0/X-1.D0, AK02CS, NTAK02))/SQRT(X)
!
   END
