!DECK DBSI1E
   DOUBLE PRECISION FUNCTION DBSI1E( X )
!***BEGIN PROLOGUE  DBSI1E
!***PURPOSE  Compute the exponentially scaled modified (hyperbolic)
!            Bessel function of the first kind of order one.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10B1
!***TYPE      DOUBLE PRECISION (BESI1E-S, DBSI1E-D)
!***KEYWORDS  EXPONENTIALLY SCALED, FIRST KIND, FNLIB,
!             HYPERBOLIC BESSEL FUNCTION, MODIFIED BESSEL FUNCTION,
!             ORDER ONE, SPECIAL FUNCTIONS
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DBSI1E(X) calculates the double precision exponentially scaled
! modified (hyperbolic) Bessel function of the first kind of order
! one for double precision argument X.  The result is I1(X)
! multiplied by EXP(-ABS(X)).
!
! Series for BI1        on the interval  0.          to  9.00000E+00
!                                        with weighted error   1.44E-32
!                                         log weighted error  31.84
!                               significant figures required  31.45
!                                    decimal places required  32.46
!
! Series for AI1        on the interval  1.25000E-01 to  3.33333E-01
!                                        with weighted error   2.81E-32
!                                         log weighted error  31.55
!                               significant figures required  29.93
!                                    decimal places required  32.38
!
! Series for AI12       on the interval  0.          to  1.25000E-01
!                                        with weighted error   1.83E-32
!                                         log weighted error  31.74
!                               significant figures required  29.97
!                                    decimal places required  32.66
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!***END PROLOGUE  DBSI1E
      DOUBLE PRECISION X, BI1CS(17), AI1CS(46), AI12CS(69), XMIN,       &
        XSML, Y
      LOGICAL FIRST
      SAVE BI1CS, AI1CS, AI12CS, NTI1, NTAI1, NTAI12, XMIN, XSML,       &
        FIRST
      DATA BI1CS(  1) / -.19717132610998597316138503218149D-2     /
      DATA BI1CS(  2) / +.40734887667546480608155393652014D+0     /
      DATA BI1CS(  3) / +.34838994299959455866245037783787D-1     /
      DATA BI1CS(  4) / +.15453945563001236038598401058489D-2     /
      DATA BI1CS(  5) / +.41888521098377784129458832004120D-4     /
      DATA BI1CS(  6) / +.76490267648362114741959703966069D-6     /
      DATA BI1CS(  7) / +.10042493924741178689179808037238D-7     /
      DATA BI1CS(  8) / +.99322077919238106481371298054863D-10    /
      DATA BI1CS(  9) / +.76638017918447637275200171681349D-12    /
      DATA BI1CS( 10) / +.47414189238167394980388091948160D-14    /
      DATA BI1CS( 11) / +.24041144040745181799863172032000D-16    /
      DATA BI1CS( 12) / +.10171505007093713649121100799999D-18    /
      DATA BI1CS( 13) / +.36450935657866949458491733333333D-21    /
      DATA BI1CS( 14) / +.11205749502562039344810666666666D-23    /
      DATA BI1CS( 15) / +.29875441934468088832000000000000D-26    /
      DATA BI1CS( 16) / +.69732310939194709333333333333333D-29    /
      DATA BI1CS( 17) / +.14367948220620800000000000000000D-31    /
      DATA AI1CS(  1) / -.2846744181881478674100372468307D-1      /
      DATA AI1CS(  2) / -.1922953231443220651044448774979D-1      /
      DATA AI1CS(  3) / -.6115185857943788982256249917785D-3      /
      DATA AI1CS(  4) / -.2069971253350227708882823777979D-4      /
      DATA AI1CS(  5) / +.8585619145810725565536944673138D-5      /
      DATA AI1CS(  6) / +.1049498246711590862517453997860D-5      /
      DATA AI1CS(  7) / -.2918338918447902202093432326697D-6      /
      DATA AI1CS(  8) / -.1559378146631739000160680969077D-7      /
      DATA AI1CS(  9) / +.1318012367144944705525302873909D-7      /
      DATA AI1CS( 10) / -.1448423418183078317639134467815D-8      /
      DATA AI1CS( 11) / -.2908512243993142094825040993010D-9      /
      DATA AI1CS( 12) / +.1266388917875382387311159690403D-9      /
      DATA AI1CS( 13) / -.1664947772919220670624178398580D-10     /
      DATA AI1CS( 14) / -.1666653644609432976095937154999D-11     /
      DATA AI1CS( 15) / +.1242602414290768265232168472017D-11     /
      DATA AI1CS( 16) / -.2731549379672432397251461428633D-12     /
      DATA AI1CS( 17) / +.2023947881645803780700262688981D-13     /
      DATA AI1CS( 18) / +.7307950018116883636198698126123D-14     /
      DATA AI1CS( 19) / -.3332905634404674943813778617133D-14     /
      DATA AI1CS( 20) / +.7175346558512953743542254665670D-15     /
      DATA AI1CS( 21) / -.6982530324796256355850629223656D-16     /
      DATA AI1CS( 22) / -.1299944201562760760060446080587D-16     /
      DATA AI1CS( 23) / +.8120942864242798892054678342860D-17     /
      DATA AI1CS( 24) / -.2194016207410736898156266643783D-17     /
      DATA AI1CS( 25) / +.3630516170029654848279860932334D-18     /
      DATA AI1CS( 26) / -.1695139772439104166306866790399D-19     /
      DATA AI1CS( 27) / -.1288184829897907807116882538222D-19     /
      DATA AI1CS( 28) / +.5694428604967052780109991073109D-20     /
      DATA AI1CS( 29) / -.1459597009090480056545509900287D-20     /
      DATA AI1CS( 30) / +.2514546010675717314084691334485D-21     /
      DATA AI1CS( 31) / -.1844758883139124818160400029013D-22     /
      DATA AI1CS( 32) / -.6339760596227948641928609791999D-23     /
      DATA AI1CS( 33) / +.3461441102031011111108146626560D-23     /
      DATA AI1CS( 34) / -.1017062335371393547596541023573D-23     /
      DATA AI1CS( 35) / +.2149877147090431445962500778666D-24     /
      DATA AI1CS( 36) / -.3045252425238676401746206173866D-25     /
      DATA AI1CS( 37) / +.5238082144721285982177634986666D-27     /
      DATA AI1CS( 38) / +.1443583107089382446416789503999D-26     /
      DATA AI1CS( 39) / -.6121302074890042733200670719999D-27     /
      DATA AI1CS( 40) / +.1700011117467818418349189802666D-27     /
      DATA AI1CS( 41) / -.3596589107984244158535215786666D-28     /
      DATA AI1CS( 42) / +.5448178578948418576650513066666D-29     /
      DATA AI1CS( 43) / -.2731831789689084989162564266666D-30     /
      DATA AI1CS( 44) / -.1858905021708600715771903999999D-30     /
      DATA AI1CS( 45) / +.9212682974513933441127765333333D-31     /
      DATA AI1CS( 46) / -.2813835155653561106370833066666D-31     /
      DATA AI12CS(  1) / +.2857623501828012047449845948469D-1      /
      DATA AI12CS(  2) / -.9761097491361468407765164457302D-2      /
      DATA AI12CS(  3) / -.1105889387626237162912569212775D-3      /
      DATA AI12CS(  4) / -.3882564808877690393456544776274D-5      /
      DATA AI12CS(  5) / -.2512236237870208925294520022121D-6      /
      DATA AI12CS(  6) / -.2631468846889519506837052365232D-7      /
      DATA AI12CS(  7) / -.3835380385964237022045006787968D-8      /
      DATA AI12CS(  8) / -.5589743462196583806868112522229D-9      /
      DATA AI12CS(  9) / -.1897495812350541234498925033238D-10     /
      DATA AI12CS( 10) / +.3252603583015488238555080679949D-10     /
      DATA AI12CS( 11) / +.1412580743661378133163366332846D-10     /
      DATA AI12CS( 12) / +.2035628544147089507224526136840D-11     /
      DATA AI12CS( 13) / -.7198551776245908512092589890446D-12     /
      DATA AI12CS( 14) / -.4083551111092197318228499639691D-12     /
      DATA AI12CS( 15) / -.2101541842772664313019845727462D-13     /
      DATA AI12CS( 16) / +.4272440016711951354297788336997D-13     /
      DATA AI12CS( 17) / +.1042027698412880276417414499948D-13     /
      DATA AI12CS( 18) / -.3814403072437007804767072535396D-14     /
      DATA AI12CS( 19) / -.1880354775510782448512734533963D-14     /
      DATA AI12CS( 20) / +.3308202310920928282731903352405D-15     /
      DATA AI12CS( 21) / +.2962628997645950139068546542052D-15     /
      DATA AI12CS( 22) / -.3209525921993423958778373532887D-16     /
      DATA AI12CS( 23) / -.4650305368489358325571282818979D-16     /
      DATA AI12CS( 24) / +.4414348323071707949946113759641D-17     /
      DATA AI12CS( 25) / +.7517296310842104805425458080295D-17     /
      DATA AI12CS( 26) / -.9314178867326883375684847845157D-18     /
      DATA AI12CS( 27) / -.1242193275194890956116784488697D-17     /
      DATA AI12CS( 28) / +.2414276719454848469005153902176D-18     /
      DATA AI12CS( 29) / +.2026944384053285178971922860692D-18     /
      DATA AI12CS( 30) / -.6394267188269097787043919886811D-19     /
      DATA AI12CS( 31) / -.3049812452373095896084884503571D-19     /
      DATA AI12CS( 32) / +.1612841851651480225134622307691D-19     /
      DATA AI12CS( 33) / +.3560913964309925054510270904620D-20     /
      DATA AI12CS( 34) / -.3752017947936439079666828003246D-20     /
      DATA AI12CS( 35) / -.5787037427074799345951982310741D-22     /
      DATA AI12CS( 36) / +.7759997511648161961982369632092D-21     /
      DATA AI12CS( 37) / -.1452790897202233394064459874085D-21     /
      DATA AI12CS( 38) / -.1318225286739036702121922753374D-21     /
      DATA AI12CS( 39) / +.6116654862903070701879991331717D-22     /
      DATA AI12CS( 40) / +.1376279762427126427730243383634D-22     /
      DATA AI12CS( 41) / -.1690837689959347884919839382306D-22     /
      DATA AI12CS( 42) / +.1430596088595433153987201085385D-23     /
      DATA AI12CS( 43) / +.3409557828090594020405367729902D-23     /
      DATA AI12CS( 44) / -.1309457666270760227845738726424D-23     /
      DATA AI12CS( 45) / -.3940706411240257436093521417557D-24     /
      DATA AI12CS( 46) / +.4277137426980876580806166797352D-24     /
      DATA AI12CS( 47) / -.4424634830982606881900283123029D-25     /
      DATA AI12CS( 48) / -.8734113196230714972115309788747D-25     /
      DATA AI12CS( 49) / +.4045401335683533392143404142428D-25     /
      DATA AI12CS( 50) / +.7067100658094689465651607717806D-26     /
      DATA AI12CS( 51) / -.1249463344565105223002864518605D-25     /
      DATA AI12CS( 52) / +.2867392244403437032979483391426D-26     /
      DATA AI12CS( 53) / +.2044292892504292670281779574210D-26     /
      DATA AI12CS( 54) / -.1518636633820462568371346802911D-26     /
      DATA AI12CS( 55) / +.8110181098187575886132279107037D-28     /
      DATA AI12CS( 56) / +.3580379354773586091127173703270D-27     /
      DATA AI12CS( 57) / -.1692929018927902509593057175448D-27     /
      DATA AI12CS( 58) / -.2222902499702427639067758527774D-28     /
      DATA AI12CS( 59) / +.5424535127145969655048600401128D-28     /
      DATA AI12CS( 60) / -.1787068401578018688764912993304D-28     /
      DATA AI12CS( 61) / -.6565479068722814938823929437880D-29     /
      DATA AI12CS( 62) / +.7807013165061145280922067706839D-29     /
      DATA AI12CS( 63) / -.1816595260668979717379333152221D-29     /
      DATA AI12CS( 64) / -.1287704952660084820376875598959D-29     /
      DATA AI12CS( 65) / +.1114548172988164547413709273694D-29     /
      DATA AI12CS( 66) / -.1808343145039336939159368876687D-30     /
      DATA AI12CS( 67) / -.2231677718203771952232448228939D-30     /
      DATA AI12CS( 68) / +.1619029596080341510617909803614D-30     /
      DATA AI12CS( 69) / -.1834079908804941413901308439210D-31     /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DBSI1E
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NTI1 = INITDS (BI1CS, 17, ETA)
         NTAI1 = INITDS (AI1CS, 46, ETA)
         NTAI12 = INITDS (AI12CS, 69, ETA)
!
         XMIN = 2.0D0*D1MACH(1)
         XSML = SQRT(4.5D0*D1MACH(3))
      ENDIF
      FIRST = .FALSE.
!
      Y = ABS(X)
      IF (Y.GT.3.0D0) GO TO 20
!
      DBSI1E = 0.0D0
      IF (Y.EQ.0.D0)  RETURN
!
      IF (Y .LE. XMIN) CALL XERMSG ('SLATEC', 'DBSI1E',                 &
         'ABS(X) SO SMALL I1 UNDERFLOWS', 1, 1)
      IF (Y.GT.XMIN) DBSI1E = 0.5D0*X
      IF (Y.GT.XSML) DBSI1E = X*(0.875D0 + DCSEVL (Y*Y/4.5D0-1.D0,      &
        BI1CS, NTI1) )
      DBSI1E = EXP(-Y) * DBSI1E
      RETURN
!
   20 IF (Y.LE.8.D0) DBSI1E = (0.375D0 + DCSEVL ((48.D0/Y-11.D0)/5.D0,  &
        AI1CS, NTAI1))/SQRT(Y)
      IF (Y.GT.8.D0) DBSI1E = (0.375D0 + DCSEVL (16.D0/Y-1.D0, AI12CS,  &
        NTAI12))/SQRT(Y)
      DBSI1E = SIGN (DBSI1E, X)
!
   END
