!DECK DBIE
   DOUBLE PRECISION FUNCTION DBIE( X )
!***BEGIN PROLOGUE  DBIE
!***PURPOSE  Calculate the Bairy function for a negative argument and an
!            exponentially scaled Bairy function for a non-negative
!            argument.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10D
!***TYPE      DOUBLE PRECISION (BIE-S, DBIE-D)
!***KEYWORDS  BAIRY FUNCTION, EXPONENTIALLY SCALED, FNLIB,
!             SPECIAL FUNCTIONS
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DBIE(X) calculates the double precision Airy function of the
! second kind or the double precision exponentially scaled Airy
! function of the second kind, depending on the value of the
! double precision argument X.
!
! Evaluate BI(X) for X .LE. 0.0  and  BI(X)*EXP(-ZETA)  where
! ZETA = 2/3 * X**(3/2)  for X .GE. 0.0
!
!
! Series for BIF        on the interval -1.00000E+00 to  1.00000E+00
!                                        with weighted error   1.45E-32
!                                         log weighted error  31.84
!                               significant figures required  30.85
!                                    decimal places required  32.40
!
!
! Series for BIG        on the interval -1.00000E+00 to  1.00000E+00
!                                        with weighted error   1.29E-33
!                                         log weighted error  32.89
!                               significant figures required  31.48
!                                    decimal places required  33.45
!
!
! Series for BIF2       on the interval  1.00000E+00 to  8.00000E+00
!                                        with weighted error   6.08E-32
!                                         log weighted error  31.22
!                        approx significant figures required  30.8
!                                    decimal places required  31.80
!
!
! Series for BIG2       on the interval  1.00000E+00 to  8.00000E+00
!                                        with weighted error   4.91E-33
!                                         log weighted error  32.31
!                        approx significant figures required  31.6
!                                    decimal places required  32.90
!
!
! Series for BIP1       on the interval  1.25000E-01 to  3.53553E-01
!                                        with weighted error   1.06E-32
!                                         log weighted error  31.98
!                               significant figures required  30.61
!                                    decimal places required  32.81
!
!
! Series for BIP2       on the interval  0.          to  1.25000E-01
!                                        with weighted error   4.04E-33
!                                         log weighted error  32.39
!                               significant figures required  31.15
!                                    decimal places required  33.37
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, D9AIMP, DCSEVL, INITDS
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!***END PROLOGUE  DBIE
      DOUBLE PRECISION X, BIFCS(13), BIGCS(13), BIF2CS(15), BIG2CS(15), &
        BIP1CS(47), BIP2CS(88), ATR, BTR, SQRTX, THETA, XBIG, XM, X3SML,&
        X32SML, Z
      LOGICAL FIRST
      SAVE BIFCS, BIGCS, BIF2CS, BIG2CS, BIP1CS, BIP2CS, ATR, BTR,      &
       NBIF, NBIG, NBIF2, NBIG2, NBIP1, NBIP2, X3SML, X32SML, XBIG,     &
       FIRST
      DATA BIFCS(  1) / -.16730216471986649483537423928176D-1     /
      DATA BIFCS(  2) / +.10252335834249445611426362777757D+0     /
      DATA BIFCS(  3) / +.17083092507381516539429650242013D-2     /
      DATA BIFCS(  4) / +.11862545467744681179216459210040D-4     /
      DATA BIFCS(  5) / +.44932907017792133694531887927242D-7     /
      DATA BIFCS(  6) / +.10698207143387889067567767663628D-9     /
      DATA BIFCS(  7) / +.17480643399771824706010517628573D-12    /
      DATA BIFCS(  8) / +.20810231071761711025881891834399D-15    /
      DATA BIFCS(  9) / +.18849814695665416509927971733333D-18    /
      DATA BIFCS( 10) / +.13425779173097804625882666666666D-21    /
      DATA BIFCS( 11) / +.77159593429658887893333333333333D-25    /
      DATA BIFCS( 12) / +.36533879617478566399999999999999D-28    /
      DATA BIFCS( 13) / +.14497565927953066666666666666666D-31    /
      DATA BIGCS(  1) / +.22466223248574522283468220139024D-1     /
      DATA BIGCS(  2) / +.37364775453019545441727561666752D-1     /
      DATA BIGCS(  3) / +.44476218957212285696215294326639D-3     /
      DATA BIGCS(  4) / +.24708075636329384245494591948882D-5     /
      DATA BIGCS(  5) / +.79191353395149635134862426285596D-8     /
      DATA BIGCS(  6) / +.16498079851827779880887872402706D-10    /
      DATA BIGCS(  7) / +.24119906664835455909247501122841D-13    /
      DATA BIGCS(  8) / +.26103736236091436985184781269333D-16    /
      DATA BIGCS(  9) / +.21753082977160323853123792000000D-19    /
      DATA BIGCS( 10) / +.14386946400390433219483733333333D-22    /
      DATA BIGCS( 11) / +.77349125612083468629333333333333D-26    /
      DATA BIGCS( 12) / +.34469292033849002666666666666666D-29    /
      DATA BIGCS( 13) / +.12938919273216000000000000000000D-32    /
      DATA BIF2CS(  1) / +.0998457269381604104468284257993D+0      /
      DATA BIF2CS(  2) / +.47862497786300553772211467318231D+0     /
      DATA BIF2CS(  3) / +.25155211960433011771324415436675D-1     /
      DATA BIF2CS(  4) / +.58206938852326456396515697872216D-3     /
      DATA BIF2CS(  5) / +.74997659644377865943861457378217D-5     /
      DATA BIF2CS(  6) / +.61346028703493836681403010356474D-7     /
      DATA BIF2CS(  7) / +.34627538851480632900434268733359D-9     /
      DATA BIF2CS(  8) / +.14288910080270254287770846748931D-11    /
      DATA BIF2CS(  9) / +.44962704298334641895056472179200D-14    /
      DATA BIF2CS( 10) / +.11142323065833011708428300106666D-16    /
      DATA BIF2CS( 11) / +.22304791066175002081517866666666D-19    /
      DATA BIF2CS( 12) / +.36815778736393142842922666666666D-22    /
      DATA BIF2CS( 13) / +.50960868449338261333333333333333D-25    /
      DATA BIF2CS( 14) / +.60003386926288554666666666666666D-28    /
      DATA BIF2CS( 15) / +.60827497446570666666666666666666D-31    /
      DATA BIG2CS(  1) / +.033305662145514340465176188111647D+0    /
      DATA BIG2CS(  2) / +.161309215123197067613287532084943D+0    /
      DATA BIG2CS(  3) / +.631900730961342869121615634921173D-2    /
      DATA BIG2CS(  4) / +.118790456816251736389780192304567D-3    /
      DATA BIG2CS(  5) / +.130453458862002656147116485012843D-5    /
      DATA BIG2CS(  6) / +.937412599553521729546809615508936D-8    /
      DATA BIG2CS(  7) / +.474580188674725153788510169834595D-10   /
      DATA BIG2CS(  8) / +.178310726509481399800065667560946D-12   /
      DATA BIG2CS(  9) / +.516759192784958180374276356640000D-15   /
      DATA BIG2CS( 10) / +.119004508386827125129496251733333D-17   /
      DATA BIG2CS( 11) / +.222982880666403517277063466666666D-20   /
      DATA BIG2CS( 12) / +.346551923027689419722666666666666D-23   /
      DATA BIG2CS( 13) / +.453926336320504514133333333333333D-26   /
      DATA BIG2CS( 14) / +.507884996513522346666666666666666D-29   /
      DATA BIG2CS( 15) / +.491020674696533333333333333333333D-32   /
      DATA BIP1CS(  1) / -.83220474779434474687471864707973D-1     /
      DATA BIP1CS(  2) / +.11461189273711742889920226128031D-1     /
      DATA BIP1CS(  3) / +.42896440718911509494134472566635D-3     /
      DATA BIP1CS(  4) / -.14906639379950514017847677732954D-3     /
      DATA BIP1CS(  5) / -.13076597267876290663136340998881D-4     /
      DATA BIP1CS(  6) / +.63275983961030344754535716032494D-5     /
      DATA BIP1CS(  7) / -.42226696982681924884778515889433D-6     /
      DATA BIP1CS(  8) / -.19147186298654689632835494181277D-6     /
      DATA BIP1CS(  9) / +.64531062845583173611038157880934D-7     /
      DATA BIP1CS( 10) / -.78448546771397719289748310448628D-8     /
      DATA BIP1CS( 11) / -.96077216623785085879198533565432D-9     /
      DATA BIP1CS( 12) / +.70004713316443966339006074402068D-9     /
      DATA BIP1CS( 13) / -.17731789132814932022083128056698D-9     /
      DATA BIP1CS( 14) / +.22720894783465236347282126389311D-10    /
      DATA BIP1CS( 15) / +.16540456313972049847032860681891D-11    /
      DATA BIP1CS( 16) / -.18517125559292316390755369896693D-11    /
      DATA BIP1CS( 17) / +.59576312477117290165680715534277D-12    /
      DATA BIP1CS( 18) / -.12194348147346564781055769498986D-12    /
      DATA BIP1CS( 19) / +.13347869253513048815386347813597D-13    /
      DATA BIP1CS( 20) / +.17278311524339746664384792889731D-14    /
      DATA BIP1CS( 21) / -.14590732013016720735268871713166D-14    /
      DATA BIP1CS( 22) / +.49010319927115819978994989520104D-15    /
      DATA BIP1CS( 23) / -.11556545519261548129262972762521D-15    /
      DATA BIP1CS( 24) / +.19098807367072411430671732441524D-16    /
      DATA BIP1CS( 25) / -.11768966854492179886913995957862D-17    /
      DATA BIP1CS( 26) / -.63271925149530064474537459677047D-18    /
      DATA BIP1CS( 27) / +.33861838880715361614130191322316D-18    /
      DATA BIP1CS( 28) / -.10725825321758625254992162219622D-18    /
      DATA BIP1CS( 29) / +.25995709605617169284786933115562D-19    /
      DATA BIP1CS( 30) / -.48477583571081193660962309494101D-20    /
      DATA BIP1CS( 31) / +.55298913982121625361505513198933D-21    /
      DATA BIP1CS( 32) / +.49421660826069471371748197444266D-22    /
      DATA BIP1CS( 33) / -.55162121924145707458069720814933D-22    /
      DATA BIP1CS( 34) / +.21437560417632550086631884499626D-22    /
      DATA BIP1CS( 35) / -.61910313387655605798785061137066D-23    /
      DATA BIP1CS( 36) / +.14629362707391245659830967336959D-23    /
      DATA BIP1CS( 37) / -.27918484471059005576177866069333D-24    /
      DATA BIP1CS( 38) / +.36455703168570246150906795349333D-25    /
      DATA BIP1CS( 39) / +.58511821906188711839382459733333D-27    /
      DATA BIP1CS( 40) / -.24946950487566510969745047551999D-26    /
      DATA BIP1CS( 41) / +.10979323980338380977919579477333D-26    /
      DATA BIP1CS( 42) / -.34743388345961115015034088106666D-27    /
      DATA BIP1CS( 43) / +.91373402635349697363171082240000D-28    /
      DATA BIP1CS( 44) / -.20510352728210629186247720959999D-28    /
      DATA BIP1CS( 45) / +.37976985698546461748651622399999D-29    /
      DATA BIP1CS( 46) / -.48479458497755565887848448000000D-30    /
      DATA BIP1CS( 47) / -.10558306941230714314205866666666D-31    /
      DATA BIP2CS(  1) / -.11359673758598867913797310895527D+0     /
      DATA BIP2CS(  2) / +.41381473947881595760052081171444D-2     /
      DATA BIP2CS(  3) / +.13534706221193329857696921727508D-3     /
      DATA BIP2CS(  4) / +.10427316653015353405887183456780D-4     /
      DATA BIP2CS(  5) / +.13474954767849907889589911958925D-5     /
      DATA BIP2CS(  6) / +.16965374054383983356062511163756D-6     /
      DATA BIP2CS(  7) / -.10096500865641624301366228396373D-7     /
      DATA BIP2CS(  8) / -.16729119493778475127836973095943D-7     /
      DATA BIP2CS(  9) / -.45815364485068383217152795613391D-8     /
      DATA BIP2CS( 10) / +.37366813665655477274064749384284D-9     /
      DATA BIP2CS( 11) / +.57669303201452448119584643502111D-9     /
      DATA BIP2CS( 12) / +.62181265087850324095393408792371D-10    /
      DATA BIP2CS( 13) / -.63294120282743068241589177281354D-10    /
      DATA BIP2CS( 14) / -.14915047908598767633999091989487D-10    /
      DATA BIP2CS( 15) / +.78896213942486771938172394294891D-11    /
      DATA BIP2CS( 16) / +.24960513721857797984888064000127D-11    /
      DATA BIP2CS( 17) / -.12130075287291659477746664734814D-11    /
      DATA BIP2CS( 18) / -.37404939108727277887343460402716D-12    /
      DATA BIP2CS( 19) / +.22377278140321476798783446931091D-12    /
      DATA BIP2CS( 20) / +.47490296312192466341986077472514D-13    /
      DATA BIP2CS( 21) / -.45261607991821224810605655831294D-13    /
      DATA BIP2CS( 22) / -.30172271841986072645112245876020D-14    /
      DATA BIP2CS( 23) / +.91058603558754058327592683478908D-14    /
      DATA BIP2CS( 24) / -.98149238033807062926643864207709D-15    /
      DATA BIP2CS( 25) / -.16429400647889465253601245251589D-14    /
      DATA BIP2CS( 26) / +.55334834214274215451182114635164D-15    /
      DATA BIP2CS( 27) / +.21750479864482655984374381998156D-15    /
      DATA BIP2CS( 28) / -.17379236200220656971287029558087D-15    /
      DATA BIP2CS( 29) / -.10470023471443714959283909313604D-17    /
      DATA BIP2CS( 30) / +.39219145986056386925441403311462D-16    /
      DATA BIP2CS( 31) / -.11621293686345196925824005665910D-16    /
      DATA BIP2CS( 32) / -.54027474491754245533735411307773D-17    /
      DATA BIP2CS( 33) / +.45441582123884610882675428553304D-17    /
      DATA BIP2CS( 34) / -.28775599625221075729427585480086D-18    /
      DATA BIP2CS( 35) / -.10017340927225341243596162960440D-17    /
      DATA BIP2CS( 36) / +.44823931215068369856332561906313D-18    /
      DATA BIP2CS( 37) / +.76135968654908942328948982366775D-19    /
      DATA BIP2CS( 38) / -.14448324094881347238956060145422D-18    /
      DATA BIP2CS( 39) / +.40460859449205362251624847392112D-19    /
      DATA BIP2CS( 40) / +.20321085700338446891325190707277D-19    /
      DATA BIP2CS( 41) / -.19602795471446798718272758041962D-19    /
      DATA BIP2CS( 42) / +.34273038443944824263518958211738D-20    /
      DATA BIP2CS( 43) / +.37023705853905135480024651593154D-20    /
      DATA BIP2CS( 44) / -.26879595172041591131400332966712D-20    /
      DATA BIP2CS( 45) / +.28121678463531712209714454683364D-21    /
      DATA BIP2CS( 46) / +.60933963636177797173271119680329D-21    /
      DATA BIP2CS( 47) / -.38666621897150844994172977893413D-21    /
      DATA BIP2CS( 48) / +.25989331253566943450895651927228D-22    /
      DATA BIP2CS( 49) / +.97194393622938503767281175216084D-22    /
      DATA BIP2CS( 50) / -.59392817834375098415630478204591D-22    /
      DATA BIP2CS( 51) / +.38864949977113015409591960439444D-23    /
      DATA BIP2CS( 52) / +.15334307393617272869721512868769D-22    /
      DATA BIP2CS( 53) / -.97513555209762624036336521409724D-23    /
      DATA BIP2CS( 54) / +.96340644440489471424741339383726D-24    /
      DATA BIP2CS( 55) / +.23841999400208880109946748792454D-23    /
      DATA BIP2CS( 56) / -.16896986315019706184848044205207D-23    /
      DATA BIP2CS( 57) / +.27352715888928361222578444801478D-24    /
      DATA BIP2CS( 58) / +.35660016185409578960111685025730D-24    /
      DATA BIP2CS( 59) / -.30234026608258827249534280666954D-24    /
      DATA BIP2CS( 60) / +.75002041605973930653144204823232D-25    /
      DATA BIP2CS( 61) / +.48403287575851388827455319838748D-25    /
      DATA BIP2CS( 62) / -.54364137654447888432698010297766D-25    /
      DATA BIP2CS( 63) / +.19281214470820962653345978809756D-25    /
      DATA BIP2CS( 64) / +.50116355020532656659611814172172D-26    /
      DATA BIP2CS( 65) / -.95040744582693253786034620869972D-26    /
      DATA BIP2CS( 66) / +.46372646157101975948696332245611D-26    /
      DATA BIP2CS( 67) / +.21177170704466954163768170577046D-28    /
      DATA BIP2CS( 68) / -.15404850268168594303692204548726D-26    /
      DATA BIP2CS( 69) / +.10387944293201213662047889194441D-26    /
      DATA BIP2CS( 70) / -.19890078156915416751316728235153D-27    /
      DATA BIP2CS( 71) / -.21022173878658495471177044522532D-27    /
      DATA BIP2CS( 72) / +.21353099724525793150633356670491D-27    /
      DATA BIP2CS( 73) / -.79040810747961342319023537632627D-28    /
      DATA BIP2CS( 74) / -.16575359960435585049973741763592D-28    /
      DATA BIP2CS( 75) / +.38868342850124112587625586496537D-28    /
      DATA BIP2CS( 76) / -.22309237330896866182621562424717D-28    /
      DATA BIP2CS( 77) / +.27777244420176260265625977404382D-29    /
      DATA BIP2CS( 78) / +.57078543472657725368712433782772D-29    /
      DATA BIP2CS( 79) / -.51743084445303852800173371555280D-29    /
      DATA BIP2CS( 80) / +.18413280751095837198450927071569D-29    /
      DATA BIP2CS( 81) / +.44422562390957094598544071068647D-30    /
      DATA BIP2CS( 82) / -.98504142639629801547464958226943D-30    /
      DATA BIP2CS( 83) / +.58857201353585104884754198881995D-30    /
      DATA BIP2CS( 84) / -.97636075440429787961402312628595D-31    /
      DATA BIP2CS( 85) / -.13581011996074695047063597884122D-30    /
      DATA BIP2CS( 86) / +.13999743518492413270568048380345D-30    /
      DATA BIP2CS( 87) / -.59754904545248477620884562981118D-31    /
      DATA BIP2CS( 88) / -.40391653875428313641045327529856D-32    /
      DATA ATR / 8.75069057084843450880771988210148D0 /
      DATA BTR / -2.09383632135605431360096498526268D0 /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DBIE
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NBIF = INITDS (BIFCS, 13, ETA)
         NBIG = INITDS (BIGCS, 13, ETA)
         NBIF2 = INITDS (BIF2CS, 15, ETA)
         NBIG2 = INITDS (BIG2CS, 15, ETA)
         NBIP1 = INITDS (BIP1CS, 47, ETA)
         NBIP2 = INITDS (BIP2CS, 88, ETA)
!
         X3SML = ETA**0.3333
         X32SML = 1.3104D0*X3SML**2
         XBIG = D1MACH(2)**0.6666D0
      ENDIF
      FIRST = .FALSE.
!
      IF (X.GE.(-1.0D0)) GO TO 20
      CALL D9AIMP (X, XM, THETA)
      DBIE = XM * SIN(THETA)
      RETURN
!
   20 IF (X.GT.1.0D0) GO TO 30
      Z = 0.D0
      IF (ABS(X).GT.X3SML) Z = X**3
      DBIE = 0.625D0 + DCSEVL (Z, BIFCS, NBIF) + X*(0.4375D0 +          &
        DCSEVL (Z, BIGCS, NBIG) )
      IF (X.GT.X32SML) DBIE = DBIE * EXP(-2.0D0*X*SQRT(X)/3.0D0)
      RETURN
!
   30 IF (X.GT.2.0D0) GO TO 40
      Z = (2.0D0*X**3 - 9.0D0)/7.0D0
      DBIE = EXP(-2.0D0*X*SQRT(X)/3.0D0) * (1.125D0 +                   &
        DCSEVL (Z, BIF2CS, NBIF2) + X*(0.625D0 + DCSEVL (Z, BIG2CS,     &
        NBIG2)) )
      RETURN
!
   40 IF (X.GT.4.0D0) GO TO 50
      SQRTX = SQRT(X)
      Z = ATR/(X*SQRTX) + BTR
      DBIE = (0.625D0 + DCSEVL (Z, BIP1CS, NBIP1))/SQRT(SQRTX)
      RETURN
!
   50 SQRTX = SQRT(X)
      Z = -1.0D0
      IF (X.LT.XBIG) Z = 16.D0/(X*SQRTX) - 1.0D0
      DBIE = (0.625D0 + DCSEVL (Z, BIP2CS, NBIP2))/SQRT(SQRTX)
!
   END
