!DECK DBESI0
   DOUBLE PRECISION FUNCTION DBESI0( X )
!***BEGIN PROLOGUE  DBESI0
!***PURPOSE  Compute the hyperbolic Bessel function of the first kind
!            of order zero.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10B1
!***TYPE      DOUBLE PRECISION (BESI0-S, DBESI0-D)
!***KEYWORDS  FIRST KIND, FNLIB, HYPERBOLIC BESSEL FUNCTION,
!             MODIFIED BESSEL FUNCTION, ORDER ZERO, SPECIAL FUNCTIONS
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DBESI0(X) calculates the double precision modified (hyperbolic)
! Bessel function of the first kind of order zero and double
! precision argument X.
!
! Series for BI0        on the interval  0.          to  9.00000E+00
!                                        with weighted error   9.51E-34
!                                         log weighted error  33.02
!                               significant figures required  33.31
!                                    decimal places required  33.65
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, DBSI0E, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!***END PROLOGUE  DBESI0
      DOUBLE PRECISION X, BI0CS(18), XMAX, XSML, Y
      LOGICAL FIRST
      SAVE BI0CS, NTI0, XSML, XMAX, FIRST
      DATA BI0CS(  1) / -.7660547252839144951081894976243285D-1   /
      DATA BI0CS(  2) / +.1927337953993808269952408750881196D+1   /
      DATA BI0CS(  3) / +.2282644586920301338937029292330415D+0   /
      DATA BI0CS(  4) / +.1304891466707290428079334210691888D-1   /
      DATA BI0CS(  5) / +.4344270900816487451378682681026107D-3   /
      DATA BI0CS(  6) / +.9422657686001934663923171744118766D-5   /
      DATA BI0CS(  7) / +.1434006289510691079962091878179957D-6   /
      DATA BI0CS(  8) / +.1613849069661749069915419719994611D-8   /
      DATA BI0CS(  9) / +.1396650044535669699495092708142522D-10  /
      DATA BI0CS( 10) / +.9579451725505445344627523171893333D-13  /
      DATA BI0CS( 11) / +.5333981859862502131015107744000000D-15  /
      DATA BI0CS( 12) / +.2458716088437470774696785919999999D-17  /
      DATA BI0CS( 13) / +.9535680890248770026944341333333333D-20  /
      DATA BI0CS( 14) / +.3154382039721427336789333333333333D-22  /
      DATA BI0CS( 15) / +.9004564101094637431466666666666666D-25  /
      DATA BI0CS( 16) / +.2240647369123670016000000000000000D-27  /
      DATA BI0CS( 17) / +.4903034603242837333333333333333333D-30  /
      DATA BI0CS( 18) / +.9508172606122666666666666666666666D-33  /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DBESI0
      IF (FIRST) THEN
         NTI0 = INITDS (BI0CS, 18, 0.1*REAL(D1MACH(3)))
         XSML = SQRT(4.5D0*D1MACH(3))
         XMAX = LOG (D1MACH(2))
      ENDIF
      FIRST = .FALSE.
!
      Y = ABS(X)
      IF (Y.GT.3.0D0) GO TO 20
!
      DBESI0 = 1.0D0
      IF (Y.GT.XSML) DBESI0 = 2.75D0 + DCSEVL (Y*Y/4.5D0-1.D0, BI0CS,   &
        NTI0)
      RETURN
!
   20 IF (Y .GT. XMAX) CALL XERMSG ('SLATEC', 'DBESI0',                 &
         'ABS(X) SO BIG I0 OVERFLOWS', 2, 2)
!
      DBESI0 = EXP(Y) * DBSI0E(X)
!
   END
