!DECK DAI
   DOUBLE PRECISION FUNCTION DAI( X )
!***BEGIN PROLOGUE  DAI
!***PURPOSE  Evaluate the Airy function.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10D
!***TYPE      DOUBLE PRECISION (AI-S, DAI-D)
!***KEYWORDS  AIRY FUNCTION, FNLIB, SPECIAL FUNCTIONS
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! DAI(X) calculates the double precision Airy function for double
! precision argument X.
!
! Series for AIF        on the interval -1.00000E+00 to  1.00000E+00
!                                        with weighted error   8.37E-33
!                                         log weighted error  32.08
!                               significant figures required  30.87
!                                    decimal places required  32.63
!
! Series for AIG        on the interval -1.00000E+00 to  1.00000E+00
!                                        with weighted error   7.47E-34
!                                         log weighted error  33.13
!                               significant figures required  31.50
!                                    decimal places required  33.68
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, D9AIMP, DAIE, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!   920618  Removed space from variable names.  (RWC, WRB)
!***END PROLOGUE  DAI
      DOUBLE PRECISION X, AIFCS(13), AIGCS(13), THETA, XM, XMAX, X3SML, &
        Z, XMAXT
      LOGICAL FIRST
      SAVE AIFCS, AIGCS, NAIF, NAIG, X3SML, XMAX, FIRST
      DATA AIFCS(  1) / -.37971358496669997496197089469414D-1     /
      DATA AIFCS(  2) / +.59191888537263638574319728013777D-1     /
      DATA AIFCS(  3) / +.98629280577279975365603891044060D-3     /
      DATA AIFCS(  4) / +.68488438190765667554854830182412D-5     /
      DATA AIFCS(  5) / +.25942025962194713019489279081403D-7     /
      DATA AIFCS(  6) / +.61766127740813750329445749697236D-10    /
      DATA AIFCS(  7) / +.10092454172466117901429556224601D-12    /
      DATA AIFCS(  8) / +.12014792511179938141288033225333D-15    /
      DATA AIFCS(  9) / +.10882945588716991878525295466666D-18    /
      DATA AIFCS( 10) / +.77513772196684887039238400000000D-22    /
      DATA AIFCS( 11) / +.44548112037175638391466666666666D-25    /
      DATA AIFCS( 12) / +.21092845231692343466666666666666D-28    /
      DATA AIFCS( 13) / +.83701735910741333333333333333333D-32    /
      DATA AIGCS(  1) / +.18152365581161273011556209957864D-1     /
      DATA AIGCS(  2) / +.21572563166010755534030638819968D-1     /
      DATA AIGCS(  3) / +.25678356987483249659052428090133D-3     /
      DATA AIGCS(  4) / +.14265214119792403898829496921721D-5     /
      DATA AIGCS(  5) / +.45721149200180426070434097558191D-8     /
      DATA AIGCS(  6) / +.95251708435647098607392278840592D-11    /
      DATA AIGCS(  7) / +.13925634605771399051150420686190D-13    /
      DATA AIGCS(  8) / +.15070999142762379592306991138666D-16    /
      DATA AIGCS(  9) / +.12559148312567778822703205333333D-19    /
      DATA AIGCS( 10) / +.83063073770821340343829333333333D-23    /
      DATA AIGCS( 11) / +.44657538493718567445333333333333D-26    /
      DATA AIGCS( 12) / +.19900855034518869333333333333333D-29    /
      DATA AIGCS( 13) / +.74702885256533333333333333333333D-33    /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  DAI
      IF (FIRST) THEN
         NAIF = INITDS (AIFCS, 13, 0.1*REAL(D1MACH(3)))
         NAIG = INITDS (AIGCS, 13, 0.1*REAL(D1MACH(3)))
!
         X3SML = D1MACH(3)**0.3334D0
         XMAXT = (-1.5D0*LOG(D1MACH(1)))**0.6667D0
         XMAX = XMAXT - XMAXT*LOG(XMAXT)/(4.0D0*SQRT(XMAXT)+1.0D0)      &
                 - 0.01D0
      ENDIF
      FIRST = .FALSE.
!
      IF (X.GE.(-1.D0)) GO TO 20
      CALL D9AIMP (X, XM, THETA)
      DAI = XM * COS(THETA)
      RETURN
!
   20 IF (X.GT.1.0D0) GO TO 30
      Z = 0.0D0
      IF (ABS(X).GT.X3SML) Z = X**3
      DAI = 0.375D0 + (DCSEVL (Z, AIFCS, NAIF) - X*(0.25D0 +            &
        DCSEVL (Z, AIGCS, NAIG)) )
      RETURN
!
   30 IF (X.GT.XMAX) GO TO 40
      DAI = DAIE(X) * EXP(-2.0D0*X*SQRT(X)/3.0D0)
      RETURN
!
   40 DAI = 0.0D0
      CALL XERMSG ('SLATEC', 'DAI', 'X SO BIG AI UNDERFLOWS', 1, 1)
!
   END
