!DECK D9AIMP
   SUBROUTINE D9AIMP( X, AMPL, THETA )
!***BEGIN PROLOGUE  D9AIMP
!***SUBSIDIARY
!***PURPOSE  Evaluate the Airy modulus and phase.
!***LIBRARY   SLATEC (FNLIB)
!***CATEGORY  C10D
!***TYPE      DOUBLE PRECISION (R9AIMP-S, D9AIMP-D)
!***KEYWORDS  AIRY FUNCTION, FNLIB, MODULUS, PHASE, SPECIAL FUNCTIONS
!***AUTHOR  Fullerton, W., (LANL)
!***DESCRIPTION
!
! Evaluate the Airy modulus and phase for X .LE. -1.0
!
! Series for AM20       on the interval -1.56250E-02 to  0.
!                                        with weighted error   3.12E-32
!                                         log weighted error  31.51
!                               significant figures required  29.24
!                                    decimal places required  32.38
!
! Series for ATH0       on the interval -1.56250E-02 to  0.
!                                        with weighted error   2.75E-32
!                                         log weighted error  31.56
!                               significant figures required  30.17
!                                    decimal places required  32.42
!
! Series for AM21       on the interval -1.25000E-01 to -1.56250E-02
!                                        with weighted error   3.40E-32
!                                         log weighted error  31.47
!                               significant figures required  29.02
!                                    decimal places required  32.36
!
! Series for ATH1       on the interval -1.25000E-01 to -1.56250E-02
!                                        with weighted error   2.94E-32
!                                         log weighted error  31.53
!                               significant figures required  30.08
!                                    decimal places required  32.41
!
! Series for AM22       on the interval -1.00000E+00 to -1.25000E-01
!                                        with weighted error   3.76E-32
!                                         log weighted error  31.42
!                               significant figures required  29.47
!                                    decimal places required  32.36
!
! Series for ATH2       on the interval -1.00000E+00 to -1.25000E-01
!                                        with weighted error   4.97E-32
!                                         log weighted error  31.30
!                               significant figures required  29.79
!                                    decimal places required  32.23
!
!***REFERENCES  (NONE)
!***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
!***REVISION HISTORY  (YYMMDD)
!   770701  DATE WRITTEN
!   890531  Changed all specific intrinsics to generic.  (WRB)
!   890531  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
!   900720  Routine changed from user-callable to subsidiary.  (WRB)
!***END PROLOGUE  D9AIMP
      DOUBLE PRECISION X, AMPL, THETA, AM20CS(57), ATH0CS(53),          &
        AM21CS(60), ATH1CS(58), AM22CS(74), ATH2CS(72), PI4, SQRTX,     &
        XSML, Z
      LOGICAL FIRST
      SAVE AM20CS, ATH0CS, AM21CS, ATH1CS, AM22CS, ATH2CS,              &
       PI4, NAM20, NATH0, NAM21, NATH1, NAM22, NATH2, XSML, FIRST
      DATA AM20CS(  1) / +.108716749086561856615730588125D-1 /
      DATA AM20CS(  2) / +.369489228982663555091728665146D-3 /
      DATA AM20CS(  3) / +.440680100484689563667507001327D-5 /
      DATA AM20CS(  4) / +.143686762361911153929183952833D-6 /
      DATA AM20CS(  5) / +.824275552390078308670628855353D-8 /
      DATA AM20CS(  6) / +.684426758893661606173927278180D-9 /
      DATA AM20CS(  7) / +.739566697282739287731004740213D-10 /
      DATA AM20CS(  8) / +.974595633696825017638702600847D-11 /
      DATA AM20CS(  9) / +.150076885829405775650973119497D-11 /
      DATA AM20CS( 10) / +.262147910221527634206252854802D-12 /
      DATA AM20CS( 11) / +.508354111376487180357278966914D-13 /
      DATA AM20CS( 12) / +.107684753358811440492985997070D-13 /
      DATA AM20CS( 13) / +.246091286618433429335914062617D-14 /
      DATA AM20CS( 14) / +.600786380358656418436110373550D-15 /
      DATA AM20CS( 15) / +.155449156102388071150651388384D-15 /
      DATA AM20CS( 16) / +.423535125035576604426382780182D-16 /
      DATA AM20CS( 17) / +.120862166289299840154401109189D-16 /
      DATA AM20CS( 18) / +.359609651214658240861499706423D-17 /
      DATA AM20CS( 19) / +.111134218386395638261774604677D-17 /
      DATA AM20CS( 20) / +.355559532432366609893680289225D-18 /
      DATA AM20CS( 21) / +.117433021600139309998766947387D-18 /
      DATA AM20CS( 22) / +.399397454661077561389162200966D-19 /
      DATA AM20CS( 23) / +.139576671528916310425606325640D-19 /
      DATA AM20CS( 24) / +.500240055309236041393459280716D-20 /
      DATA AM20CS( 25) / +.183552760958132679184834866457D-20 /
      DATA AM20CS( 26) / +.688490998179202743197790112404D-21 /
      DATA AM20CS( 27) / +.263631035611417012359996885105D-21 /
      DATA AM20CS( 28) / +.102924890237338360287153563785D-21 /
      DATA AM20CS( 29) / +.409246966671594885489762960571D-22 /
      DATA AM20CS( 30) / +.165558573406734651039727903828D-22 /
      DATA AM20CS( 31) / +.680797467063033356116599685727D-23 /
      DATA AM20CS( 32) / +.284326559934079832419751134476D-23 /
      DATA AM20CS( 33) / +.120507398348965255097287818819D-23 /
      DATA AM20CS( 34) / +.517961243287505217976613610424D-24 /
      DATA AM20CS( 35) / +.225622613427562816303268640887D-24 /
      DATA AM20CS( 36) / +.995418801147745168832117078246D-25 /
      DATA AM20CS( 37) / +.444551696397342424308280582053D-25 /
      DATA AM20CS( 38) / +.200865195461501101425916097338D-25 /
      DATA AM20CS( 39) / +.917786344151775165973885645402D-26 /
      DATA AM20CS( 40) / +.423872958105589240661672197948D-26 /
      DATA AM20CS( 41) / +.197789272007846092370846251490D-26 /
      DATA AM20CS( 42) / +.932116351284620665680435253373D-27 /
      DATA AM20CS( 43) / +.443482133249918099955611379722D-27 /
      DATA AM20CS( 44) / +.212945672365573895594589552837D-27 /
      DATA AM20CS( 45) / +.103158569651075977552209344907D-27 /
      DATA AM20CS( 46) / +.504023773022591199157904590029D-28 /
      DATA AM20CS( 47) / +.248301304570155945304046541005D-28 /
      DATA AM20CS( 48) / +.123301783128562196054198238560D-28 /
      DATA AM20CS( 49) / +.617033449920521746121976730507D-29 /
      DATA AM20CS( 50) / +.311092617415918897233869792213D-29 /
      DATA AM20CS( 51) / +.157983085201706173015269071503D-29 /
      DATA AM20CS( 52) / +.807931987538283607678121339092D-30 /
      DATA AM20CS( 53) / +.415997394138667562722951360052D-30 /
      DATA AM20CS( 54) / +.215610934097716900471935862504D-30 /
      DATA AM20CS( 55) / +.112468857265869178296752823613D-30 /
      DATA AM20CS( 56) / +.590331560632838091123040811797D-31 /
      DATA AM20CS( 57) / +.311735667692928562046280505333D-31 /
      DATA ATH0CS(  1) / -.8172601764161634499840208700543D-1 /
      DATA ATH0CS(  2) / -.8004012824788273287596481113068D-3 /
      DATA ATH0CS(  3) / -.3186525268782113203795553628242D-5 /
      DATA ATH0CS(  4) / -.6688388266477509330741698865033D-7 /
      DATA ATH0CS(  5) / -.2931759284994564516506822463184D-8 /
      DATA ATH0CS(  6) / -.2011263760883621669049030307186D-9 /
      DATA ATH0CS(  7) / -.1877522678055973426074008166652D-10 /
      DATA ATH0CS(  8) / -.2199637137704601251899002199848D-11 /
      DATA ATH0CS(  9) / -.3071616682592272449025746605586D-12 /
      DATA ATH0CS( 10) / -.4936140553673418361025600985389D-13 /
      DATA ATH0CS( 11) / -.8902833722583660416935236969866D-14 /
      DATA ATH0CS( 12) / -.1768987764615272613656814199467D-14 /
      DATA ATH0CS( 13) / -.3817868689032277014678199609600D-15 /
      DATA ATH0CS( 14) / -.8851159014819947594156286509984D-16 /
      DATA ATH0CS( 15) / -.2184818181414365953149677679568D-16 /
      DATA ATH0CS( 16) / -.5700849046986452380599442295119D-17 /
      DATA ATH0CS( 17) / -.1563121122177875392516031795495D-17 /
      DATA ATH0CS( 18) / -.4481437996768995067906688776353D-18 /
      DATA ATH0CS( 19) / -.1337794883736188022044566044098D-18 /
      DATA ATH0CS( 20) / -.4143340036874114453776852445442D-19 /
      DATA ATH0CS( 21) / -.1327263385718805025080481164652D-19 /
      DATA ATH0CS( 22) / -.4385728589128440522215756835955D-20 /
      DATA ATH0CS( 23) / -.1491360695952818067686201743956D-20 /
      DATA ATH0CS( 24) / -.5208104738630711377154238188773D-21 /
      DATA ATH0CS( 25) / -.1864382222390498923872526604979D-21 /
      DATA ATH0CS( 26) / -.6830263751167969012975435381881D-22 /
      DATA ATH0CS( 27) / -.2557117058029329629296207591347D-22 /
      DATA ATH0CS( 28) / -.9770158640254300218246907254046D-23 /
      DATA ATH0CS( 29) / -.3805161433416679084068428254886D-23 /
      DATA ATH0CS( 30) / -.1509022750737054063493926482995D-23 /
      DATA ATH0CS( 31) / -.6087551341242424929005568014525D-24 /
      DATA ATH0CS( 32) / -.2495879513809711495425982124058D-24 /
      DATA ATH0CS( 33) / -.1039157654581920948909588084274D-24 /
      DATA ATH0CS( 34) / -.4390235913976846536974594969051D-25 /
      DATA ATH0CS( 35) / -.1880790678447990211675826820582D-25 /
      DATA ATH0CS( 36) / -.8165070764199462948863022205753D-26 /
      DATA ATH0CS( 37) / -.3589944503749750514266435585041D-26 /
      DATA ATH0CS( 38) / -.1597658126632132872981291608708D-26 /
      DATA ATH0CS( 39) / -.7193250175703823969113802835305D-27 /
      DATA ATH0CS( 40) / -.3274943012727856506209351132721D-27 /
      DATA ATH0CS( 41) / -.1507042445783690665816975047272D-27 /
      DATA ATH0CS( 42) / -.7006624198319904717843967949140D-28 /
      DATA ATH0CS( 43) / -.3289907402983718226528815678356D-28 /
      DATA ATH0CS( 44) / -.1559518084365146526445322711496D-28 /
      DATA ATH0CS( 45) / -.7460690508208254582833851119721D-29 /
      DATA ATH0CS( 46) / -.3600877034824662020563277249431D-29 /
      DATA ATH0CS( 47) / -.1752851437473772257350402219197D-29 /
      DATA ATH0CS( 48) / -.8603275775188512909623778628724D-30 /
      DATA ATH0CS( 49) / -.4256432603226946534668039480105D-30 /
      DATA ATH0CS( 50) / -.2122161865044262927723650698206D-30 /
      DATA ATH0CS( 51) / -.1065996156704879052472060798561D-30 /
      DATA ATH0CS( 52) / -.5393568608816949116410688086892D-31 /
      DATA ATH0CS( 53) / -.2748174851043954822278496517870D-31 /
      DATA AM21CS(  1) / +.592790266721309588375717482814D-2 /
      DATA AM21CS(  2) / +.200569405393165186428695217690D-2 /
      DATA AM21CS(  3) / +.911081850262275893553072526291D-4 /
      DATA AM21CS(  4) / +.849894306372047155633172107475D-5 /
      DATA AM21CS(  5) / +.113297908976913076637929215494D-5 /
      DATA AM21CS(  6) / +.187517946100666496180950627804D-6 /
      DATA AM21CS(  7) / +.359306519018245832699035211192D-7 /
      DATA AM21CS(  8) / +.765757714071683864039093517470D-8 /
      DATA AM21CS(  9) / +.176999967168039173925953460744D-8 /
      DATA AM21CS( 10) / +.436259555654598932720546585535D-9 /
      DATA AM21CS( 11) / +.113291641337853230035520085219D-9 /
      DATA AM21CS( 12) / +.307257690982419244137868398126D-10 /
      DATA AM21CS( 13) / +.864482416482201075541200465766D-11 /
      DATA AM21CS( 14) / +.251015250060924402115104562212D-11 /
      DATA AM21CS( 15) / +.749102496764440371601802227751D-12 /
      DATA AM21CS( 16) / +.228996928487994073089565214432D-12 /
      DATA AM21CS( 17) / +.715113658927987694949327491175D-13 /
      DATA AM21CS( 18) / +.227607924959566841946395165061D-13 /
      DATA AM21CS( 19) / +.736942142760886513969953227782D-14 /
      DATA AM21CS( 20) / +.242328675267827490463991742006D-14 /
      DATA AM21CS( 21) / +.808153774548239869283406558403D-15 /
      DATA AM21CS( 22) / +.273008079804356086659174563386D-15 /
      DATA AM21CS( 23) / +.933236070891385318473519474326D-16 /
      DATA AM21CS( 24) / +.322508099681084622213867546973D-16 /
      DATA AM21CS( 25) / +.112581932346444541217757573416D-16 /
      DATA AM21CS( 26) / +.396699463986938821660259459530D-17 /
      DATA AM21CS( 27) / +.141006567944319504660865034527D-17 /
      DATA AM21CS( 28) / +.505302086537851213375537393032D-18 /
      DATA AM21CS( 29) / +.182461523215945141197999102789D-18 /
      DATA AM21CS( 30) / +.663584568262130466928029121642D-19 /
      DATA AM21CS( 31) / +.242963731631276179741747455826D-19 /
      DATA AM21CS( 32) / +.895238915123687802013669922963D-20 /
      DATA AM21CS( 33) / +.331845289350050791260229250755D-20 /
      DATA AM21CS( 34) / +.123706196188658315384437905922D-20 /
      DATA AM21CS( 35) / +.463636677012390840306767734243D-21 /
      DATA AM21CS( 36) / +.174653135947764475469758765989D-21 /
      DATA AM21CS( 37) / +.661116810234991176307910643111D-22 /
      DATA AM21CS( 38) / +.251409918994072486176125666459D-22 /
      DATA AM21CS( 39) / +.960274995571732568694034386998D-23 /
      DATA AM21CS( 40) / +.368324952289296395686436898078D-23 /
      DATA AM21CS( 41) / +.141843138269159136145535939553D-23 /
      DATA AM21CS( 42) / +.548342674276935830106345800990D-24 /
      DATA AM21CS( 43) / +.212761054623118806650372562616D-24 /
      DATA AM21CS( 44) / +.828443700849418591487734760953D-25 /
      DATA AM21CS( 45) / +.323670563926127001421028600927D-25 /
      DATA AM21CS( 46) / +.126868882963286057355055062493D-25 /
      DATA AM21CS( 47) / +.498843818992121626935068934362D-26 /
      DATA AM21CS( 48) / +.196734584467649390967119381790D-26 /
      DATA AM21CS( 49) / +.778135971020326957713212064836D-27 /
      DATA AM21CS( 50) / +.308633941498911152919192968451D-27 /
      DATA AM21CS( 51) / +.122744647045453119789338037234D-27 /
      DATA AM21CS( 52) / +.489431279134292205885241216204D-28 /
      DATA AM21CS( 53) / +.195646879802909821175925099724D-28 /
      DATA AM21CS( 54) / +.783988952922426171166311492266D-29 /
      DATA AM21CS( 55) / +.314896914002484223748298978099D-29 /
      DATA AM21CS( 56) / +.126769763137250681307067842559D-29 /
      DATA AM21CS( 57) / +.511470691906900141641632107724D-30 /
      DATA AM21CS( 58) / +.206801709795538770250900316706D-30 /
      DATA AM21CS( 59) / +.837891344768519001325996867583D-31 /
      DATA AM21CS( 60) / +.340168991971489802052339079577D-31 /
      DATA ATH1CS(  1) / -.6972849916208883845888148415037D-1 /
      DATA ATH1CS(  2) / -.5108722790650044987073448077961D-2 /
      DATA ATH1CS(  3) / -.8644335996989755094525334749512D-4 /
      DATA ATH1CS(  4) / -.5604720044235263542188698916125D-5 /
      DATA ATH1CS(  5) / -.6045735125623897409156376640077D-6 /
      DATA ATH1CS(  6) / -.8639802632488334393219721138499D-7 /
      DATA ATH1CS(  7) / -.1480809484309927157147782480780D-7 /
      DATA ATH1CS(  8) / -.2885809334577236039999449908712D-8 /
      DATA ATH1CS(  9) / -.6191631975665699609309191231800D-9 /
      DATA ATH1CS( 10) / -.1431992808860957830931365259879D-9 /
      DATA ATH1CS( 11) / -.3518141102137214721504616874321D-10 /
      DATA ATH1CS( 12) / -.9084761919955078290070339808051D-11 /
      DATA ATH1CS( 13) / -.2446171672688598449343283664767D-11 /
      DATA ATH1CS( 14) / -.6826083203213446240828996710264D-12 /
      DATA ATH1CS( 15) / -.1964579931194940171278546257802D-12 /
      DATA ATH1CS( 16) / -.5808933227139693164009191265856D-13 /
      DATA ATH1CS( 17) / -.1759042249527441992795400959024D-13 /
      DATA ATH1CS( 18) / -.5440902932714896613632538945319D-14 /
      DATA ATH1CS( 19) / -.1715247407486806802622358519451D-14 /
      DATA ATH1CS( 20) / -.5500929233576991546871101847161D-15 /
      DATA ATH1CS( 21) / -.1791878287739317259495152638754D-15 /
      DATA ATH1CS( 22) / -.5920372520086694197778411062231D-16 /
      DATA ATH1CS( 23) / -.1981713027876483962470972206590D-16 /
      DATA ATH1CS( 24) / -.6713232347016352262049984343790D-17 /
      DATA ATH1CS( 25) / -.2299450243658281116122358619832D-17 /
      DATA ATH1CS( 26) / -.7957300928236376595304637145634D-18 /
      DATA ATH1CS( 27) / -.2779994027291784157172290233739D-18 /
      DATA ATH1CS( 28) / -.9798924361326985224406795480814D-19 /
      DATA ATH1CS( 29) / -.3482717006061574386702645565849D-19 /
      DATA ATH1CS( 30) / -.1247489122558599057173300058084D-19 /
      DATA ATH1CS( 31) / -.4501210041478228113487751824452D-20 /
      DATA ATH1CS( 32) / -.1635346244013352135596114164667D-20 /
      DATA ATH1CS( 33) / -.5980102897780336268098762265941D-21 /
      DATA ATH1CS( 34) / -.2200246286286123454028196295475D-21 /
      DATA ATH1CS( 35) / -.8142463073515085897408205291519D-22 /
      DATA ATH1CS( 36) / -.3029924773660042537432330709674D-22 /
      DATA ATH1CS( 37) / -.1133390098574623537722943969689D-22 /
      DATA ATH1CS( 38) / -.4260766024749295719283049889791D-23 /
      DATA ATH1CS( 39) / -.1609363396278189718797500634453D-23 /
      DATA ATH1CS( 40) / -.6106377190825026293045330444287D-24 /
      DATA ATH1CS( 41) / -.2326954318021694061836577887573D-24 /
      DATA ATH1CS( 42) / -.8903987877472252604474129558186D-25 /
      DATA ATH1CS( 43) / -.3420558530005675024117914752341D-25 /
      DATA ATH1CS( 44) / -.1319026715257272659017212100607D-25 /
      DATA ATH1CS( 45) / -.5104899493612043091316191177386D-26 /
      DATA ATH1CS( 46) / -.1982599478474547451242444663466D-26 /
      DATA ATH1CS( 47) / -.7725702356880830535636111851519D-27 /
      DATA ATH1CS( 48) / -.3020234733664680100815776863573D-27 /
      DATA ATH1CS( 49) / -.1184379739074169993712946380800D-27 /
      DATA ATH1CS( 50) / -.4658430227922308520573252840106D-28 /
      DATA ATH1CS( 51) / -.1837554188100384647157502006613D-28 /
      DATA ATH1CS( 52) / -.7268566894427990953321876684800D-29 /
      DATA ATH1CS( 53) / -.2882863120391468135527089875626D-29 /
      DATA ATH1CS( 54) / -.1146374629459906350417591664639D-29 /
      DATA ATH1CS( 55) / -.4570031437748533058179991688533D-30 /
      DATA ATH1CS( 56) / -.1826276602045346104809934028799D-30 /
      DATA ATH1CS( 57) / -.7315349993385250469111066350933D-31 /
      DATA ATH1CS( 58) / -.2936925599971429781637815773866D-31 /
      DATA AM22CS(  1) / -.156284448062534112753545828583D-1 /
      DATA AM22CS(  2) / +.778336445239681307018943100334D-2 /
      DATA AM22CS(  3) / +.867057770477189528406072812110D-3 /
      DATA AM22CS(  4) / +.156966273156113719469953482266D-3 /
      DATA AM22CS(  5) / +.356396257143286511324100666302D-4 /
      DATA AM22CS(  6) / +.924598335425043154495080090994D-5 /
      DATA AM22CS(  7) / +.262110161850422389523194982066D-5 /
      DATA AM22CS(  8) / +.791882216516012561489469982263D-6 /
      DATA AM22CS(  9) / +.251041527921011847803162690862D-6 /
      DATA AM22CS( 10) / +.826522320665407734472997712940D-7 /
      DATA AM22CS( 11) / +.280571166281305264396384290014D-7 /
      DATA AM22CS( 12) / +.976821090484680786674631273890D-8 /
      DATA AM22CS( 13) / +.347407923227710343287279035573D-8 /
      DATA AM22CS( 14) / +.125828132169836914219092738164D-8 /
      DATA AM22CS( 15) / +.462988260641895264497330784625D-9 /
      DATA AM22CS( 16) / +.172728258813604072468143128696D-9 /
      DATA AM22CS( 17) / +.652319200131154135148574124970D-10 /
      DATA AM22CS( 18) / +.249047168520982056019881087112D-10 /
      DATA AM22CS( 19) / +.960156820553765948078189890126D-11 /
      DATA AM22CS( 20) / +.373448002067726856974776596757D-11 /
      DATA AM22CS( 21) / +.146417565032053391722216189678D-11 /
      DATA AM22CS( 22) / +.578265471168512825475827881553D-12 /
      DATA AM22CS( 23) / +.229915407244706118560254184494D-12 /
      DATA AM22CS( 24) / +.919780711231997257150883662365D-13 /
      DATA AM22CS( 25) / +.370060068813090065807504045556D-13 /
      DATA AM22CS( 26) / +.149675761698672987823326345205D-13 /
      DATA AM22CS( 27) / +.608361194938461148720451399443D-14 /
      DATA AM22CS( 28) / +.248404087115121397635425326873D-14 /
      DATA AM22CS( 29) / +.101862476526769080727914465339D-14 /
      DATA AM22CS( 30) / +.419383856352753989429640310957D-15 /
      DATA AM22CS( 31) / +.173318901762930756149702493501D-15 /
      DATA AM22CS( 32) / +.718821902388508517820445406811D-16 /
      DATA AM22CS( 33) / +.299123633598403607712470896113D-16 /
      DATA AM22CS( 34) / +.124868990433238627855713110880D-16 /
      DATA AM22CS( 35) / +.522829344609483661928651193632D-17 /
      DATA AM22CS( 36) / +.219532961724713396595998454359D-17 /
      DATA AM22CS( 37) / +.924298325229777281154410024332D-18 /
      DATA AM22CS( 38) / +.390157708236091407825543197309D-18 /
      DATA AM22CS( 39) / +.165093892693863707213759030367D-18 /
      DATA AM22CS( 40) / +.700221815715994367565716554487D-19 /
      DATA AM22CS( 41) / +.297651833616786915573214963506D-19 /
      DATA AM22CS( 42) / +.126796539086902072571134261229D-19 /
      DATA AM22CS( 43) / +.541243400697077628687581725061D-20 /
      DATA AM22CS( 44) / +.231487350218155252296382133283D-20 /
      DATA AM22CS( 45) / +.991920288386566563462623851167D-21 /
      DATA AM22CS( 46) / +.425803015323732357158897608174D-21 /
      DATA AM22CS( 47) / +.183101842973024501678402003088D-21 /
      DATA AM22CS( 48) / +.788678712311075375564526811022D-22 /
      DATA AM22CS( 49) / +.340254607386229874956582997235D-22 /
      DATA AM22CS( 50) / +.147020881405712530791860892535D-22 /
      DATA AM22CS( 51) / +.636211018324916957733348071767D-23 /
      DATA AM22CS( 52) / +.275707050680980721919395987768D-23 /
      DATA AM22CS( 53) / +.119645858090104071356261780457D-23 /
      DATA AM22CS( 54) / +.519912545729242147981768210567D-24 /
      DATA AM22CS( 55) / +.226217674847104475260575286850D-24 /
      DATA AM22CS( 56) / +.985526113754431819448565068283D-25 /
      DATA AM22CS( 57) / +.429870630332508717223681286187D-25 /
      DATA AM22CS( 58) / +.187723641661580639829657670189D-25 /
      DATA AM22CS( 59) / +.820721941772842137268801052115D-26 /
      DATA AM22CS( 60) / +.359214665604615507812767944463D-26 /
      DATA AM22CS( 61) / +.157390594612773315611458940587D-26 /
      DATA AM22CS( 62) / +.690329781039333834965319153586D-27 /
      DATA AM22CS( 63) / +.303092079078968534607859331415D-27 /
      DATA AM22CS( 64) / +.133204934160481219185689121944D-27 /
      DATA AM22CS( 65) / +.585978836851523490117937981442D-28 /
      DATA AM22CS( 66) / +.258016868489487806338425080457D-28 /
      DATA AM22CS( 67) / +.113712433637283667223632182863D-28 /
      DATA AM22CS( 68) / +.501592557226068509236430548549D-29 /
      DATA AM22CS( 69) / +.221445829395509373322569708484D-29 /
      DATA AM22CS( 70) / +.978470283886507289984691416411D-30 /
      DATA AM22CS( 71) / +.432695414934180170112000952983D-30 /
      DATA AM22CS( 72) / +.191497288193994570612929860440D-30 /
      DATA AM22CS( 73) / +.848164622402392354171298331562D-31 /
      DATA AM22CS( 74) / +.375947065173955919947455052934D-31 /
      DATA ATH2CS(  1) / +.4405273458718778997061127057775D-2 /
      DATA ATH2CS(  2) / -.3042919452318454608483844239873D-1 /
      DATA ATH2CS(  3) / -.1385653283771793791602692842653D-2 /
      DATA ATH2CS(  4) / -.1804443908954952302670486910952D-3 /
      DATA ATH2CS(  5) / -.3380847108327308671057465323618D-4 /
      DATA ATH2CS(  6) / -.7678183535229023055257676817765D-5 /
      DATA ATH2CS(  7) / -.1967839443716035324690935417077D-5 /
      DATA ATH2CS(  8) / -.5483727115877700361586143659281D-6 /
      DATA ATH2CS(  9) / -.1625461550532612452712696212258D-6 /
      DATA ATH2CS( 10) / -.5053049981268895015277637842078D-7 /
      DATA ATH2CS( 11) / -.1631580701124066881183851715617D-7 /
      DATA ATH2CS( 12) / -.5434204112348517507963436694817D-8 /
      DATA ATH2CS( 13) / -.1857398556409900325763850109630D-8 /
      DATA ATH2CS( 14) / -.6489512033326108816213513640676D-9 /
      DATA ATH2CS( 15) / -.2310594885800944720482995987079D-9 /
      DATA ATH2CS( 16) / -.8363282183204411682819329546745D-10 /
      DATA ATH2CS( 17) / -.3071196844890191462660661303891D-10 /
      DATA ATH2CS( 18) / -.1142367142432716819409514579892D-10 /
      DATA ATH2CS( 19) / -.4298116066345803065822470108971D-11 /
      DATA ATH2CS( 20) / -.1633898699596715440601646086632D-11 /
      DATA ATH2CS( 21) / -.6269328620016619432123443754076D-12 /
      DATA ATH2CS( 22) / -.2426052694816257357356159203991D-12 /
      DATA ATH2CS( 23) / -.9461198321624039090742527765052D-13 /
      DATA ATH2CS( 24) / -.3716060313411504806847798281269D-13 /
      DATA ATH2CS( 25) / -.1469155684097526763170138810309D-13 /
      DATA ATH2CS( 26) / -.5843694726140911944556401363094D-14 /
      DATA ATH2CS( 27) / -.2337502595591951298832675034934D-14 /
      DATA ATH2CS( 28) / -.9399231371171435401160167358411D-15 /
      DATA ATH2CS( 29) / -.3798014669372894500076335263715D-15 /
      DATA ATH2CS( 30) / -.1541731043984972524883443681775D-15 /
      DATA ATH2CS( 31) / -.6285287079535307162925662365202D-16 /
      DATA ATH2CS( 32) / -.2572731812811455424755383992774D-16 /
      DATA ATH2CS( 33) / -.1057098119354017809340974866555D-16 /
      DATA ATH2CS( 34) / -.4359080267402696966695992699964D-17 /
      DATA ATH2CS( 35) / -.1803634315959978013953176945540D-17 /
      DATA ATH2CS( 36) / -.7486838064380536821719431676914D-18 /
      DATA ATH2CS( 37) / -.3117261367347604656799597209985D-18 /
      DATA ATH2CS( 38) / -.1301687980927700734792871620696D-18 /
      DATA ATH2CS( 39) / -.5450527587519522468973883909909D-19 /
      DATA ATH2CS( 40) / -.2288293490114231872268635931903D-19 /
      DATA ATH2CS( 41) / -.9631059503829538655655060440088D-20 /
      DATA ATH2CS( 42) / -.4063281001524614089092195416434D-20 /
      DATA ATH2CS( 43) / -.1718203980908026763900413858510D-20 /
      DATA ATH2CS( 44) / -.7281574619892536367415322473328D-21 /
      DATA ATH2CS( 45) / -.3092352652680643127960680345790D-21 /
      DATA ATH2CS( 46) / -.1315917855965440490383417023254D-21 /
      DATA ATH2CS( 47) / -.5610606786087055512664907412668D-22 /
      DATA ATH2CS( 48) / -.2396621894086355206020304337895D-22 /
      DATA ATH2CS( 49) / -.1025574332390581200832954423924D-22 /
      DATA ATH2CS( 50) / -.4396264138143656476403607323663D-23 /
      DATA ATH2CS( 51) / -.1887652998372577373342508719450D-23 /
      DATA ATH2CS( 52) / -.8118140359576807603579433230445D-24 /
      DATA ATH2CS( 53) / -.3496734274366286856375952089214D-24 /
      DATA ATH2CS( 54) / -.1508402925156873215171751475867D-24 /
      DATA ATH2CS( 55) / -.6516268284778671059787773834341D-25 /
      DATA ATH2CS( 56) / -.2818945797529207424505942114583D-25 /
      DATA ATH2CS( 57) / -.1221127596512262744598094464505D-25 /
      DATA ATH2CS( 58) / -.5296674341169867168620011705073D-26 /
      DATA ATH2CS( 59) / -.2300359270773673431358870971744D-26 /
      DATA ATH2CS( 60) / -.1000279482355367494781220348930D-26 /
      DATA ATH2CS( 61) / -.4354760404180879394806893162179D-27 /
      DATA ATH2CS( 62) / -.1898056134741477522515482827030D-27 /
      DATA ATH2CS( 63) / -.8282111868712974697554009309315D-28 /
      DATA ATH2CS( 64) / -.3617815493066569006586213484374D-28 /
      DATA ATH2CS( 65) / -.1582018896178003654858941843636D-28 /
      DATA ATH2CS( 66) / -.6925068597802270011772820383247D-29 /
      DATA ATH2CS( 67) / -.3034390239778629128908629727335D-29 /
      DATA ATH2CS( 68) / -.1330889568166725224761977446509D-29 /
      DATA ATH2CS( 69) / -.5842848522173090120487606971706D-30 /
      DATA ATH2CS( 70) / -.2567488423238302631121274357678D-30 /
      DATA ATH2CS( 71) / -.1129232322268882185791505819151D-30 /
      DATA ATH2CS( 72) / -.4970947029753336916550570105023D-31 /
      DATA PI4 / 0.78539816339744830961566084581988D0 /
      DATA FIRST /.TRUE./
!***FIRST EXECUTABLE STATEMENT  D9AIMP
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NAM20 = INITDS (AM20CS, 57, ETA)
         NATH0 = INITDS (ATH0CS, 53, ETA)
         NAM21 = INITDS (AM21CS, 60, ETA)
         NATH1 = INITDS (ATH1CS, 58, ETA)
         NAM22 = INITDS (AM22CS, 74, ETA)
         NATH2 = INITDS (ATH2CS, 72, ETA)
!
         XSML = -1.0D0/D1MACH(3)**0.3333D0
      ENDIF
      FIRST = .FALSE.
!
      IF (X.GE.(-4.0D0)) GO TO 20
      Z = 1.0D0
      IF (X.GT.XSML) Z = 128.D0/X**3 + 1.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM20CS, NAM20)
      THETA = -0.625D0 + DCSEVL (Z, ATH0CS, NATH0)
      GO TO 40
!
   20 IF (X.GE.(-2.0D0)) GO TO 30
      Z = (128.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM21CS, NAM21)
      THETA = -0.625D0 + DCSEVL (Z, ATH1CS, NATH1)
      GO TO 40
!
   30 IF (X .GE. (-1.0D0)) CALL XERMSG ('SLATEC', 'D9AIMP',             &
         'X MUST BE LE -1.0', 1, 2)
!
      Z = (16.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM22CS, NAM22)
      THETA = -0.625D0 + DCSEVL (Z, ATH2CS, NATH2)
!
   40 SQRTX = SQRT(-X)
      AMPL = SQRT(AMPL/SQRTX)
      THETA = PI4 - X*SQRTX*THETA
!
   END
