!DECK D1MACH

   double precision function D1MACH( i )

      implicit none

      integer, intent(in) :: i

!***BEGIN PROLOGUE  D1MACH
!***PURPOSE  Return floating point machine dependent constants.
!***LIBRARY   SLATEC
!***CATEGORY  R1
!***TYPE      DOUBLE PRECISION (R1MACH-S, D1MACH-D)
!***KEYWORDS  MACHINE CONSTANTS
!***AUTHOR  Fox, P. A., (Bell Labs)
!           Hall, A. D., (Bell Labs)
!           Schryer, N. L., (Bell Labs)
!***DESCRIPTION
!
!   D1MACH can be used to obtain machine-dependent parameters for the
!   local machine environment.  It is a function subprogram with one
!   (input) argument, and can be referenced as follows:
!
!        D = D1MACH(I)
!
!   where I=1,...,5.  The (output) value of D above is determined by
!   the (input) value of I.  The results for various values of I are
!   discussed below.
!
!   D1MACH( 1) = B**(EMIN-1), the smallest positive magnitude.
!   D1MACH( 2) = B**EMAX*(1 - B**(-T)), the largest magnitude.
!   D1MACH( 3) = B**(-T), the smallest relative spacing.
!   D1MACH( 4) = B**(1-T), the largest relative spacing.
!   D1MACH( 5) = LOG10(B)
!
!***END PROLOGUE  D1MACH

      external dlamch
      double precision dmach(5), dlamch
      integer iflag

      save dmach, iflag
      data iflag /0/

      if( i < 1 .or. 5 < i ) then
         call XERMSG ('SLATEC', 'D1MACH', 'I OUT OF BOUNDS', 1, 2)
      end if

      if( iflag == 0 ) then

         dmach(1) = dlamch('u')
         dmach(2) = dlamch('o')
         dmach(3) = dlamch('e')
         dmach(4) = dlamch('p')
         dmach(5) = dlamch('b')
         dmach(5) = log10(dmach(5))

         iflag = 1
      end if

      d1mach = dmach(i)

   end
