! f90 include file

! From GNU Octave 4.0.0
!
! This source file comes from RANDLIB, and has been modified (i.e. fixed)
! by JJV.
!
! Then it has been converted to Fortran free format, and adapted to double
! precision.
!
! It is included by mod_elmat.F90
! It calls rng_rand_u01(), rand_exp() and randn(), all already provided by
! Muesli.

      integer function ignpoi(mu)
!**********************************************************************
!
!                    GENerate POIsson random deviate
!
!                              Function
!
!     Generates a single random deviate from a Poisson
!     distribution with mean MU.
!
!                              Arguments
!
!     MU --> The mean of the Poisson distribution from which
!            a random deviate is to be generated.
!                              REAL MU
!     JJV                    (MU >= 0.0)
!
!     IGNPOI <-- The random deviate.
!                              INTEGER IGNPOI (non-negative)
!
!                              Method
!
!     Renames KPOIS from TOMS as slightly modified by BWB to use RANF
!     instead of SUNIF.
!
!     For details see:
!
!               Ahrens, J.H. and Dieter, U.
!               Computer Generation of Poisson Deviates
!               From Modified Normal Distributions.
!               ACM Trans. Math. Software, 8, 2
!               (June 1982),163-179
!
!**********************************************************************
!**********************************************************************
!
!     P O I S S O N  DISTRIBUTION
!
!**********************************************************************
!**********************************************************************
!
!     FOR DETAILS SEE:
!
!               AHRENS, J.H. AND DIETER, U.
!               COMPUTER GENERATION OF POISSON DEVIATES
!               FROM MODIFIED NORMAL DISTRIBUTIONS.
!               ACM TRANS. MATH. SOFTWARE, 8,2 (JUNE 1982), 163 - 179.
!
!     (SLIGHTLY MODIFIED VERSION OF THE PROGRAM IN THE ABOVE ARTICLE)
!
!**********************************************************************
!
!      INTEGER FUNCTION IGNPOI(IR,MU)
!
!     INPUT:  IR=CURRENT STATE OF BASIC RANDOM NUMBER GENERATOR
!             MU=MEAN MU OF THE POISSON DISTRIBUTION
!     OUTPUT: IGNPOI=SAMPLE FROM THE POISSON-(MU)-DISTRIBUTION
!
!     MUPREV=PREVIOUS MU, MUOLD=MU AT LAST EXECUTION OF STEP P OR CASE B
!     TABLES: COEFFICIENTS A0-A7 FOR STEP F. FACTORIALS FACT
!     COEFFICIENTS A(K) - FOR PX = FK*V*V*SUM(A(K)*V**K)-DEL
!
!     SEPARATION OF CASES A AND B
!
!     .. Scalar Arguments ..
      double precision, intent(in) :: mu
!     ..
!     .. Local Scalars ..
      REAL :: a0, a1, a2, a3, a4, a5, a6, a7, b1, b2, c, c0, c1, c2,    &
              c3, d, del, difmuk, e, fk, fx, fy, g, omega, p, p0, px,   &
              py, q, s, t, v, x, xx
      double precision :: muold, muprev, u
!     JJV I added a variable 'll' here - it is the 'l' for CASE A
      INTEGER :: j, k, kflag, l, ll, m
!     ..
!     .. Local Arrays ..
      REAL ::fact(10), pp(35)
!     ..
!     .. Intrinsic Functions ..
      INTRINSIC abs,alog,exp,float,ifix,max0,min0,sign,sqrt
!     ..
!     JJV added this for case: mu unchanged
!     .. Save statement ..
      SAVE :: s, d, l, ll, omega, c3, c2, c1, c0, c, m, p, q, p0,       &
              a0, a1, a2, a3, a4, a5, a6, a7, fact, pp, muprev, muold
!     ..
!     JJV end addition - I am including vars in Data statements
!     .. Data statements ..
!     JJV changed initial values of MUPREV and MUOLD to -1.0E37
!     JJV if no one calls IGNPOI with MU = -1.0E37 the first time,
!     JJV the code shouldn't break
      DATA muprev, muold/ -1.0d0,-1.0d0/
      DATA a0,a1,a2,a3,a4,a5,a6,a7/-.5,.3333333,-.2500068,.2000118,     &
           -.1661269,.1421878,-.1384794,.1250060/
      DATA fact/1.,1.,2.,6.,24.,120.,720.,5040.,40320.,362880./
      DATA pp/35*0.0/
!     ..
!     .. Executable Statements ..

      IF( mu == muprev ) go to 10
      IF( mu < 10.0d0 ) go to 120
!
!     C A S E  A. (RECALCULATION OF S,D,LL IF MU HAS CHANGED)
!
!     JJV This is the case where I changed 'l' to 'll'
!     JJV Here 'll' is set once and used in a comparison once

      muprev = mu
      s = sqrt(mu)
      d = 6.0*mu**2
!
!             THE POISSON PROBABILITIES PK EXCEED THE DISCRETE NORMAL
!             PROBABILITIES FK WHENEVER K >= M(MU). LL=IFIX(MU-1.1484)
!             IS AN UPPER BOUND TO M(MU) FOR ALL MU >= 10 .
!
      ll = ifix(real(mu)-1.1484)
!
!     STEP N. NORMAL SAMPLE - SNORM(IR) FOR STANDARD NORMAL DEVIATE
!
   10 g = mu + s*randn()
      IF( g < 0.0 ) go to 20
      ignpoi = ifix(g)
!
!     STEP I. IMMEDIATE ACCEPTANCE IF IGNPOI IS LARGE ENOUGH
!
      IF( ignpoi >= ll ) RETURN
!
!     STEP S. SQUEEZE ACCEPTANCE - SUNIF(IR) FOR (0,1)-SAMPLE U
!
      fk = float(ignpoi)
      difmuk = mu - fk
      CALL rng_rand_u01( Rng_Stream_g_addr, u )
      IF( d*u >= difmuk**3 ) RETURN
!
!     STEP P. PREPARATIONS FOR STEPS Q AND H.
!             (RECALCULATIONS OF PARAMETERS IF NECESSARY)
!             .3989423=(2*PI)**(-.5)  .416667E-1=1./24.  .1428571=1./7.
!             THE QUANTITIES B1, B2, C3, C2, C1, C0 ARE FOR THE HERMITE
!             APPROXIMATIONS TO THE DISCRETE NORMAL PROBABILITIES FK.
!             C=.1069/MU GUARANTEES MAJORIZATION BY THE 'HAT'-FUNCTION.
!
   20 IF( mu == muold ) go to 30
      muold = mu
      omega = .3989423/s
      b1 = .4166667e-1/mu
      b2 = .3*b1*b1
      c3 = .1428571*b1*b2
      c2 = b2 - 15.*c3
      c1 = b1 - 6.*b2 + 45.*c3
      c0 = 1. - b1 + 3.*b2 - 15.*c3
      c = .1069/mu
   30 IF( g < 0.0 ) go to 50
!
!             'SUBROUTINE' F IS CALLED (KFLAG=0 FOR CORRECT RETURN)
!
      kflag = 0
      go to 70
!
!     STEP Q. QUOTIENT ACCEPTANCE (RARE CASE)
!
   40 IF( fy-u*fy <= py*exp(px-fx) ) RETURN
!
!     STEP E. EXPONENTIAL SAMPLE - SEXPO(IR) FOR STANDARD EXPONENTIAL
!             DEVIATE E AND SAMPLE T FROM THE LAPLACE 'HAT'
!             (IF T <= -.6744 THEN PK < FK FOR ALL MU >= 10.)
!
   50 e = rand_exp()
      CALL rng_rand_u01( Rng_Stream_g_addr, u )
      u = 2*u - 1.0
      t = 1.8 + sign(e,real(u))
      IF( t <= -.6744 ) go to 50
      ignpoi = ifix(real(mu)+s*t)
      fk = float(ignpoi)
      difmuk = mu - fk
!
!             'SUBROUTINE' F IS CALLED (KFLAG=1 FOR CORRECT RETURN)
!
      kflag = 1
      go to 70
!
!     STEP H. HAT ACCEPTANCE (E IS REPEATED ON REJECTION)
!
   60 IF( c*abs(u) > py*exp(px+e)-fy*exp(fx+e) ) go to 50
      RETURN
!
!     STEP F. 'SUBROUTINE' F. CALCULATION OF PX,PY,FX,FY.
!             CASE IGNPOI .LT. 10 USES FACTORIALS FROM TABLE FACT
!
   70 IF( ignpoi >= 10 ) go to 80
      px = -mu
      py = mu**ignpoi/fact(ignpoi+1)
      go to 110
!
!             CASE IGNPOI .GE. 10 USES POLYNOMIAL APPROXIMATION
!             A0-A7 FOR ACCURACY WHEN ADVISABLE
!             .8333333E-1=1./12.  .3989423=(2*PI)**(-.5)
!
   80 del = .8333333e-1/fk
      del = del - 4.8*del**3
      v = difmuk/fk
      IF( abs(v) <= 0.25 ) go to 90
      px = fk*alog(1.0+v) - difmuk - del
      go to 100

   90 px = fk*v**2*(((((((a7*v+a6)*v+a5)*v+a4)*v+a3)*v+a2)*v+a1)*v+a0)- del
  100 py = .3989423/sqrt(fk)
  110 x = (0.5-difmuk)/s
      xx = x*x
      fx = -0.5*xx
      fy = omega* (((c3*xx+c2)*xx+c1)*xx+c0)
      IF( kflag <= 0 ) go to 40
      go to 60
!
!     C A S E  B. (START NEW TABLE AND CALCULATE P0 IF NECESSARY)
!
!     JJV changed MUPREV assignment from 0.0 to initial value
  120 muprev = -1.0e37
      IF( mu == muold ) go to 130
      muold = mu
      m = max( 1, ifix(real(mu)) )
      l = 0
      p = exp(-mu)
      q = p
      p0 = p
!
!     STEP U. UNIFORM SAMPLE FOR INVERSION METHOD
!
  130 CALL rng_rand_u01( Rng_Stream_g_addr, u )
      ignpoi = 0
      IF( u <= p0 ) RETURN
!
!     STEP T. TABLE COMPARISON UNTIL THE END PP(L) OF THE
!             PP-TABLE OF CUMULATIVE POISSON PROBABILITIES
!             (0.458=PP(9) FOR MU=10)
!
      IF( l == 0 ) go to 150
      j = 1
      IF( u > 0.458 ) j = min( l, m )
      DO k = j, l
         IF( u <= pp(k) ) go to 180
      END DO
      IF( l == 35 ) go to 130
!
!     STEP C. CREATION OF NEW POISSON PROBABILITIES P
!             AND THEIR CUMULATIVES Q=PP(K)
!
  150 l = l + 1
      DO k = l, 35
         p = p*mu/float(k)
         q = q + p
         pp(k) = q
         IF( u <= q ) go to 170
      END DO
      l = 35
      go to 130

  170 l = k
  180 ignpoi = k

      END
