! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 Jul 2017
!_______________________________________________________________________
!
   subroutine r1mpyq( m, n, a, lda, v, w )

      integer :: m, n, lda
      double precision :: a(lda,n), v(n), w(n)
!     **********
!
!     subroutine r1mpyq
!
!     Given an m by n matrix A, this subroutine computes A*Q where
!     Q is the product of 2*(n - 1) transformations
!
!           gv(n-1)*...*gv(1)*gw(1)*...*gw(n-1)
!
!     and gv(i), gw(i) are Givens rotations in the (i,n) plane which
!     eliminate elements in the i-th and n-th planes, respectively.
!     Q itself is not given, rather the information to recover the
!     gv, gw rotations is supplied.
!
!     The subroutine statement is
!
!       subroutine r1mpyq( m, n, a, lda, v, w )
!
!     where
!
!       m is a positive integer input variable set to the number
!         of rows of A.
!
!       n is a positive integer input variable set to the number
!         of columns of A.
!
!       a is an m by n array. on input A must contain the matrix
!         to be postmultiplied by the orthogonal matrix Q
!         described above. On output A*Q has replaced A.
!
!       lda is a positive integer input variable not less than m
!         which specifies the leading dimension of the array A.
!
!       v is an input array of length n. v(i) must contain the
!         information necessary to recover the Givens rotation gv(i)
!         described above.
!
!       w is an input array of length n. w(i) must contain the
!         information necessary to recover the Givens rotation gw(i)
!         described above.
!
!     subroutines called
!
!       fortran-supplied ... abs, sqrt
!
!     Argonne National Laboratory. Minpack project. March 1980.
!     Burton S. Garbow, Kenneth E. Hillstrom, Jorge J. Moré
!
!     **********
      integer :: i, j, nmj, nm1
      double precision :: cos, sin, temp
      double precision, parameter :: one = 1.0d0

!--------- end of declarations -- execution starts hereafter  ------

      ! Apply the first set of givens rotations to A.
      nm1 = n - 1
      if( nm1 < 1 ) return
      do nmj = 1, nm1
         j = n - nmj
         if( abs(v(j)) > one ) cos = one/v(j)
         if( abs(v(j)) > one ) sin = sqrt(one-cos**2)
         if( abs(v(j)) <= one ) sin = v(j)
         if( abs(v(j)) <= one ) cos = sqrt(one-sin**2)
         do i = 1, m
            temp = cos*a(i,j) - sin*a(i,n)
            a(i,n) = sin*a(i,j) + cos*a(i,n)
            a(i,j) = temp
         end do
      end do

      ! Apply the second set of givens rotations to A.
      do j = 1, nm1
         if( abs(w(j)) > one ) cos = one/w(j)
         if( abs(w(j)) > one ) sin = sqrt(one-cos**2)
         if( abs(w(j)) <= one ) sin = w(j)
         if( abs(w(j)) <= one ) cos = sqrt(one-sin**2)
         do i = 1, m
            temp = cos*a(i,j) + sin*a(i,n)
            a(i,n) = -sin*a(i,j) + cos*a(i,n)
            a(i,j) = temp
         end do
      end do

   end
