! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 Jul 2017
!_______________________________________________________________________
!
   subroutine qform( m, n, q, ldq, wa )

      integer :: m, n, ldq
      double precision :: q(ldq,m), wa(m)
!     **********
!
!     subroutine qform
!
!     This subroutine proceeds from the computed QR factorization of
!     an m by n matrix A to accumulate the m by m orthogonal matrix
!     Q from its factored form.
!
!     The subroutine statement is
!
!       subroutine qform( m, n, q, ldq, wa )
!
!     where
!
!       m is a positive integer input variable set to the number
!         of rows of A and the order of Q.
!
!       n is a positive integer input variable set to the number
!         of columns of A.
!
!       q is an m by m array. On input the full lower trapezoid in
!         the first min(m,n) columns of q contains the factored form.
!         On output q has been accumulated into a square matrix.
!
!       ldq is a positive integer input variable not less than m
!         which specifies the leading dimension of the array q.
!
!       wa is a work array of length m.
!
!     subprograms called
!
!       fortran-supplied ... min
!
!     Argonne National Laboratory. Minpack project. March 1980.
!     Burton S. Garbow, Kenneth E. Hillstrom, Jorge J. Moré
!
!     **********
      integer :: i, j, jm1, k, l, minmn, np1
      double precision :: sum, temp
      double precision, parameter :: one = 1.0d0, zero = 0.0d0

!--------- end of declarations -- execution starts hereafter  ------


      ! Zero out upper triangle of q in the first min(m,n) columns.
      minmn = min(m,n)
      if( minmn < 2 ) go to 30
      do j = 2, minmn
         jm1 = j - 1
         do i = 1, jm1
            q(i,j) = zero
         end do
      end do
   30 continue

      ! Initialize remaining columns to those of the identity matrix.
      np1 = n + 1
      if( m < np1 ) go to 60
      do j = np1, m
         do i = 1, m
            q(i,j) = zero
         end do
         q(j,j) = one
      end do
   60 continue

      ! Accumulate q from its factored form.
      do l = 1, minmn
         k = minmn - l + 1
         do i = k, m
            wa(i) = q(i,k)
            q(i,k) = zero
         end do
         q(k,k) = one
         if( wa(k) == zero ) cycle
         do j = k, m
            sum = zero
            do i = k, m
               sum = sum + q(i,j)*wa(i)
            end do
            temp = sum/wa(k)
            do i = k, m
               q(i,j) = q(i,j) - temp*wa(i)
            end do
         end do
      end do

   end
