! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 Jul 2017
!_______________________________________________________________________
!
   subroutine lmdif1_funfit( fcn, m, n, x, fvec, tol, info,             &
                             iwa, wa, lwa, user_fun )

      integer :: m, n, info, lwa
      integer :: iwa(n)
      double precision :: tol
      double precision :: x(n), fvec(m), wa(lwa)
      interface
         subroutine fcn( m, n, x, fvec, user_fun )
            integer,          intent(in) :: m, n
            double precision, intent(in) :: x(n)
            double precision             :: fvec(m)
            interface
               function user_fun( x, p, n ) result( res )
                  double precision, intent(in) :: x, p(n)
                  integer,          intent(in) :: n
                  double precision             :: res
               end function
            end interface
         end subroutine
         function user_fun( x, p, n ) result( res )
            double precision, intent(in) :: x, p(n)
            integer,          intent(in) :: n
            double precision             :: res
         end function
      end interface
!     ******************************************************************
! EC 2012-03-23: the 'user_fun' argument has been added.
!                'user_fun' is the modelling function; its interface
!                is described below.
!                At a top level, the user only provides 'user_fun',
!                whereas 'fcn' is defined in MUESLI (module mod_datafun)
!     ******************************************************************
!
!     subroutine lmdif1_funfit
!
!     The purpose of lmdif1_funfit is to minimize the sum of the squares
!     of m nonlinear functions in n variables by a modification of the
!     Levenberg-Marquardt algorithm. This is done by using the more
!     general least-squares solver lmdif_funfit. The user must provide a
!     subroutine which calculates the functions. The jacobian is
!     then calculated by a forward-difference approximation.
!
!     The subroutine statement is
!
!       subroutine lmdif1_funfit( fcn, m, n, x, fvec, tol, info,
!                                 iwa, wa, lwa, user_fun )
!
!     where
!
!       fcn is the name of a module subroutine defined by the Muesli
!         library (cf. module mod_datafun)
!
!       user_fun is the modelling user-function, as follows:
!         (n is the number of variables to be determined, p(n) a
!          vector containing these variables, xx the independant
!          variable) See the interface in the header.
!
!       m is a positive integer input variable set to the number
!         of functions.
!
!       n is a positive integer input variable set to the number
!         of variables. n must not exceed m.
!
!       x is an array of length n. On input x must contain
!         an initial estimate of the solution vector. On output x
!         contains the final estimate of the solution vector.
!
!       fvec is an output array of length m which contains
!         the functions evaluated at the output x.
!
!       tol is a nonnegative input variable. Termination occurs
!         when the algorithm estimates either that the relative
!         error in the sum of squares is at most tol or that
!         the relative error between x and the solution is at
!         most tol.
!
!       info is an integer output variable. If the user has
!         terminated execution, info is set to the (negative)
!         value of iflag. See description of fcn. Otherwise,
!         info is set as follows.
!
!         info = 0  improper input parameters.
!
!         info = 1  algorithm estimates that the relative error
!                   in the sum of squares is at most tol.
!
!         info = 2  algorithm estimates that the relative error
!                   between x and the solution is at most tol.
!
!         info = 3  conditions for info = 1 and info = 2 both hold.
!
!         info = 4  fvec is orthogonal to the columns of the
!                   jacobian to machine precision.
!
!         info = 5  number of calls to fcn has reached or
!                   exceeded 200*(n+1).
!
!         info = 6  tol is too small. No further reduction in
!                   the sum of squares is possible.
!
!         info = 7  tol is too small. No further improvement in
!                   the approximate solution x is possible.
!
!       iwa is an integer work array of length n.
!
!       wa is a work array of length lwa.
!
!       lwa is a positive integer input variable not less than
!         m*n+5*n+m.
!
!     subprograms called
!
!       user-supplied ...... user_fun
!
!       module ............. fcn
!
!       minpack-supplied ... lmdif_funfit
!
!     Argonne National Laboratory. MINPACK project. March 1980.
!     Burton S. Garbow, Kenneth E. Hillstrom, Jorge J. Moré
!
!     **********
      integer :: maxfev, mode, mp5n, nfev, nprint
      double precision :: epsfcn, ftol, gtol, xtol
      double precision, parameter :: factor = 1.0d2, zero = 0.0d0

!--------- end of declarations -- execution starts hereafter  ------

      info = 0

      ! Check the input parameters for errors.
      if( n <= 0 .or. m < n .or. tol < zero                             &
          .or. lwa < m*n + 5*n + m) return

      ! Call lmdif_funfit() routine with appropriate arguments.
      maxfev = 200*(n + 1)
      ftol = tol
      xtol = tol
      gtol = zero
      epsfcn = zero
      mode = 1
      nprint = 0
      mp5n = m + 5*n
      call lmdif_funfit( fcn, m, n, x, fvec, ftol, xtol, gtol, maxfev,  &
                         epsfcn, wa(1), mode, factor, nprint, info, nfev, &
                         wa(mp5n+1), m, iwa, wa(n+1), wa(2*n+1), wa(3*n+1), &
                         wa(4*n+1), wa(5*n+1), user_fun )

      if( info == 8 ) info = 4

   end
