! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 Jul 2017
!
   subroutine fdjac2_funfit( fcn, m, n, x, fvec, fjac, ldfjac,          &
                             epsfcn, wa, user_fun )

      use mod_mfaux, only: mf_save_and_disable_fpe, mf_restore_fpe

      integer :: m, n, ldfjac
      double precision :: epsfcn
      double precision :: x(n), fvec(m), fjac(ldfjac,n), wa(m)
      interface
         subroutine fcn( m, n, x, fvec, user_fun )
            integer,          intent(in) :: m, n
            double precision, intent(in) :: x(n)
            double precision             :: fvec(m)
            interface
               function user_fun( x, p, n ) result( res )
                  double precision, intent(in) :: x, p(n)
                  integer,          intent(in) :: n
                  double precision             :: res
               end function
            end interface
         end subroutine
         function user_fun( x, p, n ) result( res )
            double precision, intent(in) :: x, p(n)
            integer,          intent(in) :: n
            double precision             :: res
         end function
      end interface
!     ******************************************************************
! EC 2012-03-23: the 'user_fun' argument has been added.
!                'user_fun' is the modelling function; its interface
!                is described below.
!                At a top level, the user only provides 'user_fun',
!                whereas 'fcn' is defined in MUESLI (module mod_datafun)
!     ******************************************************************
!
!     subroutine fdjac2_funfit
!
!     This subroutine computes a forward-difference approximation
!     to the m by n jacobian matrix associated with a specified
!     problem of m functions in n variables.
!
!     The subroutine statement is
!
!       subroutine fdjac2_funfit( fcn, m, n, x, fvec, fjac, ldfjac, ifla
!                                 epsfcn, wa, user_fun )
!
!     where
!
!       fcn is the name of a module subroutine which
!         calculates the functions. See the interface in the header.
!
!       user_fun is the modelling user-function, as follows:
!         (n is the number of variables to be determined, p(n) a
!          vector containing these variables, xx the independant
!          variable) See the interface in the header.
!
!       m is a positive integer input variable set to the number
!         of functions.
!
!       n is a positive integer input variable set to the number
!         of variables. n must not exceed m.
!
!       x is an input array of length n.
!
!       fvec is an input array of length m which must contain the
!         functions evaluated at x.
!
!       fjac is an output m by n array which contains the
!         approximation to the jacobian matrix evaluated at x.
!
!       ldfjac is a positive integer input variable not less than m
!         which specifies the leading dimension of the array fjac.
!
!       epsfcn is an input variable used in determining a suitable
!         step length for the forward-difference approximation. This
!         approximation assumes that the relative errors in the
!         functions are of the order of epsfcn. If epsfcn is less
!         than the machine precision, it is assumed that the relative
!         errors in the functions are of the order of the machine
!         precision.
!
!       wa is a work array of length m.
!
!     Subprograms called
!
!       user-supplied ...... fcn
!
!       fortran-supplied ... abs, max, sqrt
!
!     Argonne National Laboratory. MINPACK project. March 1980.
!     Burton S. Garbow, Kenneth E. Hillstrom, Jorge J. Moré
!
!     **********
      integer :: i, j
      double precision :: eps, epsmch, h, temp
      double precision, parameter ::  zero = 0.0d0

!--------- end of declarations -- execution starts hereafter  ------

      ! epsmch is the machine precision.
      epsmch =  epsilon(1.0d0)

      eps = sqrt(max(epsfcn,epsmch))
      do j = 1, n
         temp = x(j)
         h = eps*abs(temp)
         if( h == zero) h = eps
         x(j) = temp + h

         call mf_restore_fpe( )
         call fcn( m, n, x, wa, user_fun )
         call mf_save_and_disable_fpe( )

         x(j) = temp
         do i = 1, m
            fjac(i,j) = (wa(i) - fvec(i))/h
         end do
      end do

   end
