! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 13 Jul 2017
!_______________________________________________________________________
!
   double precision function enorm( n, x )

      integer :: n
      double precision :: x(n)
!     **********
!
!     function enorm
!
!     Given an n-vector x, this function calculates the euclidean norm
!     of x.
!
!     The euclidean norm is computed by accumulating the sum of squares
!     in three different sums. The sums of squares for the small and
!     large components are scaled so that no overflows occur. Non-
!     destructive underflows are permitted. Underflows and overflows do
!     not occur in the computation of the unscaled sum of squares for
!     the intermediate components. The definitions of small, intermediate
!     and large components depend on two constants, rdwarf and rgiant.
!     The main restrictions on these constants are that rdwarf**2 not
!     underflow and rgiant**2 not overflow. The constants given here are
!     suitable for every known computer.
!
!     The function statement is
!
!       double precision function enorm(n,x)
!
!     where
!
!       n is a positive integer input variable.
!
!       x is an input array of length n.
!
!     subprograms called
!
!       fortran-supplied ... abs, sqrt
!
!     Argonne National Laboratory. MINPACK project. March 1980.
!     Burton S. Garbow, Kenneth E. Hillstrom, Jorge J. Moré
!
!     **********
      integer :: i
      double precision :: agiant, floatn, s1, s2, s3, xabs, x1max, x3max
      double precision, parameter :: one = 1.0d0, zero = 0.0d0,         &
                                     rdwarf = 3.834d-20, rgiant = 1.304d19

!--------- end of declarations -- execution starts hereafter  ------

      s1 = zero
      s2 = zero
      s3 = zero
      x1max = zero
      x3max = zero
      floatn = n
      agiant = rgiant/floatn
      do i = 1, n
         xabs = abs(x(i))
         if( xabs > rdwarf .and. xabs < agiant ) go to 70
            if( xabs <= rdwarf ) go to 30
               ! sum for large components.
               if( xabs <= x1max ) go to 10
                  s1 = one + s1*(x1max/xabs)**2
                  x1max = xabs
                  go to 20
   10          continue
                  s1 = s1 + (xabs/x1max)**2
   20          continue
               go to 60
   30       continue
               ! sum for small components.
               if( xabs <= x3max ) go to 40
                  s3 = one + s3*(x3max/xabs)**2
                  x3max = xabs
                  go to 50
   40          continue
                  if( xabs /= zero ) s3 = s3 + (xabs/x3max)**2
   50          continue
   60       continue
            go to 80
   70    continue
            ! sum for intermediate components.
            s2 = s2 + xabs**2
   80    continue
      end do
      ! calculation of norm.
      if( s1 == zero ) go to 100
         enorm = x1max*sqrt(s1+(s2/x1max)/x1max)
         go to 130
  100 continue
         if( s2 == zero ) go to 110
            if( s2 >= x3max ) enorm = sqrt(s2*(one+(x3max/s2)*(x3max*s3)))
            if( s2 < x3max ) enorm = sqrt(x3max*((s2/x3max)+(x3max*s3)))
            go to 120
  110    continue
            enorm = x3max*sqrt(s3)
  120    continue
  130 continue

   end
