! f90 include file
!
! modified for MUESLI Fortran library
! (C) É. Canot -- IPR/CNRS -- 14 Jul 2017
!_______________________________________________________________________
!
   subroutine dogleg_sp( n, pd, ipd, jpd, diag, b, delta, x )

      use mod_matfun

      integer,          intent(in)  :: n
      double precision, intent(in)  :: delta
      double precision, intent(in)  :: pd(:), diag(n), b(n)
      integer,          intent(in)  :: ipd(:), jpd(:)
      double precision, intent(out) :: x(n)
!     **********
!
!     subroutine dogleg_sp (sparse version of dogleg, without
!       QR factorization)
!
!     Given an n by n matrix A, an n by n nonsingular diagonal
!     matrix D, an n-vector b, and a positive number delta, the
!     problem is to determine the convex combination x of the
!     Gauss-Newton and scaled gradient directions that minimizes
!     (A*x - b) in the least squares sense, subject to the
!     restriction that the euclidean norm of D*x be at most delta.
!
!     The subroutine statement is
!
!       subroutine dogleg_sp( n, pd, ipd, jpd, diag, b, delta, x )
!
!     where
!
!       n is a positive integer input variable set to the order of A.
!
!       pd, ipd, jpd are the arrays describing the sparse matrix A.
!
!       diag is an input array of length n which must contain the
!         diagonal elements of the matrix D.
!
!       b is an input array of length n.
!
!       delta is a positive input variable which specifies an upper
!         bound on the euclidean norm of D*x.
!
!       x is an output array of length n which contains the desired
!         convex combination of the Gauss-Newton direction and the
!         scaled gradient direction.
!
! Sparse version written by É. Canot, from 'dogleg' function in 'fsolve.m'
! of octave-4.2.1 (2017 Feb 24), https://www.gnu.org/software/octave/
!     **********

      type(mfArray) :: mfA, mfb, mfx, mfs, mfdg

      double precision :: xn, sn, tn, snm, bn, dxn, snmd, t, alpha

!--------- end of declarations -- execution starts hereafter  ------

      call msAssign( mfA, mfSpImport(ipd,jpd,pd,format="CSC") )

      call msEquiv( b, mfb ) ! mfb => b(:)

      ! Get Gauss-Newton direction.
!### old -- not efficient for many calls using the same matrix... !
call msAssign( mfx, mfLDiv(mfA,mfb) ) ! x = A \ b
!### new
!### TODO 2:
! pour implémenter l'économie de la factorisation symbolique par UMFPack,
! il faut recopier 'sp_lu_fact' et 'sp_lu_solv' depuis mod_ddebd2. Ces
! routines ne peuvent pas (?) être utilisées directement depuis 'mod_ddebd2'
! (slatec) car l'utilisateur pourrait vouloir également intégrer une ODE/DAE
! depuis le même programme...
!!      if( REUSE_SPJAC_STRUCT ) then
!!         ! la factorisation symbolique est déjà faite
!!         call sp_lu_solv()
!!      else
!!         call sp_lu_fact()
!!         call sp_lu_solv()
!!      end if

      call msAssign( mfdg, .t.mf(diag) )
      xn = mfNorm( mfdg*mfx )

      if( xn > delta ) then
         ! GN direction is too big, get scaled gradient.
         call msAssign( mfs, mfMul(.t.mfA,mfb)/mfdg )
         sn = mfNorm( mfs )
         if( sn > 0.0d0 ) then
            ! Normalize and rescale.
            call msAssign( mfs, (mfs/sn)/mfdg )
            ! Get the line minimizer in s direction.
            tn = mfNorm( mfMul(mfA,mfs) )
            snm = (sn/tn) / tn
            if( snm < delta ) then
               ! Get the dogleg path minimizer.
               bn = mfNorm( mfb )
               dxn = delta/xn
               snmd = snm/delta
               t = (bn/sn)*(bn/xn)*snmd
               t = t - ( dxn*snmd**2                                    &
                       - sqrt ((t-dxn)**2 + (1.0d0-dxn**2)*(1.0d0-snmd**2)) )
               alpha = dxn*(1-snmd**2)/t
            else
               alpha = 0.0d0
            end if
         else
            alpha = delta / xn
            snm = 0.0d0
         end if
         ! Form the appropriate convex combination.
         x = alpha*mfx + ((1.0d0-alpha)*min(snm,delta))*mfs
      else
         x = mfx
      end if

      call msRelease( mfA, mfb, mfx, mfs, mfdg )

   end
