/*--------------------------------------------------------------------*\
 * (C) Édouard CANOT, IPR/CNRS, Nov 2024                              *
 * Edouard.Canot@univ-rennes.fr                                       *
\*--------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <readline/readline.h>
#include <readline/history.h>

/* Forward declarations. */
char *mf_c_stripwhite ( char *string );

int MF_HISTORY_LENGTH = 100;

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define mf_readline_c mf_readline_c_
#endif
int mf_readline_c( int *length, char *input_line, char *prompt )
{
  char *line, *s, *last;

  if( where_history() )
  {
    last = (*previous_history()).line;
  }
  else
  {
    /* before the first call of readline(), offset is NULL */
    int pos = 1;
    while( history_set_pos(pos) == 1) {
      pos++;
    }
    pos--;
    if( pos )
    {
      last = (*previous_history()).line;
    } else {
      last = "";
    }
  }

  line = readline (prompt);
  if( line == 0 ) {
    *length = -1;
    return(0);
  }

  /* Remove leading and trailing whitespace from the line.
     Then, if there is anything left, add it to the history list. */
  s = mf_c_stripwhite (line);

  *length = strlen(s);
  if( *s )
    {
      strcpy(input_line,s);

      if( strcmp(s,last) )
      {
      add_history (s);
      stifle_history(MF_HISTORY_LENGTH);
      }

    }

  free(line);
  return(0);
}

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define ms_remove_last_entry_c ms_remove_last_entry_c_
#endif
void ms_remove_last_entry_c( )
{
  HIST_ENTRY *entry;
  entry = remove_history( where_history() );
}

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define ms_add_history_c ms_add_history_c_
#endif
void ms_add_history_c( char* string )
{
  add_history( string );
}

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define ms_clear_history_c ms_clear_history_c_
#endif
void ms_clear_history_c( )
{
  clear_history( );
}

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define ms_write_history_c ms_write_history_c_
#endif
void ms_write_history_c( char* filename )
{
  write_history( filename );
}

/* interopérabilité C <-> Fortran */
#ifdef UNDERSCORE
#define ms_read_history_c ms_read_history_c_
#endif
void ms_read_history_c( char* filename )
{
  read_history( filename );
}

/* Strip whitespace from the start and end of STRING.  Return a pointer
   into STRING. */
/* 'whitespace' is a MACRO defined only in some UNIX,
 * it is better to use instead: (*s) == ' ' */
char *mf_c_stripwhite( char *string )
{
  register char *s, *t;

  for( s = string; (*s) == ' ' ; s++ )
    ;

  if (*s == 0)
    return (s);

  t = s + strlen (s) - 1;
  while( t > s && (*s) == ' ' )
    t--;
  *++t = '\0';

  return s;
}
