#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "zlib.h"

/* addresses are now stored in 'long'
 * (i.e. 32 bits or 64 bits according to the Unix OS used)
 */
/* typedef long ADDRESS; not sure that it is true on IBM/AIX */
#ifdef _64_BITS
#define ADDRESS long long int
#else
#define ADDRESS int
#endif

#ifdef UNDERSCORE
#define gateway_gzopen gateway_gzopen_
#endif
gzFile gateway_gzopen( const char *path, const char *mode, char *version )
{
  gzFile gzfile = gzopen( path, mode );
  strcpy( version, ZLIB_VERSION );
  if (gzfile == NULL) {
    fprintf(stderr, "(gateway_gzopen:) gzopen error for file : '%s'\n",path);
    perror(         "                  -> ");
  }
  return( gzfile );
}

#ifdef UNDERSCORE
#define gateway_gzwrite gateway_gzwrite_
#endif
void gateway_gzwrite( ADDRESS* file, void *buf, int *n )
{
  unsigned len = (unsigned) *n;
  gzFile gzfile = *(gzFile *)file;
  gzwrite( gzfile, buf, len );
}

#ifdef UNDERSCORE
#define gateway_gzread gateway_gzread_
#endif
void gateway_gzread( ADDRESS* file, void *buf, int *n, int *nbytes_read )
{
  unsigned len = (unsigned) *n;
  gzFile gzfile = *(gzFile *)file;
  *nbytes_read = gzread( gzfile, buf, len );
}

#ifdef UNDERSCORE
#define gateway_gzclose gateway_gzclose_
#endif
void gateway_gzclose( ADDRESS* file )
{
  int error;
  gzFile gzfile = *(gzFile *)file;
  error = gzclose( gzfile );
  if (error != 0) {
    fprintf(stderr, "(gateway_gzclose:) gzclose error\n");
  }
}

