/**********************************************************************
                         wrapper pour Fortran 90

    É. Canot -- CNRS --  9 Dec 2025

**********************************************************************/

#include "tetgen.h"

extern "C" {

//**********************************************************************

#ifdef UNDERSCORE
#define DELAUNAY_3D_INIT delaunay_3d_init_
#else
#define DELAUNAY_3D_INIT delaunay_3d_init
#endif
void DELAUNAY_3D_INIT( int* nb, double x[], double y[], double z[],
                       tetgenio** delaunay_3d, int* nb_tetra )
{
  tetgenio in;
  char switches[]="nFQ"; // n: Outputs tetrahedra neighbors
                         // F: Suppresses output of faces and edges
                         // Q: (Quiet) No terminal output except errors

  *delaunay_3d = new tetgenio;

  // All indices start from 1
  in.firstnumber = 1;

  in.numberofpoints = *nb;
  in.pointlist = new REAL[in.numberofpoints * 3];

  for ( int i = 0; i < *nb; i++ ) {
    in.pointlist[3*i]   = x[i]; // node i
    in.pointlist[3*i+1] = y[i];
    in.pointlist[3*i+2] = z[i];
  }

  tetrahedralize( switches, &in, *delaunay_3d);

  *nb_tetra = (** delaunay_3d).numberoftetrahedra;
}

//**********************************************************************

/* Attention, il manque les segments; mais tant qu'on reste avec des
 * cas simples, on en a pas besoin. Tetgen, en interne, va reconstruire
 * ces segments.
 * Ici, chaque face du volume n'est constituée que d'un seul polygone
 * (c'est le cas le plus courant).
 */

#ifdef UNDERSCORE
#define DELAUNAY_3D_PLC delaunay_3d_plc_
#else
#define DELAUNAY_3D_PLC delaunay_3d_plc
#endif
void DELAUNAY_3D_PLC( int* nb_pts, double x[], double y[], double z[],
                      int* nb_fac, int beg[], int end[], int cont_list_nod[],
                      tetgenio** delaunay_3d, char* options,
                      int* nb_new, int* nb_tetra )
{
  tetgenio in;

  *delaunay_3d = new tetgenio;

//printf("options: %s\n",options);

  // All indices start from 1
  in.firstnumber = 1;

  in.numberofpoints = *nb_pts;
  in.pointlist = new REAL[in.numberofpoints * 3];

  for ( int i = 0; i < *nb_pts; i++ ) {
    in.pointlist[3*i]   = x[i]; // node i
    in.pointlist[3*i+1] = y[i];
    in.pointlist[3*i+2] = z[i];
  }

  // Number of faces
  in.numberoffacets = *nb_fac;
  in.facetlist      = new tetgenio::facet[in.numberoffacets];
  in.facetmarkerlist = NULL;  // optional

  // Loop over faces
  for (int i = 0; i < in.numberoffacets; i++) {

      tetgenio::facet &f = in.facetlist[i];
      f.numberofpolygons = 1;          // one face = only one polygon
      f.polygonlist      = new tetgenio::polygon[1];
      f.holelist         = NULL;       // no holes in the faces
      f.numberofholes    = 0;

      tetgenio::polygon &p = f.polygonlist[0];

      // Number of vertices for the face i (inclusive indices)
      int start = beg[i] - 1;
      int stop  = end[i] - 1;
      int nverts = stop - start + 1;

      p.numberofvertices = nverts;
      p.vertexlist = new int[nverts];

      // Filling the list of vertices
      for (int k = 0; k < nverts; k++) {
          int node_id = cont_list_nod[start + k];

          // IMPORTANT : this respects in.firstnumber
          p.vertexlist[k] = node_id; // assuming node_id starts from 1
      }
  }

  tetrahedralize( options, &in, *delaunay_3d);

  *nb_new = (** delaunay_3d).numberofpoints;

  *nb_tetra = (** delaunay_3d).numberoftetrahedra;
}

//**********************************************************************

#ifdef UNDERSCORE
#define DELAUNAY_3D_GET_PTS_COORDS delaunay_3d_get_pts_coords_
#else
#define DELAUNAY_3D_GET_PTS_COORDS delaunay_3d_get_pts_coords
#endif
void DELAUNAY_3D_GET_PTS_COORDS( tetgenio** delaunay_3d,
                                 double x[], double y[], double z[] )
{
  tetgenio *o = *delaunay_3d;
  int nb_pts = o->numberofpoints;

  for (int i = 0; i < nb_pts; i++) {
    x[i] = o->pointlist[3*i];
    y[i] = o->pointlist[3*i + 1];
    z[i] = o->pointlist[3*i + 2];
  }
}

//**********************************************************************

#ifdef UNDERSCORE
#define DELAUNAY_3D_GET_TETRA delaunay_3d_get_tetra_
#else
#define DELAUNAY_3D_GET_TETRA delaunay_3d_get_tetra
#endif
void DELAUNAY_3D_GET_TETRA( tetgenio** delaunay_3d,
                            int tetra[] )
{
  tetgenio *o = *delaunay_3d;
  int nb_tetra = o->numberoftetrahedra;
  int nb_corners = o->numberofcorners;

  for( int i = 0; i < nb_tetra; i++) {
    for( int j = 0; j < 4; j++ ) {
      tetra[j*nb_tetra+i] = o->tetrahedronlist[i*nb_corners+j];
    }
  }
}

//**********************************************************************

#ifdef UNDERSCORE
#define DELAUNAY_3D_GET_NEIGHBORS delaunay_3d_get_neighbors_
#else
#define DELAUNAY_3D_GET_NEIGHBORS delaunay_3d_get_neighbors
#endif
void DELAUNAY_3D_GET_NEIGHBORS( tetgenio** delaunay_3d,
                                int tetra_neighbors[] )
{
  tetgenio *o = *delaunay_3d;
  int nb_tetra = o->numberoftetrahedra;
  int nb_corners = o->numberofcorners;

  for( int i = 0; i < nb_tetra; i++) {
    for( int j = 0; j < 4; j++ ) {
      tetra_neighbors[j*nb_tetra+i] = o->neighborlist[i*nb_corners+j];
    }
  }
}

//**********************************************************************

#ifdef UNDERSCORE
#define DELAUNAY_3D_FREE delaunay_3d_free_
#else
#define DELAUNAY_3D_FREE delaunay_3d_free
#endif
void DELAUNAY_3D_FREE( tetgenio** delaunay_3d )
{
  delete (*delaunay_3d);
  *delaunay_3d = 0;
}

//**********************************************************************

}
