#define REAL double

#include <stdlib.h>
#include "triangle.h"

/* global variables because, when called from Fortran, we must have
   two successive calls */
struct triangulateio t_d_in, t_d_out;

/* Fortran interface */
#ifdef UNDERSCORE
#define TRIANGLE_DELAUNAY triangle_delaunay_
#else
#define TRIANGLE_DELAUNAY triangle_delaunay
#endif
int TRIANGLE_DELAUNAY( int* nb_pts, REAL* x_pts, REAL* y_pts,
                       char* options,
                       int* nb_pts_2, int* nb_tri )
{
  int i, j;

  /* Define input points. */

  t_d_in.numberofpoints = * nb_pts;
  t_d_in.pointlist = (REAL *) malloc(t_d_in.numberofpoints * 2 * sizeof(REAL));
  j = 0;
  for( i=0; i<t_d_in.numberofpoints; i++ ) {
    t_d_in.pointlist[j] = x_pts[i]; j++;
    t_d_in.pointlist[j] = y_pts[i]; j++;
  }

  t_d_in.numberofpointattributes = 0;
  t_d_in.pointattributelist = (REAL *) NULL;
#ifndef _OPTIM
  t_d_in.pointmarkerlist = (int *) calloc(1,t_d_in.numberofpoints * sizeof(int));
#else
  t_d_in.pointmarkerlist = (int *) malloc(t_d_in.numberofpoints * sizeof(int));
#endif

  t_d_in.numberofsegments = 0;
  t_d_in.numberofholes = 0;
  t_d_in.numberofregions = 0;
  t_d_in.regionlist = (REAL *) NULL;

  /* Make necessary initializations so that Triangle can return a */
  /* triangulation in `t_d_out'.  */

  t_d_out.pointlist = (REAL *) NULL;      /* Not needed if -N switch used. */
  t_d_out.pointmarkerlist = (int *) NULL; /* Not needed if -N or -B switch used. */
  t_d_out.trianglelist = (int *) NULL;    /* Not needed if -E switch used. */

  /* Triangulate the points */

  triangulate( options, &t_d_in, &t_d_out, (struct triangulateio *) NULL );

  *nb_pts_2 = t_d_out.numberofpoints;

  *nb_tri = t_d_out.numberoftriangles;

  return 0;
}

/* Fortran interface */
#ifdef UNDERSCORE
#define TRIANGLE_DELAUNAY_PSLG triangle_delaunay_pslg_
#else
#define TRIANGLE_DELAUNAY_PSLG triangle_delaunay_pslg
#endif
int TRIANGLE_DELAUNAY_PSLG( int* nb_pts, REAL* x_pts, REAL* y_pts,
                            int* nb_seg, int* n1, int* n2,
                            int* nb_hol, REAL* x_hol, REAL* y_hol,
                            char* options,
                            int* nb_pts_2, int* nb_tri )
{
  int i, j;

  /* Define input points. */

  t_d_in.numberofpoints = *nb_pts;
  t_d_in.pointlist = (REAL *) malloc(t_d_in.numberofpoints * 2 * sizeof(REAL));
  j = 0;
  for( i=0; i<t_d_in.numberofpoints; i++ ) {
    t_d_in.pointlist[j] = x_pts[i]; j++;
    t_d_in.pointlist[j] = y_pts[i]; j++;
  }

  t_d_in.numberofpointattributes = 0;
  t_d_in.pointattributelist = (REAL *) NULL;
#ifndef _OPTIM
  t_d_in.pointmarkerlist = (int *) calloc(1,t_d_in.numberofpoints * sizeof(int));
#else
  t_d_in.pointmarkerlist = (int *) malloc(t_d_in.numberofpoints * sizeof(int));
#endif

  /* -------------------- */
  t_d_in.numberofsegments = *nb_seg;
  t_d_in.segmentlist = (int*) malloc(t_d_in.numberofsegments * 2 * sizeof(REAL));
  j = 0;
  for( i=0; i<t_d_in.numberofsegments; i++ ) {
    t_d_in.segmentlist[j] = n1[i]; j++;
    t_d_in.segmentlist[j] = n2[i]; j++;
  }

#ifndef _OPTIM
  t_d_in.segmentmarkerlist = (int *) calloc(1,t_d_in.numberofsegments * sizeof(int));
#else
  t_d_in.segmentmarkerlist = (int *) malloc(t_d_in.numberofsegments * sizeof(int));
#endif

  /* -------------------- */
  t_d_in.numberofholes = *nb_hol;
  t_d_in.holelist = (REAL*) malloc(t_d_in.numberofholes * 2 * sizeof(REAL));
  j = 0;
  for( i=0; i<t_d_in.numberofholes; i++ ) {
    t_d_in.holelist[j] = x_hol[i]; j++;
    t_d_in.holelist[j] = y_hol[i]; j++;
  }

  /* -------------------- */
  t_d_in.numberofregions = 0;
  t_d_in.regionlist = (REAL *) NULL;

  /* Make necessary initializations so that Triangle can return a */
  /* triangulation in `t_d_out'.  */

  t_d_out.pointlist = (REAL *) NULL;      /* Not needed if -N switch used. */
  t_d_out.pointmarkerlist = (int *) NULL; /* Not needed if -N or -B switch used. */
  t_d_out.trianglelist = (int *) NULL;    /* Not needed if -E switch used. */

  /* Triangulate the points */

  triangulate( options, &t_d_in, &t_d_out, (struct triangulateio *) NULL );

  *nb_pts_2 = t_d_out.numberofpoints;

  *nb_tri = t_d_out.numberoftriangles;

  return 0;
}

/* Fortran interface */
#ifdef UNDERSCORE
#define TRIANGLE_GET_PTS_COORDS triangle_get_pts_coords_
#else
#define TRIANGLE_GET_PTS_COORDS triangle_get_pts_coords
#endif
int TRIANGLE_GET_PTS_COORDS( REAL* x_pts, REAL* y_pts )
{
  int i, j;

  j = 0;
  for( i=0; i<t_d_out.numberofpoints; i++ ) {
    x_pts[i] = t_d_out.pointlist[j]; j++;
    y_pts[i] = t_d_out.pointlist[j]; j++;
  }

  return 0;
}

/* Fortran interface */
#ifdef UNDERSCORE
#define TRIANGLE_GET_TRI_TABLE triangle_get_tri_table_
#else
#define TRIANGLE_GET_TRI_TABLE triangle_get_tri_table
#endif
int TRIANGLE_GET_TRI_TABLE( int* nb_tri, int* tri_n )
{
  int i, j;

  for( i=0; i<*nb_tri; i++) {
    for( j=0; j<3; j++) {
      tri_n[i+j*(*nb_tri)] = t_d_out.trianglelist[i*3+j];
    }
  }

  return 0;
}

/* Fortran interface */
#ifdef UNDERSCORE
#define TRIANGLE_FREE_ALL triangle_free_all_
#else
#define TRIANGLE_FREE_ALL triangle_free_all
#endif
int TRIANGLE_FREE_ALL( )
{
  /* Free all allocated arrays, including those allocated by Triangle. */

  free(t_d_in.pointlist); t_d_in.pointlist = NULL;
  free(t_d_in.pointmarkerlist); t_d_in.pointmarkerlist = NULL;
  free(t_d_in.segmentlist); t_d_in.segmentlist = NULL;
  free(t_d_in.segmentmarkerlist); t_d_in.segmentmarkerlist = NULL;
  free(t_d_in.holelist); t_d_in.holelist = NULL;

  free(t_d_out.pointlist); t_d_out.pointlist = NULL;
  free(t_d_out.pointmarkerlist); t_d_out.pointmarkerlist = NULL;
  free(t_d_out.trianglelist); t_d_out.trianglelist = NULL;
  free(t_d_out.segmentlist); t_d_out.segmentlist = NULL;
  free(t_d_out.segmentmarkerlist); t_d_out.segmentmarkerlist = NULL;

  return 0;
}
