#ifdef _64_BITS

#ifdef _WIN64
#define ADDRESS __int64
#else
#define ADDRESS long
#endif

#else

#define ADDRESS int

#endif

#if defined __GNUC__
/* convert (3,2,0) to 30200 */
#define GCC_VERSION (__GNUC__*10000+__GNUC_MINOR__*100+__GNUC_PATCHLEVEL__)
#endif

#define MOD_ADLER 65521

#define NMAX 5552 /* from adler32.c of zlib library -- Copyright Mark Adler */
/* NMAX is the largest n such that 255n(n+1)/2 + (n+1)(BASE-1) <= 2^32-1 */

unsigned int adler(unsigned char *data, int len)
{

    unsigned int a = 1, b = 0;

    while (len)
    {
        int tlen = len > NMAX ? NMAX : len;
        len -= tlen;
        do
        {
            a += *data++;
            b += a;
        } while (--tlen);

        a %= MOD_ADLER;
        b %= MOD_ADLER;
    }

    return (b << 16) | a;

}

#ifdef UNDERSCORE
#define icrc32 icrc32_
#endif
int icrc32( ADDRESS* addr, int *size )
{
  ADDRESS* addr2;
#if GCC_VERSION >= 40900
  addr2 = (ADDRESS*)*addr;
#else
  addr2 = addr;
#endif
  int numbytes = *size;
  return( adler( (unsigned char *)addr2, numbytes ) );
}

