/*
 * Fast CRC-32 routines for Unix running on i386 or better.
 *
 * Version 1.00 (Unix).
 *
 * Copyright 1999 G. Adam Stanislav.
 * All rights reserved.
 *
 * These routines were originally written as Windows 95 DLL.
 * I have now ported them to Unix.
 *
 * Started: 07-Mar-1999
 * Updated: 08-Mar-1999
 *
 * You may use these routines freely with your own programs,
 * as long as you give me credit for them.
 *
 * If you have any comments, reach me at adam@whizkidtech.net.
 *
 * Note that to calculate CRC-32 of any string of bytes, you need to
 * start with an initial value of CRC = 0xFFFFFFFF (-1, 32-bits).
 *
 * The function initcrc32() does nothing but return that value.
 *
 * Then, for each byte, you need to call crc32(oldcrc, abyte).
 *
 * Finally, you need to "not" the result. This is accomplished
 * by calling finishcrc32(lastcrc).
 *
 * The initcrc32 and finishcrc32 functions really do not require
 * the power of assembly language. They are listed here for completeness
 * only. But in the enclosed crc32.h file they are declared as macros.
 * If you prefer not to use the macros, define NOCRC32MACROS before
 * including crc32.h.
 *
 * Two additional functions are provided: partialcrc32 and arraycrc32.
 *
 * arraycrc32, calculates the CRC-32 of a complete array of bytes.
 * This one does NOT require the use of initcrc32 and finishcr32.
 * Use it when you have all your data you want to get CRC-32 of
 * in a single buffer.
 *
 * partialcrc32 is used when chunks of data are available at any one time.
 * You need to initialize CRC-32 to -1 before you call it for the
 * first time, then "not" it after the last call.
 */
.text
	.align	4
	.type	 crctable, @object
	.size	 crctable, 1024

/* A look-up table is what makes this so fast. */
crctable:
	.long	0x00000000
	.long	0x77073096
	.long	0xee0e612c
	.long	0x990951ba
	.long	0x076dc419
	.long	0x706af48f
	.long	0xe963a535
	.long	0x9e6495a3
	.long	0x0edb8832
	.long	0x79dcb8a4
	.long	0xe0d5e91e
	.long	0x97d2d988
	.long	0x09b64c2b
	.long	0x7eb17cbd
	.long	0xe7b82d07
	.long	0x90bf1d91
	.long	0x1db71064
	.long	0x6ab020f2
	.long	0xf3b97148
	.long	0x84be41de
	.long	0x1adad47d
	.long	0x6ddde4eb
	.long	0xf4d4b551
	.long	0x83d385c7
	.long	0x136c9856
	.long	0x646ba8c0
	.long	0xfd62f97a
	.long	0x8a65c9ec
	.long	0x14015c4f
	.long	0x63066cd9
	.long	0xfa0f3d63
	.long	0x8d080df5
	.long	0x3b6e20c8
	.long	0x4c69105e
	.long	0xd56041e4
	.long	0xa2677172
	.long	0x3c03e4d1
	.long	0x4b04d447
	.long	0xd20d85fd
	.long	0xa50ab56b
	.long	0x35b5a8fa
	.long	0x42b2986c
	.long	0xdbbbc9d6
	.long	0xacbcf940
	.long	0x32d86ce3
	.long	0x45df5c75
	.long	0xdcd60dcf
	.long	0xabd13d59
	.long	0x26d930ac
	.long	0x51de003a
	.long	0xc8d75180
	.long	0xbfd06116
	.long	0x21b4f4b5
	.long	0x56b3c423
	.long	0xcfba9599
	.long	0xb8bda50f
	.long	0x2802b89e
	.long	0x5f058808
	.long	0xc60cd9b2
	.long	0xb10be924
	.long	0x2f6f7c87
	.long	0x58684c11
	.long	0xc1611dab
	.long	0xb6662d3d
	.long	0x76dc4190
	.long	0x01db7106
	.long	0x98d220bc
	.long	0xefd5102a
	.long	0x71b18589
	.long	0x06b6b51f
	.long	0x9fbfe4a5
	.long	0xe8b8d433
	.long	0x7807c9a2
	.long	0x0f00f934
	.long	0x9609a88e
	.long	0xe10e9818
	.long	0x7f6a0dbb
	.long	0x086d3d2d
	.long	0x91646c97
	.long	0xe6635c01
	.long	0x6b6b51f4
	.long	0x1c6c6162
	.long	0x856530d8
	.long	0xf262004e
	.long	0x6c0695ed
	.long	0x1b01a57b
	.long	0x8208f4c1
	.long	0xf50fc457
	.long	0x65b0d9c6
	.long	0x12b7e950
	.long	0x8bbeb8ea
	.long	0xfcb9887c
	.long	0x62dd1ddf
	.long	0x15da2d49
	.long	0x8cd37cf3
	.long	0xfbd44c65
	.long	0x4db26158
	.long	0x3ab551ce
	.long	0xa3bc0074
	.long	0xd4bb30e2
	.long	0x4adfa541
	.long	0x3dd895d7
	.long	0xa4d1c46d
	.long	0xd3d6f4fb
	.long	0x4369e96a
	.long	0x346ed9fc
	.long	0xad678846
	.long	0xda60b8d0
	.long	0x44042d73
	.long	0x33031de5
	.long	0xaa0a4c5f
	.long	0xdd0d7cc9
	.long	0x5005713c
	.long	0x270241aa
	.long	0xbe0b1010
	.long	0xc90c2086
	.long	0x5768b525
	.long	0x206f85b3
	.long	0xb966d409
	.long	0xce61e49f
	.long	0x5edef90e
	.long	0x29d9c998
	.long	0xb0d09822
	.long	0xc7d7a8b4
	.long	0x59b33d17
	.long	0x2eb40d81
	.long	0xb7bd5c3b
	.long	0xc0ba6cad
	.long	0xedb88320
	.long	0x9abfb3b6
	.long	0x03b6e20c
	.long	0x74b1d29a
	.long	0xead54739
	.long	0x9dd277af
	.long	0x04db2615
	.long	0x73dc1683
	.long	0xe3630b12
	.long	0x94643b84
	.long	0x0d6d6a3e
	.long	0x7a6a5aa8
	.long	0xe40ecf0b
	.long	0x9309ff9d
	.long	0x0a00ae27
	.long	0x7d079eb1
	.long	0xf00f9344
	.long	0x8708a3d2
	.long	0x1e01f268
	.long	0x6906c2fe
	.long	0xf762575d
	.long	0x806567cb
	.long	0x196c3671
	.long	0x6e6b06e7
	.long	0xfed41b76
	.long	0x89d32be0
	.long	0x10da7a5a
	.long	0x67dd4acc
	.long	0xf9b9df6f
	.long	0x8ebeeff9
	.long	0x17b7be43
	.long	0x60b08ed5
	.long	0xd6d6a3e8
	.long	0xa1d1937e
	.long	0x38d8c2c4
	.long	0x4fdff252
	.long	0xd1bb67f1
	.long	0xa6bc5767
	.long	0x3fb506dd
	.long	0x48b2364b
	.long	0xd80d2bda
	.long	0xaf0a1b4c
	.long	0x36034af6
	.long	0x41047a60
	.long	0xdf60efc3
	.long	0xa867df55
	.long	0x316e8eef
	.long	0x4669be79
	.long	0xcb61b38c
	.long	0xbc66831a
	.long	0x256fd2a0
	.long	0x5268e236
	.long	0xcc0c7795
	.long	0xbb0b4703
	.long	0x220216b9
	.long	0x5505262f
	.long	0xc5ba3bbe
	.long	0xb2bd0b28
	.long	0x2bb45a92
	.long	0x5cb36a04
	.long	0xc2d7ffa7
	.long	0xb5d0cf31
	.long	0x2cd99e8b
	.long	0x5bdeae1d
	.long	0x9b64c2b0
	.long	0xec63f226
	.long	0x756aa39c
	.long	0x026d930a
	.long	0x9c0906a9
	.long	0xeb0e363f
	.long	0x72076785
	.long	0x05005713
	.long	0x95bf4a82
	.long	0xe2b87a14
	.long	0x7bb12bae
	.long	0x0cb61b38
	.long	0x92d28e9b
	.long	0xe5d5be0d
	.long	0x7cdcefb7
	.long	0x0bdbdf21
	.long	0x86d3d2d4
	.long	0xf1d4e242
	.long	0x68ddb3f8
	.long	0x1fda836e
	.long	0x81be16cd
	.long	0xf6b9265b
	.long	0x6fb077e1
	.long	0x18b74777
	.long	0x88085ae6
	.long	0xff0f6a70
	.long	0x66063bca
	.long	0x11010b5c
	.long	0x8f659eff
	.long	0xf862ae69
	.long	0x616bffd3
	.long	0x166ccf45
	.long	0xa00ae278
	.long	0xd70dd2ee
	.long	0x4e048354
	.long	0x3903b3c2
	.long	0xa7672661
	.long	0xd06016f7
	.long	0x4969474d
	.long	0x3e6e77db
	.long	0xaed16a4a
	.long	0xd9d65adc
	.long	0x40df0b66
	.long	0x37d83bf0
	.long	0xa9bcae53
	.long	0xdebb9ec5
	.long	0x47b2cf7f
	.long	0x30b5ffe9
	.long	0xbdbdf21c
	.long	0xcabac28a
	.long	0x53b39330
	.long	0x24b4a3a6
	.long	0xbad03605
	.long	0xcdd70693
	.long	0x54de5729
	.long	0x23d967bf
	.long	0xb3667a2e
	.long	0xc4614ab8
	.long	0x5d681b02
	.long	0x2a6f2b94
	.long	0xb40bbe37
	.long	0xc30c8ea1
	.long	0x5a05df1b
	.long	0x2d02ef8d

	.align 4
.globl	_crc32
	.type	 _crc32, @function

/* unsigned int crc32(unsigned int const oldcrc, unsigned char const abyte); */

_crc32:

	movl	4(%esp), %eax
	movb	8(%esp), %dl
	xorb	%al, %dl
	movzbl	%dl, %edx
	shrl	$8, %eax
	xorl	crctable(,%edx,4), %eax
	ret

crcend:
	.size	 _crc32, crcend - _crc32

	.align 4
.globl	_initcrc32
	.type	_initcrc32, @function

/* unsigned int initcrc32(void); */

_initcrc32:

	movl	$-1, %eax
	ret

initcrcend:
	.size	_initcrc32, initcrcend - _initcrc32

	.align 4
.globl	_finishcrc32
	.type	_finishcrc32, @function

/* unsigned int finishcrc32(unsigned int const crc); */

_finishcrc32:

	movl	4(%esp), %eax
	notl	%eax
	ret

finishcrcend:
	.size	_finishcrc32, finishcrcend - _finishcrc32

	.align	4
.globl	arraycrc32
	.type	arraycrc32, @function

/* unsigned int arraycrc32(unsigned char const *bytearray, unsigned int const numbytes); */

arraycrc32:

	pushl	%ebx

/* Initialize CRC-32 to -1 */
	movl	$-1, %eax

	movl	12(%esp), %ecx
/* Quit if nothing to do */
	jecxz	done

	movl	8(%esp), %ebx
/* Avoid null pointer */
	orl	%ebx, %ebx
	je	done

crcloop:
	movb	(%ebx), %dl
	xorb	%al, %dl
	movzbl	%dl, %edx
	shrl	$8, %eax
	xorl	crctable(,%edx,4), %eax
	incl	%ebx
	loop	crcloop

	notl	%eax

done:
	popl	%ebx
	ret

arraycrcend:
	.size	arraycrc32, arraycrcend - arraycrc32

	.align	4
.globl	partialcrc32
	.type	partialcrc32, @function

/* unsigned int partialcrc32(unsigned int const oldcrc, unsigned char const *bytearray, unsigned int const numbytes); */

partialcrc32:

	pushl	%ebx

/* Get old CRC */
	movl	8(%esp), %eax

	movl	16(%esp), %ecx
	jecxz	pdone

	movl	12(%esp), %ebx
	orl	%ebx, %ebx
	je	pdone

ploop:
	movb	(%ebx), %dl
	xorb	%al, %dl
	movzbl	%dl, %edx
	shrl	$8, %eax
	xorl	crctable(,%edx,4), %eax
	incl	%ebx
	loop	ploop

pdone:
	popl	%ebx
	ret

partialcrcend:
	.size	partialcrc32, partialcrcend - partialcrc32
