/*
 * Fast CRC-32 include file.
 *
 * Version 1.00 (Unix)
 *
 * Copyright 1999 G. Adam Stanislav.
 * All rights reserved.
 *
 * You may use these routines in your programs freely
 * as long as you give me credit for them.
 *
 * See comments in crc.s for proper usage.
 */
#ifndef	FASTCRC32_H
#define	FASTCRC32_H

unsigned int crc32(unsigned int const, unsigned char const);

#ifdef	NOCRC32MACROS
unsigned int initcrc32(void);
unsigned int finishcrc32(unsigned int const);
#else
#define	initcrc32()	(0xFFFFFFFF)
#define	finishcrc32(x)	(~x)
#endif

/* unsigned int arraycrc32(unsigned char const *bytearray, unsigned int const numbytes); */
unsigned int arraycrc32(unsigned char const *, unsigned int const);

/* unsigned int partialcrc32(unsigned int const oldcrc, unsigned char const *bytearray, unsigned int const numbytes); */
unsigned int partialcrc32(unsigned int const, unsigned char const *, unsigned int const);

#endif
